/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.graphical;

import java.util.Collection;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.draw2d.IRootFigure;
import org.eclipse.wb.internal.draw2d.RootFigure;
import org.eclipse.wb.internal.draw2d.TargetFigureFindVisitor;
import org.eclipse.wb.internal.gef.core.AbstractEditPartViewer;
import org.eclipse.wb.internal.gef.core.EditDomain;
import org.eclipse.wb.internal.gef.core.TargetEditPartFindVisitor;
import org.eclipse.wb.internal.gef.graphical.EditEventManager;
import org.eclipse.wb.internal.gef.graphical.RootEditPart;

public class GraphicalViewer
extends AbstractEditPartViewer {
    protected final FigureCanvas m_canvas;
    private final RootEditPart m_rootEditPart;
    private EditEventManager m_eventManager;

    public GraphicalViewer(Composite parent) {
        this(parent, 768);
    }

    public GraphicalViewer(Composite parent, int style) {
        this(new FigureCanvas(parent, style){

            @Override
            protected void setDefaultEventManager() {
            }
        });
    }

    protected GraphicalViewer(FigureCanvas canvas) {
        this.m_canvas = canvas;
        this.m_rootEditPart = new RootEditPart(this, this.getRootFigure());
        this.m_rootEditPart.activate();
        this.setRootEditPart(this.m_rootEditPart);
    }

    public FigureCanvas getControl() {
        return this.m_canvas;
    }

    @Override
    public int getHOffset() {
        return this.m_canvas.getViewport().getHorizontalRangeModel().getValue();
    }

    @Override
    public int getVOffset() {
        return this.m_canvas.getViewport().getVerticalRangeModel().getValue();
    }

    public RootEditPart getRootEditPart() {
        return this.m_rootEditPart;
    }

    @Override
    public final IRootFigure getRootFigure() {
        return this.getRootFigureInternal();
    }

    protected final RootFigure getRootFigureInternal() {
        return this.m_canvas.getRootFigure();
    }

    @Override
    public Layer getLayer(String name) {
        return this.getRootFigure().getLayer(name);
    }

    @Override
    public void setEditDomain(EditDomain domain) {
        super.setEditDomain(domain);
        this.m_eventManager = new EditEventManager(this.m_canvas, domain, this);
        this.getRootFigureInternal().getFigureCanvas().getLightweightSystem().setEventDispatcher((EventDispatcher)this.m_eventManager);
    }

    public void setCursor(Cursor cursor) {
        this.m_eventManager.setOverrideCursor(cursor);
    }

    @Override
    public org.eclipse.wb.gef.core.EditPart findTargetEditPart(int x, int y, Collection<? extends EditPart> exclude, EditPartViewer.Conditional conditional) {
        org.eclipse.wb.gef.core.EditPart editPart = this.findTargetEditPart(x, y, exclude, conditional, "Menu Primary Layer");
        if (editPart == null) {
            editPart = this.findTargetEditPart(x, y, exclude, conditional, "Primary Layer");
        }
        return editPart;
    }

    @Override
    public org.eclipse.wb.gef.core.EditPart findTargetEditPart(int x, int y, final Collection<? extends EditPart> exclude, final EditPartViewer.Conditional conditional, String layer) {
        TargetEditPartFindVisitor visitor = new TargetEditPartFindVisitor(this.m_canvas, x, y, this){

            @Override
            protected boolean acceptVisit(Figure figure) {
                for (EditPart editPart : exclude) {
                    GraphicalEditPart graphicalPart = (GraphicalEditPart)editPart;
                    if (!ObjectUtils.equals((Object)((Object)figure), (Object)((Object)graphicalPart.getFigure()))) continue;
                    return false;
                }
                return true;
            }

            @Override
            protected boolean acceptResult(Figure figure) {
                org.eclipse.wb.gef.core.EditPart editPart = this.extractEditPart((IFigure)figure);
                return editPart != null && (conditional == null || conditional.evaluate((EditPart)editPart));
            }
        };
        this.getLayer(layer).accept(visitor, false);
        return visitor.getTargetEditPart();
    }

    @Override
    public Handle findTargetHandle(Point location) {
        return this.findTargetHandle(location.x, location.y);
    }

    @Override
    public Handle findTargetHandle(int x, int y) {
        Handle target = this.findTargetHandle("Menu Handle Layer static", x, y);
        if (target != null) {
            return target;
        }
        target = this.findTargetHandle("Menu Handle Layer", x, y);
        if (target != null) {
            return target;
        }
        target = this.findTargetHandle("Handle Layer Static", x, y);
        if (target != null) {
            return target;
        }
        target = this.findTargetHandle("Handle Layer", x, y);
        if (target != null) {
            return target;
        }
        return null;
    }

    private Handle findTargetHandle(String layer, int x, int y) {
        TargetFigureFindVisitor visitor = new TargetFigureFindVisitor(this.m_canvas, x, y);
        this.getLayer(layer).accept(visitor, false);
        Figure targetFigure = visitor.getTargetFigure();
        return targetFigure instanceof Handle ? (Handle)targetFigure : null;
    }
}

