/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.snapping;

import java.util.List;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.internal.core.gef.policy.snapping.IFeedbackProxy;
import org.eclipse.wb.internal.core.gef.policy.snapping.IVisualDataProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.core.gef.policy.snapping.SnapPoint;

public class ComponentSnapPoint
extends SnapPoint {
    protected final IAbstractComponentInfo m_anchorComponent;
    protected final boolean m_includeGap;
    protected int m_gap;
    protected Rectangle m_anchorChildBounds;

    public ComponentSnapPoint(IVisualDataProvider visualDataProvider, IAbstractComponentInfo anchorComponent, int side, int snapDirection) {
        this(visualDataProvider, anchorComponent, side, snapDirection, false);
    }

    public ComponentSnapPoint(IVisualDataProvider visualDataProvider, IAbstractComponentInfo anchorComponent, int side, int snapDirection, boolean includeGap) {
        super(visualDataProvider, side, snapDirection);
        this.m_anchorComponent = anchorComponent;
        this.m_includeGap = includeGap;
    }

    @Override
    protected void calculateSnapPoint(List<? extends IAbstractComponentInfo> beingSnappedList) {
        super.calculateSnapPoint(beingSnappedList);
        this.m_anchorChildBounds = PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, this.m_anchorComponent);
        this.m_gap = 0;
        switch (this.m_side) {
            case 1: {
                if (this.m_includeGap) {
                    this.m_gap = this.m_visualDataProvider.getComponentGapValue(this.m_nearestBeingSnapped, this.m_anchorComponent, 1);
                }
                this.m_snapPoint = this.m_anchorChildBounds.x - this.m_gap;
                break;
            }
            case 4: {
                if (this.m_includeGap) {
                    this.m_gap = this.m_visualDataProvider.getComponentGapValue(this.m_nearestBeingSnapped, this.m_anchorComponent, 4);
                }
                this.m_snapPoint = this.m_anchorChildBounds.right() + this.m_gap;
                break;
            }
            case 8: {
                if (this.m_includeGap) {
                    this.m_gap = this.m_visualDataProvider.getComponentGapValue(this.m_nearestBeingSnapped, this.m_anchorComponent, 8);
                }
                this.m_snapPoint = this.m_anchorChildBounds.y - this.m_gap;
                break;
            }
            case 32: {
                if (this.m_includeGap) {
                    this.m_gap = this.m_visualDataProvider.getComponentGapValue(this.m_nearestBeingSnapped, this.m_anchorComponent, 32);
                }
                this.m_snapPoint = this.m_includeGap ? this.m_anchorChildBounds.bottom() + this.m_gap : this.m_anchorChildBounds.bottom();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid side: " + this.m_side);
            }
        }
    }

    @Override
    protected Interval getXSnapInterval() {
        if (this.m_includeGap && !this.isHorizontal()) {
            return new Interval(this.m_anchorChildBounds.x, this.m_anchorChildBounds.width);
        }
        return super.getXSnapInterval();
    }

    @Override
    protected Interval getYSnapInterval() {
        if (this.m_includeGap && this.isHorizontal()) {
            return new Interval(this.m_anchorChildBounds.y, this.m_anchorChildBounds.height);
        }
        return super.getYSnapInterval();
    }

    @Override
    public void addFeedback(Rectangle snappedBounds, IFeedbackProxy feedbackProxy, List<Figure> feedbacks) {
        if (this.isHorizontal()) {
            feedbacks.add(this.addVerticalFeedback(this.m_snapPoint, feedbackProxy, snappedBounds));
        } else {
            feedbacks.add(this.addHorizontalFeedback(this.m_snapPoint, feedbackProxy, snappedBounds));
        }
    }

    protected Figure addHorizontalFeedback(int y, IFeedbackProxy feedbackProxy, Rectangle snappedBounds) {
        Rectangle anchorChildBounds = PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, this.m_anchorComponent);
        Rectangle unionBounds = snappedBounds.getUnion(anchorChildBounds);
        unionBounds.expand(8, 0);
        return feedbackProxy.addHorizontalFeedbackLine(y, unionBounds.x, unionBounds.width);
    }

    protected Figure addVerticalFeedback(int x, IFeedbackProxy feedbackProxy, Rectangle snappedBounds) {
        Rectangle anchorChildBounds = PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, this.m_anchorComponent);
        Rectangle unionBounds = snappedBounds.getUnion(anchorChildBounds);
        unionBounds.expand(0, 8);
        return feedbackProxy.addVerticalFeedbackLine(x, unionBounds.y, unionBounds.height);
    }

    @Override
    protected boolean snapAllowed(List<? extends IAbstractComponentInfo> beingSnappedList) {
        return !beingSnappedList.contains(this.m_anchorComponent);
    }

    @Override
    protected String getObjectInfo() {
        return " component=" + String.valueOf(this.m_anchorComponent) + " gap=" + this.m_includeGap;
    }

    public final IAbstractComponentInfo getComponent() {
        return this.m_anchorComponent;
    }

    public final int getGap() {
        return this.m_gap;
    }
}

