/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.layout.generic;

import java.lang.reflect.Constructor;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.gef.EditPolicy;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.IParametersProvider;

public final class SelectionEditPolicyInstaller {
    private final Object container;
    private final String containerClassName;
    private final EditPart childPart;
    private final Object child;

    public SelectionEditPolicyInstaller(Object _container, EditPart _childPart) {
        this.container = _container;
        this.containerClassName = this.container.getClass().getName();
        this.childPart = _childPart;
        this.child = this.childPart.getModel();
    }

    public void decorate() {
        IParametersProvider parametersProvider = GlobalState.getParametersProvider();
        String packageName = StringUtils.substringBeforeLast((String)this.containerClassName, (String)".model.");
        if (this.decorate(packageName)) {
            return;
        }
        int i = 1;
        while (i < 10) {
            String parameterName = "GEF.relatedToolkitPackages." + i;
            String packageName2 = parametersProvider.getParameter(this.container, parameterName);
            if (packageName2 != null && this.decorate(packageName2)) {
                return;
            }
            ++i;
        }
        String policyClassName = parametersProvider.getParameter(this.container, "GEF.defaultSelectionPolicy");
        if (!StringUtils.isBlank((CharSequence)policyClassName)) {
            policyClassName = policyClassName.trim();
            try {
                ClassLoader classLoader = this.container.getClass().getClassLoader();
                Class<?> policyClass = classLoader.loadClass(policyClassName);
                SelectionEditPolicy policy = this.createPolicy(policyClass);
                if (policy != null) {
                    this.childPart.installEditPolicy("Selection Feedback", (EditPolicy)policy);
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private boolean decorate(String packageName) {
        Class<?> policyClass = this.loadClass(packageName);
        if (policyClass == null) {
            return false;
        }
        SelectionEditPolicy policy = this.createPolicy(policyClass);
        if (policy != null) {
            this.childPart.installEditPolicy("Selection Feedback", (EditPolicy)policy);
        }
        return true;
    }

    private Class<?> loadClass(String basePackageName) {
        String containerName = StringUtils.substringAfterLast((String)this.containerClassName, (String)".model.");
        containerName = StringUtils.removeEnd((String)containerName, (String)"Info");
        String childClassName = this.child.getClass().getName();
        String childName = StringUtils.substringAfterLast((String)childClassName, (String)".");
        Class<?> clazz = this.loadClass2(basePackageName, containerName + (childName = StringUtils.removeEnd((String)childName, (String)"Info")));
        if (clazz != null) {
            return clazz;
        }
        Class<?> clazz2 = this.loadClass2(basePackageName, containerName);
        if (clazz2 != null) {
            return clazz2;
        }
        return null;
    }

    private Class<?> loadClass2(String basePackageName, String name) {
        String baseClassName = basePackageName + ".gef.policy." + name + "SelectionEditPolicy";
        String packageName = StringUtils.substringBeforeLast((String)baseClassName, (String)".");
        String className = StringUtils.substringAfterLast((String)baseClassName, (String)".");
        ClassLoader classLoader = this.container.getClass().getClassLoader();
        while (packageName.contains(".")) {
            try {
                String policyClassName = packageName + "." + className;
                return classLoader.loadClass(policyClassName);
            }
            catch (Throwable throwable) {
                packageName = StringUtils.substringBeforeLast((String)packageName, (String)".");
            }
        }
        return null;
    }

    private SelectionEditPolicy createPolicy(Class<?> selectionPolicyClass) {
        Constructor<?> constructor = selectionPolicyClass.getConstructors()[0];
        try {
            return (SelectionEditPolicy)((Object)constructor.newInstance(this.container, this.child));
        }
        catch (Throwable throwable) {
            try {
                return (SelectionEditPolicy)((Object)constructor.newInstance(this.child));
            }
            catch (Throwable throwable2) {
                try {
                    return (SelectionEditPolicy)((Object)constructor.newInstance(this.container));
                }
                catch (Throwable throwable3) {
                    try {
                        return (SelectionEditPolicy)((Object)constructor.newInstance(new Object[0]));
                    }
                    catch (Throwable throwable4) {
                        return null;
                    }
                }
            }
        }
    }
}

