/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ast.binding;

import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.wb.internal.core.utils.ast.binding.BindingContext;

public final class DesignerMethodBinding
implements IMethodBinding {
    private final String m_name;
    private final int m_modifiers;
    private final boolean m_constructor;
    private final boolean m_varargs;
    private final ITypeBinding m_declaringClass;
    private final ITypeBinding m_returnType;
    private ITypeBinding[] m_parameterTypes;
    private String[] m_parameterNames;
    private ITypeBinding[] m_exceptionTypes;
    private DesignerMethodBinding m_methodDeclaration;

    DesignerMethodBinding(BindingContext context, IMethodBinding binding) {
        this.m_name = binding.getName();
        this.m_modifiers = binding.getModifiers();
        this.m_constructor = binding.isConstructor();
        this.m_varargs = binding.isVarargs();
        this.m_declaringClass = context.get(binding.getDeclaringClass());
        this.m_returnType = context.get(binding.getReturnType());
        this.m_parameterNames = binding.getParameterNames();
        ITypeBinding[] parameterTypes = binding.getParameterTypes();
        this.m_parameterTypes = new ITypeBinding[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            ITypeBinding parameterType = parameterTypes[i];
            this.m_parameterTypes[i] = context.get(parameterType);
            ++i;
        }
        ITypeBinding[] exceptionTypes = binding.getExceptionTypes();
        this.m_exceptionTypes = new ITypeBinding[exceptionTypes.length];
        i = 0;
        while (i < exceptionTypes.length) {
            ITypeBinding exceptionType = exceptionTypes[i];
            this.m_exceptionTypes[i] = context.get(exceptionType);
            ++i;
        }
        IMethodBinding methodDeclaration = binding.getMethodDeclaration();
        this.m_methodDeclaration = methodDeclaration == binding ? this : context.get(methodDeclaration);
    }

    public void removeParameterType(int index) {
        this.m_parameterTypes = (ITypeBinding[])ArrayUtils.remove((Object[])this.m_parameterTypes, (int)index);
        this.m_parameterNames = (String[])ArrayUtils.remove((Object[])this.m_parameterNames, (int)index);
        if (this.m_methodDeclaration != this) {
            this.m_methodDeclaration.removeParameterType(index);
        }
    }

    public void addExceptionType(ITypeBinding newException) {
        this.m_exceptionTypes = (ITypeBinding[])ArrayUtils.add((Object[])this.m_exceptionTypes, (Object)newException);
    }

    public String toString() {
        throw new IllegalArgumentException();
    }

    public ITypeBinding getDeclaringClass() {
        return this.m_declaringClass;
    }

    public Object getDefaultValue() {
        throw new IllegalArgumentException();
    }

    public ITypeBinding[] getExceptionTypes() {
        return this.m_exceptionTypes;
    }

    public IMethodBinding getMethodDeclaration() {
        return this.m_methodDeclaration;
    }

    public String getName() {
        return this.m_name;
    }

    public IAnnotationBinding[] getParameterAnnotations(int paramIndex) {
        throw new IllegalArgumentException();
    }

    public ITypeBinding[] getParameterTypes() {
        return this.m_parameterTypes;
    }

    public String[] getParameterNames() {
        return this.m_parameterNames;
    }

    public ITypeBinding getReturnType() {
        return this.m_returnType;
    }

    public ITypeBinding getDeclaredReceiverType() {
        throw new IllegalArgumentException();
    }

    public ITypeBinding[] getTypeArguments() {
        throw new IllegalArgumentException();
    }

    public ITypeBinding[] getTypeParameters() {
        throw new IllegalArgumentException();
    }

    public boolean isAnnotationMember() {
        throw new IllegalArgumentException();
    }

    public boolean isConstructor() {
        return this.m_constructor;
    }

    public boolean isDefaultConstructor() {
        throw new IllegalArgumentException();
    }

    public boolean isGenericMethod() {
        throw new IllegalArgumentException();
    }

    public boolean isParameterizedMethod() {
        throw new IllegalArgumentException();
    }

    public boolean isRawMethod() {
        throw new IllegalArgumentException();
    }

    public boolean isSubsignature(IMethodBinding otherMethod) {
        throw new IllegalArgumentException();
    }

    public boolean isVarargs() {
        return this.m_varargs;
    }

    public boolean overrides(IMethodBinding method) {
        throw new IllegalArgumentException();
    }

    public IAnnotationBinding[] getAnnotations() {
        throw new IllegalArgumentException();
    }

    public IJavaElement getJavaElement() {
        throw new IllegalArgumentException();
    }

    public String getKey() {
        throw new IllegalArgumentException();
    }

    public int getKind() {
        throw new IllegalArgumentException();
    }

    public int getModifiers() {
        return this.m_modifiers;
    }

    public boolean isDeprecated() {
        throw new IllegalArgumentException();
    }

    public boolean isEqualTo(IBinding binding) {
        throw new IllegalArgumentException();
    }

    public boolean isSynthetic() {
        throw new IllegalArgumentException();
    }

    public boolean isRecovered() {
        throw new IllegalArgumentException();
    }

    public IBinding getDeclaringMember() {
        return null;
    }

    public IVariableBinding[] getSyntheticOuterLocals() {
        return null;
    }

    public boolean isCompactConstructor() {
        return false;
    }

    public boolean isCanonicalConstructor() {
        return false;
    }

    public boolean isSyntheticRecordMethod() {
        return false;
    }
}

