/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.java.ui.Messages;

public class LandmarkMarkerManager
extends AbstractContextListener {
    private static final String ID_MARKER_LANDMARK = "org.eclipse.mylyn.context.ui.markers.landmark";
    private final Map<IInteractionElement, Long> markerMap = new ConcurrentHashMap<IInteractionElement, Long>();
    private final LandmarkUpdateJob updateJob = new LandmarkUpdateJob(Messages.LandmarkMarkerManager_Updating_Landmark_Markers);

    public void contextChanged(ContextChangeEvent event) {
        LinkedHashSet<LandmarkUpdateOperation> runnables = new LinkedHashSet<LandmarkUpdateOperation>();
        switch (event.getEventKind()) {
            case ACTIVATED: 
            case DEACTIVATED: {
                this.modelUpdated();
                break;
            }
            case CLEARED: {
                if (!event.isActiveContext()) break;
                this.modelUpdated();
                break;
            }
            case LANDMARKS_ADDED: {
                for (IInteractionElement element : event.getElements()) {
                    LandmarkUpdateOperation runnable = this.createAddLandmarkMarkerOperation(element);
                    if (runnable == null) continue;
                    runnables.add(runnable);
                }
                break;
            }
            case LANDMARKS_REMOVED: 
            case ELEMENTS_DELETED: {
                for (IInteractionElement element : event.getElements()) {
                    LandmarkUpdateOperation runnable = this.createRemoveLandmarkMarkerOperation(element);
                    if (runnable == null) continue;
                    runnables.add(runnable);
                }
                break;
            }
        }
        this.updateJob.updateMarkers(runnables);
    }

    private void modelUpdated() {
        try {
            LandmarkUpdateOperation runnable;
            LinkedHashSet<LandmarkUpdateOperation> runnables = new LinkedHashSet<LandmarkUpdateOperation>();
            for (IInteractionElement node : this.markerMap.keySet()) {
                runnable = this.createRemoveLandmarkMarkerOperation(node);
                if (runnable == null) continue;
                runnables.add(runnable);
            }
            this.markerMap.clear();
            for (IInteractionElement node : ContextCore.getContextManager().getActiveLandmarks()) {
                runnable = this.createAddLandmarkMarkerOperation(node);
                if (runnable == null) continue;
                runnables.add(runnable);
            }
            this.updateJob.updateMarkers(runnables);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not update landmark markers", t));
        }
    }

    private LandmarkUpdateOperation createAddLandmarkMarkerOperation(final IInteractionElement node) {
        if (node == null || node.getContentType() == null) {
            return null;
        }
        if ("java".equals(node.getContentType())) {
            IJavaElement element = JavaCore.create((String)node.getHandleIdentifier());
            if (!element.exists()) {
                return null;
            }
            if (element instanceof IMember) {
                try {
                    final ISourceRange range = ((IMember)element).getNameRange();
                    IResource resource = element.getUnderlyingResource();
                    if (resource instanceof IFile) {
                        LandmarkUpdateOperation runnable = new LandmarkUpdateOperation(this, resource){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                IMarker marker = this.getResource().createMarker(LandmarkMarkerManager.ID_MARKER_LANDMARK);
                                if (marker != null && range != null) {
                                    marker.setAttribute("charStart", range.getOffset());
                                    marker.setAttribute("charEnd", range.getOffset() + range.getLength());
                                    marker.setAttribute("message", (Object)Messages.LandmarkMarkerManager_Mylyn_Landmark);
                                    marker.setAttribute("severity", 0);
                                    markerMap.put(node, marker.getId());
                                }
                            }
                        };
                        return runnable;
                    }
                }
                catch (JavaModelException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not update marker", (Throwable)e));
                }
            }
        }
        return null;
    }

    private LandmarkUpdateOperation createRemoveLandmarkMarkerOperation(final IInteractionElement node) {
        if (node == null) {
            return null;
        }
        if ("java".equals(node.getContentType())) {
            IJavaElement element = JavaCore.create((String)node.getHandleIdentifier());
            if (!element.exists()) {
                return null;
            }
            if (element.getAncestor(5) != null && element instanceof ISourceReference) {
                try {
                    IResource resource = element.getUnderlyingResource();
                    LandmarkUpdateOperation runnable = new LandmarkUpdateOperation(this, resource){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            if (this.getResource() != null) {
                                try {
                                    if (markerMap.containsKey(node)) {
                                        long id = markerMap.get(node);
                                        IMarker marker = this.getResource().getMarker(id);
                                        if (marker != null) {
                                            marker.delete();
                                        }
                                    }
                                }
                                catch (NullPointerException e) {
                                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not update marker", (Throwable)e));
                                }
                            }
                        }
                    };
                    return runnable;
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private class LandmarkUpdateJob
    extends Job {
        private static final int NOT_SCHEDULED = -1;
        private final LinkedHashSet<LandmarkUpdateOperation> queue;
        private long scheduleTime;

        public LandmarkUpdateJob(String name) {
            super(name);
            this.queue = new LinkedHashSet();
            this.scheduleTime = -1L;
            this.setSystem(true);
        }

        public synchronized void updateMarkers(LinkedHashSet<LandmarkUpdateOperation> operations) {
            this.queue.addAll(operations);
            if (this.queue.size() > 0 && this.scheduleTime == -1L) {
                this.scheduleTime = System.currentTimeMillis();
                this.schedule();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (workspace == null) {
                return Status.CANCEL_STATUS;
            }
            LinkedHashSet<LandmarkUpdateOperation> operations = null;
            LandmarkUpdateJob landmarkUpdateJob = this;
            synchronized (landmarkUpdateJob) {
                operations = new LinkedHashSet<LandmarkUpdateOperation>(this.queue);
                this.queue.clear();
                this.scheduleTime = -1L;
            }
            if (operations != null) {
                try {
                    monitor.beginTask(Messages.LandmarkMarkerManager_Updating_Landmark_Markers, operations.size());
                    for (LandmarkUpdateOperation runnable : operations) {
                        try {
                            workspace.run((IWorkspaceRunnable)runnable, (ISchedulingRule)runnable.getResource(), 1, monitor);
                        }
                        catch (CoreException e) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not update landmark marker", (Throwable)e));
                        }
                        catch (OperationCanceledException e) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            monitor.done();
                            return iStatus;
                        }
                        monitor.worked(1);
                    }
                }
                finally {
                    monitor.done();
                }
            }
            return Status.OK_STATUS;
        }
    }

    private abstract class LandmarkUpdateOperation
    implements IWorkspaceRunnable {
        private final IResource resource;

        public LandmarkUpdateOperation(IResource resource) {
            Assert.isNotNull((Object)resource);
            this.resource = resource;
        }

        public IResource getResource() {
            return this.resource;
        }
    }
}

