/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryAdapter;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.IArchiveFile;

public class ArchiveView
implements IArchiveFile {
    private boolean sharedArchive = false;
    private IArchiveFile view = null;
    private IArchiveFile archive = null;
    private HashSet<ViewEntry> openedEntries = new HashSet();

    public ArchiveView(IArchiveFile view, IArchiveFile archive, boolean sharedArchive) {
        this.view = view;
        this.archive = archive;
        this.sharedArchive = sharedArchive;
    }

    public ArchiveView(String viewName, String archiveName, String viewMode) throws IOException {
        this.view = new ArchiveFile(viewName, viewMode);
        this.archive = new ArchiveFile(archiveName, "r");
        this.sharedArchive = false;
    }

    public ArchiveView(String viewName, IArchiveFile archive, String viewMode) throws IOException {
        this.view = new ArchiveFile(viewName, viewMode);
        this.archive = archive;
        this.sharedArchive = true;
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            for (ViewEntry entry : this.openedEntries) {
                entry.doClose();
            }
            this.openedEntries.clear();
        }
        finally {
            try {
                if (!this.sharedArchive) {
                    this.archive.close();
                }
            }
            finally {
                this.view.close();
            }
        }
    }

    @Override
    public synchronized boolean exists(String name) {
        return this.view.exists(name) || this.archive.exists(name);
    }

    @Override
    public synchronized ArchiveEntry openEntry(String name) throws IOException {
        if (this.view.exists(name)) {
            ArchiveEntry entry = this.view.openEntry(name);
            return new ViewEntry(this, name, entry);
        }
        if (this.archive.exists(name)) {
            ArchiveEntry entry = this.archive.openEntry(name);
            return new ViewEntry(this, name, entry);
        }
        throw new FileNotFoundException(name);
    }

    @Override
    public synchronized List<String> listEntries(String namePattern) {
        List<String> viewList = this.view.listEntries(namePattern);
        List<String> archiveList = this.archive.listEntries(namePattern);
        if (archiveList.isEmpty()) {
            return viewList;
        }
        LinkedHashSet<String> entries = new LinkedHashSet<String>(viewList);
        entries.addAll(archiveList);
        return new ArrayList<String>(entries);
    }

    @Override
    public synchronized Object lockEntry(String entry) throws IOException {
        if (this.view.exists(entry)) {
            return this.view.lockEntry(entry);
        }
        if (this.archive.exists(entry)) {
            return this.archive.lockEntry(entry);
        }
        return this.view.lockEntry(entry);
    }

    @Override
    public void refresh() throws IOException {
        this.view.refresh();
    }

    @Override
    public String getSystemId() {
        return this.view.getSystemId();
    }

    @Override
    public String getDependId() {
        return this.archive.getSystemId();
    }

    protected synchronized void openEntry(ViewEntry entry) {
        this.openedEntries.add(entry);
    }

    protected synchronized void closeEntry(ViewEntry entry) {
        this.openedEntries.remove(entry);
    }

    @Override
    public ArchiveEntry createEntry(String name) throws IOException {
        return this.view.createEntry(name);
    }

    @Override
    public synchronized void flush() throws IOException {
        for (ViewEntry entry : this.openedEntries) {
            entry.flush();
        }
        this.view.flush();
    }

    @Override
    public void save() throws IOException {
        this.view.save();
    }

    @Override
    public String getName() {
        return this.view.getName();
    }

    @Override
    public long getUsedCache() {
        return this.view.getUsedCache();
    }

    @Override
    public boolean removeEntry(String name) throws IOException {
        return this.view.removeEntry(name);
    }

    @Override
    public void setCacheSize(long cacheSize) {
        this.view.setCacheSize(cacheSize);
    }

    @Override
    public synchronized void unlockEntry(Object locker) throws IOException {
        try {
            this.view.unlockEntry(locker);
        }
        catch (FileNotFoundException ex) {
            this.archive.unlockEntry(locker);
        }
    }

    public IArchiveFile getArchive() {
        return this.archive;
    }

    public IArchiveFile getView() {
        return this.view;
    }

    @Override
    public long getLength() {
        return this.view == null ? 0L : this.view.getLength();
    }

    static class ViewEntry
    extends ArchiveEntryAdapter {
        protected ArchiveView view;
        protected boolean writable = false;

        ViewEntry(ArchiveView view, String name, ArchiveEntry entry) {
            super(name, entry);
            this.view = view;
            view.openEntry(this);
        }

        @Override
        public void close() throws IOException {
            this.view.closeEntry(this);
            this.doClose();
        }

        private void doClose() throws IOException {
            super.close();
        }

        @Override
        protected void setOutputStream(RAOutputStream output) {
            this.output = output;
        }

        @Override
        public void flush() throws IOException {
            if (this.output != null) {
                this.output.flush();
            }
            this.entry.flush();
        }

        @Override
        public void write(long pos, byte[] b, int off, int len) throws IOException {
            this.ensureWritable();
            this.entry.write(pos, b, off, len);
        }

        protected void ensureWritable() throws IOException {
            if (!this.writable) {
                ArchiveEntry viewEntry = this.view.createEntry(this.entry.getName());
                try {
                    this.copyEntry(this.entry, viewEntry);
                }
                finally {
                    this.entry.close();
                }
                this.entry = viewEntry;
                this.writable = true;
            }
        }

        private void copyEntry(ArchiveEntry src, ArchiveEntry tgt) throws IOException {
            byte[] b = new byte[4096];
            long length = src.getLength();
            long pos = 0L;
            while (pos < length) {
                int size = src.read(pos, b, 0, 4096);
                tgt.write(pos, b, 0, size);
                pos += (long)size;
            }
        }
    }
}

