/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.helpers;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wb.core.databinding.xsd.component.ContextFactory;
import org.eclipse.wb.core.databinding.xsd.component.Factory;
import org.eclipse.wb.core.databinding.xsd.component.MethodParameter;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.description.AbstractInvocationDescription;
import org.eclipse.wb.internal.core.model.description.CreationInvocationDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.EditorStateLoadingContext;
import org.eclipse.wb.internal.core.model.description.helpers.ILoadingContext;
import org.eclipse.wb.internal.core.model.description.resource.ResourceInfo;
import org.eclipse.wb.internal.core.model.description.rules.StandardBeanPropertiesRule;
import org.eclipse.wb.internal.core.nls.Messages;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.JavaDocUtils;
import org.eclipse.wb.internal.core.utils.reflect.ClassMap;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FactoryDescriptionHelper {
    @Deprecated(forRemoval=true)
    private static final String DEFAULT_URI = "http://www.eclipse.org/wb/WBPComponent";
    private static final ClassMap<Map<String, FactoryMethodDescription>[]> m_descriptionMaps = ClassMap.create();
    private static final String WBP_FACTORY_TAG = "@wbp.factory";
    private static final String WBP_FACTORY_PARAMETER_SOURCE_TAG = "@wbp.factory.parameter.source ";
    private static final String WBP_FACTORY_PARAMETER_PROPERTY_TAG = "@wbp.factory.parameter.property ";
    private static final String WBP_FACTORY_PARAMETERS_NO_BINDING = "@wbp.factory.parameters.noBinding";

    private FactoryDescriptionHelper() {
    }

    public static Map<String, FactoryMethodDescription> getDescriptionsMap(AstEditor editor, Class<?> factoryClass, boolean forStatic) throws Exception {
        int index;
        TreeMap<String, FactoryMethodDescription> signaturesMap;
        Map[] signaturesMaps = (Map[])m_descriptionMaps.get(factoryClass);
        if (signaturesMaps == null) {
            signaturesMaps = new Map[2];
            m_descriptionMaps.put(factoryClass, (Object)signaturesMaps);
        }
        if ((signaturesMap = signaturesMaps[index = forStatic ? 0 : 1]) == null) {
            signaturesMaps[index] = signaturesMap = new TreeMap<String, FactoryMethodDescription>();
            Map<String, FactoryMethodDescription> map = FactoryDescriptionHelper.getDescriptionsMap0(editor, factoryClass, forStatic);
            signaturesMap.putAll(map);
            Class<?> superFactoryClass = factoryClass.getSuperclass();
            if (superFactoryClass != null) {
                Map<String, FactoryMethodDescription> map2 = FactoryDescriptionHelper.getDescriptionsMap(editor, superFactoryClass, forStatic);
                signaturesMap.putAll(map2);
            }
        }
        return signaturesMap;
    }

    private static Map<String, FactoryMethodDescription> getDescriptionsMap0(AstEditor editor, Class<?> factoryClass, boolean forStatic) throws Exception {
        try {
            return FactoryDescriptionHelper.getDescriptionsMap0Ex(editor, factoryClass, forStatic);
        }
        catch (Throwable e) {
            EditorState.get(editor).addWarning(new EditorWarning("Can not get factory methods for " + String.valueOf(factoryClass), e));
            return new TreeMap<String, FactoryMethodDescription>();
        }
    }

    private static Map<String, FactoryMethodDescription> getDescriptionsMap0Ex(AstEditor editor, Class<?> factoryClass, boolean forStatic) throws Exception {
        FactoryMethodDescription description;
        EditorState state = EditorState.get(editor);
        ILoadingContext context = EditorStateLoadingContext.get(state);
        Map<String, FactoryMethodDescription> signaturesMap = state.getFactorySignatures(factoryClass, forStatic);
        if (signaturesMap != null) {
            return signaturesMap;
        }
        String factoryClassName = factoryClass.getName();
        IType factoryType = editor.getJavaProject().findType(factoryClassName);
        if (factoryType == null) {
            return new TreeMap<String, FactoryMethodDescription>();
        }
        Boolean allMethodsAreFactories = null;
        List<Object> descriptions = new ArrayList();
        String descriptionName = factoryClassName.replace('.', '/') + ".wbp-factory.xml";
        ResourceInfo resourceInfo = DescriptionHelper.getResourceInfo(context, factoryClass, descriptionName);
        if (resourceInfo != null) {
            boolean showDeprecationWarning = false;
            try {
                Throwable throwable = null;
                Object var13_27 = null;
                try (InputStream is = resourceInfo.getURL().openStream();){
                    DocumentBuilderFactory documentBuildFactory = DocumentBuilderFactory.newInstance();
                    documentBuildFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = documentBuildFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(is);
                    Element rootElement = document.getDocumentElement();
                    if (rootElement.getAttribute("xmlns").isBlank()) {
                        showDeprecationWarning = true;
                        FactoryDescriptionHelper.fixNamespace(document, rootElement);
                    }
                    JAXBContext jaxbContext = ContextFactory.createContext();
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    Factory factory = (Factory)jaxbUnmarshaller.unmarshal((Source)new DOMSource(document));
                    descriptions = FactoryDescriptionHelper.process(factory, state, factoryClass);
                    allMethodsAreFactories = factory.isAllMethodsAreFactories();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                if (showDeprecationWarning) {
                    String message = NLS.bind((String)Messages.FactoryDescriptionHelper_deprecatedNamespace, (Object)resourceInfo.getURL().getFile());
                    DesignerPlugin.log((IStatus)Status.warning((String)message));
                }
            }
        }
        TreeMap<String, FactoryMethodDescription> signaturesMap2 = new TreeMap<String, FactoryMethodDescription>();
        for (FactoryMethodDescription factoryMethodDescription : descriptions) {
            signaturesMap2.put(factoryMethodDescription.getSignature(), factoryMethodDescription);
        }
        if (allMethodsAreFactories == null) {
            allMethodsAreFactories = FactoryDescriptionHelper.hasFactorySuffix(factoryType) || FactoryDescriptionHelper.hasFactoryTag(factoryType);
        }
        if (!allMethodsAreFactories.booleanValue() && descriptions.isEmpty() && !FactoryDescriptionHelper.hasFactoryTagSource(factoryType)) {
            return new TreeMap<String, FactoryMethodDescription>();
        }
        Method[] methodArray = factoryClass.getDeclaredMethods();
        String[] signatures = new String[methodArray.length];
        int methodIndex = 0;
        while (methodIndex < methodArray.length) {
            Class<?> returnType;
            Method factoryMethod = methodArray[methodIndex];
            int modifiers = factoryMethod.getModifiers();
            if (!(!FactoryDescriptionHelper.hasValidVisibility(editor, factoryMethod) || forStatic && !Modifier.isStatic(modifiers) || (returnType = factoryMethod.getReturnType()).isPrimitive() || factoryMethod.getParameterTypes().length == 0 && factoryMethod.getName().startsWith("get"))) {
                signatures[methodIndex] = ReflectionUtils.getMethodSignature((Method)factoryMethod);
            }
            ++methodIndex;
        }
        IMethod[] modelMethods = CodeUtils.findMethods(factoryType, signatures);
        int methodIndex2 = 0;
        while (methodIndex2 < methodArray.length) {
            Method factoryMethod = methodArray[methodIndex2];
            IMethod modelMethod = modelMethods[methodIndex2];
            if (modelMethod != null) {
                String signature = ReflectionUtils.getMethodSignature((Method)factoryMethod);
                FactoryMethodDescription description3 = (FactoryMethodDescription)signaturesMap2.get(signature);
                if (description3 == null) {
                    description3 = new FactoryMethodDescription(factoryClass);
                    description3.setName(factoryMethod.getName());
                    description3.setFactory(allMethodsAreFactories);
                    signaturesMap2.put(signature, description3);
                }
                description3.setModelMethod(modelMethod);
                description3.setReturnClass(factoryMethod.getReturnType());
                Class<?>[] parameterTypes = factoryMethod.getParameterTypes();
                int parameterIndex = 0;
                while (parameterIndex < parameterTypes.length) {
                    Class<?> parameterType = parameterTypes[parameterIndex];
                    if (parameterIndex < description3.getParameters().size()) {
                        parameterDescription = description3.getParameter(parameterIndex);
                    } else {
                        parameterDescription = new ParameterDescription();
                        parameterDescription.setType(parameterType);
                        description3.addParameter(parameterDescription);
                    }
                    ++parameterIndex;
                }
                description3.postProcess();
                if (!description3.isFactory()) {
                    FactoryDescriptionHelper.updateDescriptionsJavaDoc0(editor, description3);
                }
            }
            ++methodIndex2;
        }
        Iterator iterator = signaturesMap2.values().iterator();
        while (iterator.hasNext()) {
            description = (FactoryMethodDescription)iterator.next();
            Method method = ReflectionUtils.getMethodBySignature(factoryClass, (String)description.getSignature());
            int modifiers = method.getModifiers();
            if (!(forStatic ^ Modifier.isStatic(modifiers))) continue;
            iterator.remove();
        }
        Iterator iterator2 = signaturesMap2.values().iterator();
        while (iterator2.hasNext()) {
            description = (FactoryMethodDescription)iterator2.next();
            if (description.isFactory()) continue;
            iterator2.remove();
        }
        for (FactoryMethodDescription factoryMethodDescription : signaturesMap2.values()) {
            FactoryDescriptionHelper.updateDescriptionsJavaDoc(editor, factoryMethodDescription);
        }
        for (Map.Entry entry : signaturesMap2.entrySet()) {
            FactoryMethodDescription description4 = (FactoryMethodDescription)entry.getValue();
            String signature = (String)entry.getKey();
            String signatureUnix = StringUtils.replaceChars((String)signature, (String)"(,)", (String)"___");
            String iconPath = factoryClassName.replace('.', '/') + "." + signatureUnix;
            ImageDescriptor icon = DescriptionHelper.getIcon(context, iconPath);
            description4.setIcon(icon);
        }
        state.putFactorySignatures(factoryClass, forStatic, signaturesMap2);
        return signaturesMap2;
    }

    /*
     * WARNING - void declaration
     */
    private static void fixNamespace(Document document, Element element) {
        document.renameNode(element, DEFAULT_URI, element.getNodeName());
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node instanceof Element) {
                void child;
                Element cfr_ignored_0 = (Element)node;
                Element cfr_ignored_1 = (Element)node;
                FactoryDescriptionHelper.fixNamespace(document, (Element)child);
            }
            ++i;
        }
    }

    private static boolean hasValidVisibility(AstEditor editor, Method factoryMethod) {
        String factoryTypeName;
        String editorTypeName = editor.getModelUnit().findPrimaryType().getFullyQualifiedName();
        if (editorTypeName.equals(factoryTypeName = factoryMethod.getDeclaringClass().getName())) {
            return true;
        }
        int modifiers = factoryMethod.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public static FactoryMethodDescription getDescription(AstEditor editor, Class<?> factoryClass, String methodSignature, boolean forStatic) throws Exception {
        Map<String, FactoryMethodDescription> signaturesMap = FactoryDescriptionHelper.getDescriptionsMap(editor, factoryClass, forStatic);
        return signaturesMap.get(methodSignature);
    }

    public static List<ICompilationUnit> getFactoryUnits(AstEditor editor, IPackageFragment thePackage) throws Exception {
        ArrayList<ICompilationUnit> factoryUnits = new ArrayList<ICompilationUnit>();
        ICompilationUnit[] iCompilationUnitArray = thePackage.getCompilationUnits();
        int n = iCompilationUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit unit = iCompilationUnitArray[n2];
            IType primaryType = unit.findPrimaryType();
            if (primaryType != null) {
                String typeName = primaryType.getFullyQualifiedName();
                if (typeName.endsWith("Factory") && FactoryDescriptionHelper.isFactoryClass(editor, typeName)) {
                    factoryUnits.add(unit);
                } else {
                    String source = unit.getSource();
                    if (source != null && source.contains(WBP_FACTORY_TAG) && FactoryDescriptionHelper.isFactoryClass(editor, typeName)) {
                        factoryUnits.add(unit);
                    } else {
                        String descriptionName = typeName.replace('.', '/') + ".wbp-factory.xml";
                        ClassLoader classLoader = EditorState.get(editor).getEditorLoader();
                        if (classLoader.getResource(descriptionName) != null && FactoryDescriptionHelper.isFactoryClass(editor, typeName)) {
                            factoryUnits.add(unit);
                        }
                    }
                }
            }
            ++n2;
        }
        return factoryUnits;
    }

    public static boolean isFactoryClass(final AstEditor editor, final String typeName) {
        return (Boolean)ExecutionUtils.runObjectIgnore((RunnableObjectEx)new RunnableObjectEx<Boolean>(){

            public Boolean runObject() throws Exception {
                ClassLoader classLoader = EditorState.get(editor).getEditorLoader();
                Class<?> clazz = classLoader.loadClass(typeName);
                if (FactoryDescriptionHelper.getDescriptionsMap(editor, clazz, true).isEmpty() && FactoryDescriptionHelper.getDescriptionsMap(editor, clazz, false).isEmpty()) {
                    return false;
                }
                return true;
            }
        }, (Object)false);
    }

    public static boolean isFactoryInvocation(final AstEditor editor, final MethodInvocation invocation) {
        return (Boolean)ExecutionUtils.runObjectIgnore((RunnableObjectEx)new RunnableObjectEx<Boolean>(){

            public Boolean runObject() throws Exception {
                IMethodBinding methodBinding = AstNodeUtils.getMethodBinding(invocation);
                Class<?> factoryClass = this.getFactoryClass(methodBinding);
                String signature = AstNodeUtils.getMethodSignature(methodBinding);
                if (!FactoryDescriptionHelper.getDescriptionsMap(editor, factoryClass, true).containsKey(signature) && !FactoryDescriptionHelper.getDescriptionsMap(editor, factoryClass, false).containsKey(signature)) {
                    return false;
                }
                return true;
            }

            private Class<?> getFactoryClass(IMethodBinding methodBinding) throws Exception {
                ITypeBinding factoryTypeBinding = methodBinding.getDeclaringClass();
                String factoryClassName = AstNodeUtils.getFullyQualifiedName(factoryTypeBinding, true);
                ClassLoader classLoader = EditorState.get(editor).getEditorLoader();
                return classLoader.loadClass(factoryClassName);
            }
        }, (Object)false);
    }

    private static List<FactoryMethodDescription> process(Factory factory, EditorState state, Class<?> declaringClass) throws Exception {
        ArrayList<FactoryMethodDescription> factoryMethodDescriptions = new ArrayList<FactoryMethodDescription>();
        Boolean allMethodsAreFactories = factory.isAllMethodsAreFactories();
        if (allMethodsAreFactories == null) {
            allMethodsAreFactories = true;
        }
        for (Factory.Method method : factory.getMethod()) {
            FactoryMethodDescription factoryMethodDescription = new FactoryMethodDescription(declaringClass);
            factoryMethodDescription.setFactory(allMethodsAreFactories);
            ComponentDescriptionHelper.acceptSafe(factoryMethodDescription, method.getName(), AbstractInvocationDescription::setName);
            ComponentDescriptionHelper.acceptSafe(factoryMethodDescription, method.isExecutable(), MethodDescription::setExecutable);
            ComponentDescriptionHelper.acceptSafe(factoryMethodDescription, method.isFactory(), FactoryMethodDescription::setFactory);
            ComponentDescriptionHelper.acceptSafe(factoryMethodDescription, method.getOrder(), MethodDescription::setOrderSpecification);
            for (MethodParameter parameter : method.getParameter()) {
                ComponentDescriptionHelper.addParametersRules(factoryMethodDescription, parameter, state);
            }
            for (Factory.Method.Invocation invocation : method.getInvocation()) {
                CreationInvocationDescription invocationDescription = new CreationInvocationDescription();
                ComponentDescriptionHelper.acceptSafe(invocationDescription, invocation.getSignature(), CreationInvocationDescription::setSignature);
                ComponentDescriptionHelper.acceptSafe(invocationDescription, invocation.getContent(), CreationInvocationDescription::setArguments);
                factoryMethodDescription.addInvocation(invocationDescription);
            }
            ComponentDescriptionHelper.acceptSafe(factoryMethodDescription, method.getPresentationName(), FactoryMethodDescription::setPresentationName);
            Factory.Method.Parameters parameters = method.getParameters();
            if (parameters != null) {
                for (Factory.Method.Parameters.Parameter parameter : parameters.getParameter()) {
                    factoryMethodDescription.addParameter(parameter.getName(), parameter.getValue());
                }
            }
            ComponentDescriptionHelper.acceptSafe(factoryMethodDescription, method.getDescription(), FactoryMethodDescription::setDescription);
            factoryMethodDescription.postProcess();
            factoryMethodDescriptions.add(factoryMethodDescription);
        }
        return factoryMethodDescriptions;
    }

    public static boolean isFactoryMethod(MethodDeclaration methodDeclaration) {
        return AstNodeUtils.hasJavaDocTag((BodyDeclaration)methodDeclaration, WBP_FACTORY_TAG);
    }

    private static boolean hasFactorySuffix(IType type) throws Exception {
        return type.getElementName().endsWith("Factory");
    }

    private static boolean hasFactoryTag(IType type) throws Exception {
        if (!FactoryDescriptionHelper.hasFactoryTagSource(type)) {
            return false;
        }
        List<String> javaDocLines = JavaDocUtils.getJavaDocLines((IMember)type, false);
        if (javaDocLines != null) {
            for (String javaDocLine : javaDocLines) {
                if (!(javaDocLine = javaDocLine.trim()).equals(WBP_FACTORY_TAG)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasFactoryTagSource(IType type) throws Exception {
        if (type.isBinary()) {
            return false;
        }
        if (!type.getCompilationUnit().isConsistent()) {
            return false;
        }
        return type.getSource().contains(WBP_FACTORY_TAG);
    }

    private static void updateDescriptionsJavaDoc0(AstEditor editor, FactoryMethodDescription description) throws Exception {
        IMethod modelMethod = description.getModelMethod();
        List<String> javaDocLines = JavaDocUtils.getJavaDocLines((IMember)modelMethod, false);
        if (javaDocLines != null) {
            for (String javaDocLine : javaDocLines) {
                if (!(javaDocLine = javaDocLine.trim()).equals(WBP_FACTORY_TAG)) continue;
                description.setFactory(true);
            }
        }
    }

    private static void updateDescriptionsJavaDoc(AstEditor editor, FactoryMethodDescription description) throws Exception {
        IMethod modelMethod = description.getModelMethod();
        String[] parameterNames = modelMethod.getParameterNames();
        List<String> javaDocLines = JavaDocUtils.getJavaDocLines((IMember)modelMethod, false);
        List<ParameterDescription> parameters = description.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            ParameterDescription parameter = parameters.get(i);
            String name = parameterNames[i];
            parameter.setName(name);
            if ("parent".equals(name)) {
                parameter.setParent(true);
            }
            ++i;
        }
        Class<?> componentClass = description.getReturnClass();
        BeanInfo beanInfo = ReflectionUtils.getBeanInfo(componentClass);
        List propertyDescriptors = ReflectionUtils.getPropertyDescriptors((BeanInfo)beanInfo, componentClass);
        boolean doAutoBindings = true;
        if (javaDocLines != null) {
            for (String javaDocLine : javaDocLines) {
                ParameterDescription parameter;
                String parameterString;
                if ((javaDocLine = javaDocLine.trim()).equals(WBP_FACTORY_PARAMETERS_NO_BINDING)) {
                    doAutoBindings = false;
                }
                if (javaDocLine.startsWith(WBP_FACTORY_PARAMETER_SOURCE_TAG)) {
                    parameterString = javaDocLine.substring(WBP_FACTORY_PARAMETER_SOURCE_TAG.length()).trim();
                    parameter = FactoryDescriptionHelper.getJavaDocParameter(description, parameterNames, parameterString);
                    String parameterSource = StringUtilities.removeFirstWord((String)parameterString);
                    parameter.setDefaultSource(parameterSource);
                }
                if (!javaDocLine.startsWith(WBP_FACTORY_PARAMETER_PROPERTY_TAG) || (parameter = FactoryDescriptionHelper.getJavaDocParameter(description, parameterNames, parameterString = javaDocLine.substring(WBP_FACTORY_PARAMETER_PROPERTY_TAG.length()).trim())).getProperty() != null) continue;
                String propertyTitle = StringUtilities.removeFirstWord((String)parameterString);
                String propertyId = FactoryDescriptionHelper.getStandardPropertyId(propertyDescriptors, propertyTitle);
                parameter.setProperty(propertyId);
            }
        }
        if (doAutoBindings) {
            for (ParameterDescription parameter : description.getParameters()) {
                if (parameter.getProperty() != null) continue;
                String property = FactoryDescriptionHelper.getStandardPropertyId(propertyDescriptors, parameter.getName());
                parameter.setProperty(property);
            }
        }
    }

    private static ParameterDescription getJavaDocParameter(FactoryMethodDescription description, String[] parameterNames, String parameterString) {
        String parameterName = StringUtils.split((String)parameterString)[0];
        int parameterIndex = StringUtils.isNumeric((CharSequence)parameterName) ? Integer.parseInt(parameterName) : ArrayUtils.indexOf((Object[])parameterNames, (Object)parameterName);
        if (parameterIndex < 0 || parameterIndex >= parameterNames.length) {
            throw new IllegalArgumentException("Invalid parameter string " + parameterName);
        }
        return description.getParameter(parameterIndex);
    }

    private static String getStandardPropertyId(List<PropertyDescriptor> propertyDescriptors, String title) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            Method setMethod = ReflectionUtils.getWriteMethod((PropertyDescriptor)propertyDescriptor);
            if (setMethod == null || !title.equals(propertyDescriptor.getDisplayName())) continue;
            return StandardBeanPropertiesRule.getId(setMethod);
        }
        return null;
    }
}

