/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.event;

import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.property.event.AbstractEventProperty;
import org.eclipse.wb.internal.core.model.property.event.IListenerMethodProperty;
import org.eclipse.wb.internal.core.model.property.event.IPreferenceConstants;
import org.eclipse.wb.internal.core.model.property.event.ListenerInfo;
import org.eclipse.wb.internal.core.model.property.event.ListenerMethodInfo;
import org.eclipse.wb.internal.core.model.property.event.ListenerMethodPropertyEditor;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.GenericTypeResolver;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.ast.AnonymousTypeDeclaration;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.AstParser;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;

final class ListenerMethodProperty
extends AbstractEventProperty
implements IPreferenceConstants,
IListenerMethodProperty {
    private final IPreferenceStore m_preferences;
    private final ListenerInfo m_listener;
    private final ListenerMethodInfo m_method;
    private final ListenerMethodProperty[] m_siblings;

    public ListenerMethodProperty(JavaInfo javaInfo, ListenerInfo listener, ListenerMethodInfo method, ListenerMethodProperty[] siblings) {
        super(javaInfo, ListenerMethodProperty.getTitle(listener, method), ListenerMethodPropertyEditor.INSTANCE);
        this.m_preferences = javaInfo.getDescription().getToolkit().getPreferences();
        this.m_listener = listener;
        this.m_method = method;
        this.m_siblings = siblings;
    }

    private static String getTitle(ListenerInfo listener, ListenerMethodInfo method) {
        String listenerTitle = listener.getName();
        String methodTitle = method.getName();
        if (methodTitle.startsWith(listenerTitle) && !methodTitle.equals(listenerTitle)) {
            return StringUtils.uncapitalize((String)methodTitle.substring(listenerTitle.length()));
        }
        return methodTitle;
    }

    public boolean isModified() throws Exception {
        ListenerTypeDeclaration listenerType = this.findListenerType();
        if (listenerType == null) {
            return false;
        }
        return listenerType.isModified();
    }

    @Override
    public void setValue(Object value) throws Exception {
        Assert.isTrue((value == UNKNOWN_VALUE ? 1 : 0) != 0, (String)"Unsupported value |%s|.", (Object[])new Object[]{value});
        ExecutionUtils.run((ObjectInfo)this.m_javaInfo, () -> {
            ListenerTypeDeclaration listenerType = this.findListenerType();
            if (listenerType != null) {
                listenerType.removeListenerMethod();
            }
        });
    }

    public ListenerInfo getListener() {
        return this.m_listener;
    }

    public ListenerMethodInfo getMethod() {
        return this.m_method;
    }

    Optional<Integer> getStartPosition() {
        ListenerTypeDeclaration listenerType = this.findListenerType();
        if (listenerType != null) {
            return listenerType.getStartPosition();
        }
        return Optional.empty();
    }

    void removeListener() throws Exception {
        ListenerTypeDeclaration listenerType = this.findListenerType();
        if (listenerType != null) {
            listenerType.removeListener();
        }
    }

    /*
     * WARNING - void declaration
     */
    ListenerTypeDeclaration findListenerType() {
        Expression argument = this.getListenerExpression();
        if (argument != null) {
            Expression expression;
            ClassInstanceCreation methodBinding;
            Expression expression2;
            MethodInvocation methodBinding2;
            if (argument instanceof ThisExpression) {
                return new StandardListenerTypeDeclaration(AstNodeUtils.getEnclosingType((ASTNode)argument));
            }
            Expression expression3 = argument;
            if (expression3 instanceof LambdaExpression) {
                void lambdaExpression;
                LambdaExpression lambdaExpression2 = (LambdaExpression)expression3;
                LambdaExpression cfr_ignored_0 = (LambdaExpression)expression3;
                IMethodBinding methodBinding3 = lambdaExpression.resolveMethodBinding();
                return new LambdaListenerTypeDeclaration((Expression)lambdaExpression, methodBinding3);
            }
            Expression expression4 = argument;
            if (expression4 instanceof ExpressionMethodReference) {
                void methodReference;
                ExpressionMethodReference methodBinding3 = (ExpressionMethodReference)expression4;
                ExpressionMethodReference cfr_ignored_1 = (ExpressionMethodReference)expression4;
                methodBinding2 = this.getListenerMethodBinding((MethodInvocation)methodReference.getParent());
                if (methodBinding2 != null) {
                    return new LambdaListenerTypeDeclaration((Expression)methodReference, (IMethodBinding)methodBinding2);
                }
            }
            if ((expression2 = argument) instanceof MethodInvocation) {
                void methodInvocation;
                methodBinding2 = (MethodInvocation)expression2;
                MethodInvocation cfr_ignored_2 = (MethodInvocation)expression2;
                if (this.isLambdaFactoryMethod((MethodInvocation)methodInvocation) && (methodBinding = this.getListenerMethodBinding((MethodInvocation)methodInvocation.getParent())) != null) {
                    LambdaExpression lambdaExpression = (LambdaExpression)methodInvocation.arguments().get(0);
                    return new LambdaListenerTypeDeclaration((Expression)lambdaExpression, (IMethodBinding)methodBinding);
                }
            }
            if ((expression = argument) instanceof ClassInstanceCreation) {
                void creation;
                methodBinding = (ClassInstanceCreation)expression;
                ClassInstanceCreation cfr_ignored_3 = (ClassInstanceCreation)expression;
                if (creation.getAnonymousClassDeclaration() != null) {
                    return new StandardListenerTypeDeclaration(AnonymousTypeDeclaration.create(creation.getAnonymousClassDeclaration()));
                }
                return new StandardListenerTypeDeclaration(AstNodeUtils.getTypeDeclaration((ClassInstanceCreation)creation));
            }
        }
        return null;
    }

    private IMethodBinding getListenerMethodBinding(MethodInvocation methodInvocation) {
        IMethodBinding listenerMethod = AstNodeUtils.getMethodBinding(methodInvocation);
        ITypeBinding[] parameters = listenerMethod.getParameterTypes();
        if (parameters.length != 1) {
            return null;
        }
        ITypeBinding parameter = parameters[0];
        if (AstNodeUtils.getFullyQualifiedName(parameter, false).equals(this.m_listener.getInterface().getName())) {
            IMethodBinding[] iMethodBindingArray = parameter.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding methodBinding = iMethodBindingArray[n2];
                if (Objects.equals(methodBinding.getName(), this.m_method.getName())) {
                    return methodBinding;
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean isLambdaFactoryMethod(MethodInvocation methodInvocation) {
        String expectedType;
        IMethodBinding method = AstNodeUtils.getMethodBinding(methodInvocation);
        String givenType = AstNodeUtils.getFullyQualifiedName(method.getReturnType(), false);
        if (Objects.equals(givenType, expectedType = this.m_listener.getInterface().getName())) {
            List<Expression> arguments = DomGenerics.arguments(methodInvocation);
            return arguments.size() == 1 && arguments.get(0) instanceof LambdaExpression;
        }
        return false;
    }

    private Expression getListenerExpression() {
        Expression expression = this.getListenerExpression0();
        if (expression != null) {
            ExecutionFlowDescription flow = JavaInfoUtils.getState(this.m_javaInfo).getFlowDescription();
            expression = ExecutionFlowUtils.getFinalExpression(flow, expression);
        }
        return expression;
    }

    private Expression getListenerExpression0() {
        String addListenerMethodSignature = this.m_listener.getMethodSignature();
        MethodInvocation invocation = this.m_javaInfo.getMethodInvocation(addListenerMethodSignature);
        if (invocation != null) {
            return (Expression)invocation.arguments().get(0);
        }
        if (this.m_javaInfo.getCreationSupport() instanceof ConstructorCreationSupport) {
            ConstructorCreationSupport creationSupport = (ConstructorCreationSupport)this.m_javaInfo.getCreationSupport();
            for (ParameterDescription parameter : creationSupport.getDescription().getParameters()) {
                String listenerMethodTag = parameter.getTag("events: add listener method");
                if (!addListenerMethodSignature.equals(listenerMethodTag)) continue;
                return DomGenerics.arguments(creationSupport.getCreation()).get(parameter.getIndex());
            }
        }
        return null;
    }

    private BodyDeclarationTarget getListenerInnerClassTarget() {
        int position = this.m_preferences.getInt("property.events.innerClassPosition");
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration(this.m_javaInfo);
        List<BodyDeclaration> declarations = DomGenerics.bodyDeclarations(typeDeclaration);
        if (position == 0) {
            return new BodyDeclarationTarget(typeDeclaration, true);
        }
        if (position == 1) {
            return new BodyDeclarationTarget(typeDeclaration, false);
        }
        if (position == 2) {
            for (BodyDeclaration declaration : declarations) {
                ITypeBinding binding;
                if (!(declaration instanceof TypeDeclaration) || !AstNodeUtils.isSuccessorOf(binding = AstNodeUtils.getTypeBinding((TypeDeclaration)declaration), "java.util.EventListener")) continue;
                return new BodyDeclarationTarget(declaration, true);
            }
            return new BodyDeclarationTarget(typeDeclaration, true);
        }
        if (position == 3) {
            BodyDeclarationTarget target = new BodyDeclarationTarget(typeDeclaration, false);
            for (BodyDeclaration declaration : declarations) {
                ITypeBinding binding;
                if (!(declaration instanceof TypeDeclaration) || !AstNodeUtils.isSuccessorOf(binding = AstNodeUtils.getTypeBinding((TypeDeclaration)declaration), "java.util.EventListener")) continue;
                target = new BodyDeclarationTarget(declaration, false);
            }
            return target;
        }
        throw new IllegalArgumentException("Unknown position for inner class: " + position);
    }

    private TypeDeclaration addListenerInnerClassDeclaration() throws Exception {
        Class<?> listenerType;
        BodyDeclarationTarget target = this.getListenerInnerClassTarget();
        String headerSource = this.m_listener.hasAdapter() ? " extends " + this.m_listener.getAdapter().getCanonicalName() : ((listenerType = this.m_listener.getInterface()).isInterface() ? " implements " + this.getListenerTypeNameSource() : " extends " + this.getListenerTypeNameSource());
        List<String> lines = List.of("private class " + this.createInnerClassName() + headerSource + " {", "}");
        return this.m_javaInfo.getEditor().addTypeDeclaration(lines, target);
    }

    private String createInnerClassName() {
        TreeMap<String, String> valueMap = new TreeMap<String, String>();
        String componentName = ListenerMethodProperty.getComponentName(this.m_javaInfo);
        valueMap.put("component_name", componentName);
        valueMap.put("Component_name", StringUtils.capitalize((String)componentName));
        String componentType = CodeUtils.getShortClass(this.m_javaInfo.getDescription().getComponentClass().getName());
        valueMap.put("component_className", componentType);
        valueMap.put("Component_className", StringUtils.capitalize((String)componentType));
        String listenerMethodName = CodeUtils.getShortClass(this.m_listener.getInterface().getCanonicalName());
        valueMap.put("listener_className", listenerMethodName);
        valueMap.put("Listener_className", StringUtils.capitalize((String)listenerMethodName));
        String listenerName = this.m_listener.getSimpleName();
        valueMap.put("listener_name", listenerName);
        valueMap.put("Listener_name", StringUtils.capitalize((String)listenerName));
        String template = this.m_preferences.getString("innerClassName");
        String baseName = StringSubstitutor.replace((Object)template, valueMap);
        return this.m_javaInfo.getEditor().getUniqueTypeName(baseName);
    }

    private static String getComponentName(JavaInfo javaInfo) {
        return javaInfo.getVariableSupport().getComponentName();
    }

    /*
     * WARNING - void declaration
     */
    private ASTNode ensureListenerMethod() throws Exception {
        ASTNode listenerMethod = this.findListenerMethod();
        if (listenerMethod == null) {
            TypeDeclaration listenerType = null;
            ListenerTypeDeclaration listenerTypeDeclaration = this.findListenerType();
            if (listenerTypeDeclaration instanceof StandardListenerTypeDeclaration) {
                void type;
                StandardListenerTypeDeclaration standardListenerTypeDeclaration = (StandardListenerTypeDeclaration)listenerTypeDeclaration;
                StandardListenerTypeDeclaration cfr_ignored_0 = (StandardListenerTypeDeclaration)listenerTypeDeclaration;
                listenerType = (TypeDeclaration)type.getActualType();
            }
            if (listenerType == null) {
                boolean implementInterfaceMethods = !this.m_listener.hasAdapter();
                int eventCodeType = this.m_preferences.getInt("property.events.codeType");
                if (eventCodeType == 0) {
                    source = "new " + this.getListenerTypeNameSource() + "() {\n}";
                    this.m_javaInfo.addMethodInvocation(this.m_listener.getMethodSignature(), source);
                    listenerType = (TypeDeclaration)((StandardListenerTypeDeclaration)this.findListenerType()).getActualType();
                } else if (eventCodeType == 1) {
                    listenerType = this.addListenerInnerClassDeclaration();
                    source = "new " + listenerType.getName().getIdentifier() + "()";
                    this.m_javaInfo.addMethodInvocation(this.m_listener.getMethodSignature(), source);
                } else if (eventCodeType == 2) {
                    listenerType = JavaInfoUtils.getTypeDeclaration(this.m_javaInfo);
                    implementInterfaceMethods = this.m_javaInfo.getEditor().ensureInterfaceImplementation(listenerType, this.m_listener.getInterface().getCanonicalName());
                    this.m_javaInfo.addMethodInvocation(this.m_listener.getMethodSignature(), "this");
                }
                if (implementInterfaceMethods) {
                    List<ListenerMethodInfo> interfaceMethods = this.m_listener.getMethods();
                    for (ListenerMethodInfo interfaceMethodInfo : interfaceMethods) {
                        if (!interfaceMethodInfo.isAbstract()) continue;
                        this.addListenerMethod(listenerType, interfaceMethodInfo);
                    }
                }
            }
            if ((listenerMethod = this.findListenerMethod()) == null) {
                listenerMethod = this.addListenerMethod(listenerType, this.m_method);
            }
        }
        return listenerMethod;
    }

    private String getListenerTypeNameSource() {
        Type listenerType = this.m_listener.getListenerType();
        if (listenerType.getTypeParameters().length == 0) {
            return listenerType.getCanonicalName();
        }
        listenerType = this.m_listener.getMethod().getGenericParameterTypes()[0];
        GenericTypeResolver resolver_2 = this.m_listener.getResolver();
        return GenericsUtils.getTypeName((GenericTypeResolver)resolver_2, listenerType);
    }

    private MethodDeclaration addListenerMethod(TypeDeclaration typeDeclaration, ListenerMethodInfo methodInfo) throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        ArrayList<String> annotations = new ArrayList<String>();
        if (this.shouldAppendOverride(typeDeclaration, methodInfo)) {
            annotations.add("@Override");
        }
        String[] parameterNames = null;
        String listenerTypeName = this.m_listener.getListenerType().getCanonicalName();
        IType listenerType = editor.getJavaProject().findType(listenerTypeName);
        IMethod listenerMethod = CodeUtils.findMethod(listenerType, methodInfo.getSignature());
        parameterNames = listenerMethod.getParameterNames();
        Object parametersCode = "";
        String[] parameterTypes = methodInfo.getActualParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            String parameterType = parameterTypes[i];
            if (((String)parametersCode).length() != 0) {
                parametersCode = (String)parametersCode + ", ";
            }
            if (this.m_preferences.getBoolean("property.events.finalParameters")) {
                parametersCode = (String)parametersCode + "final ";
            }
            parametersCode = (String)parametersCode + parameterType;
            parametersCode = (String)parametersCode + " ";
            parametersCode = (String)parametersCode + parameterNames[i];
            ++i;
        }
        String headerCode = "public " + methodInfo.getMethod().getReturnType().getName() + " " + methodInfo.getName() + "(" + (String)parametersCode + ")";
        List<String> bodyLines = ListenerMethodProperty.getListenerMethodBody(methodInfo);
        BodyDeclarationTarget target = new BodyDeclarationTarget(typeDeclaration, false);
        if (target.getType() == null && target.getDeclaration() == null) {
            return null;
        }
        return editor.addMethodDeclaration(annotations, headerCode, bodyLines, target);
    }

    private boolean shouldAppendOverride(TypeDeclaration type, ListenerMethodInfo method) throws Exception {
        IJavaProject javaProject = this.m_javaInfo.getEditor().getJavaProject();
        ListenerInfo listener = method.getListener();
        if (ProjectUtils.isJDK15(javaProject) && listener.hasAdapter()) {
            ITypeBinding typeBinding = AstNodeUtils.getTypeBinding(type);
            ITypeBinding superTypeBinding = typeBinding.getSuperclass();
            return AstNodeUtils.isSuccessorOf(superTypeBinding, listener.getAdapter());
        }
        return false;
    }

    private static List<String> getListenerMethodBody(ListenerMethodInfo methodInfo) {
        Class<?> returnType = methodInfo.getMethod().getReturnType();
        if (returnType == Void.TYPE) {
            return Collections.emptyList();
        }
        String defaultValue = AstParser.getDefaultValue(returnType.getName());
        return List.of("return " + defaultValue + ";");
    }

    private void removeStubMethod(MethodDeclaration listenerMethod) throws Exception {
        MethodDeclaration stubMethod = this.findStubMethod_orNull(listenerMethod);
        if (stubMethod != null) {
            AstEditor editor = this.m_javaInfo.getEditor();
            boolean canDeleteStub = true;
            for (MethodInvocation invocation : AstNodeUtils.getMethodInvocations(stubMethod)) {
                Statement statement = AstNodeUtils.getEnclosingStatement((ASTNode)invocation);
                if (AstNodeUtils.getEnclosingMethod((ASTNode)statement) == listenerMethod) {
                    if (statement.getParent() instanceof IfStatement) {
                        statement = (Statement)statement.getParent();
                    } else if (statement.getParent() instanceof Block && statement.getParent().getParent() instanceof IfStatement) {
                        statement = (Statement)statement.getParent().getParent();
                    }
                    editor.removeStatement(statement);
                    continue;
                }
                canDeleteStub = false;
            }
            if (canDeleteStub) {
                editor.removeBodyDeclaration((BodyDeclaration)stubMethod);
            }
        }
    }

    private ASTNode findListenerMethod() {
        ListenerTypeDeclaration listenerType = this.findListenerType();
        if (listenerType != null) {
            return listenerType.findListenerMethod();
        }
        return null;
    }

    @Override
    public void openStubMethod() throws Exception {
        ListenerTypeDeclaration listenerType = this.findListenerType();
        ASTNode method = null;
        if (listenerType != null) {
            method = listenerType.findStubMethod();
        }
        if (method == null) {
            method = (ASTNode)ExecutionUtils.runObject((ObjectInfo)this.m_javaInfo, this::ensureStubMethod);
        }
        JavaInfoUtils.scheduleOpenNode(this.m_javaInfo, method);
    }

    /*
     * WARNING - void declaration
     */
    private ASTNode ensureStubMethod() throws Exception {
        ASTNode aSTNode;
        ASTNode listenerMethod = this.ensureListenerMethod();
        if (this.m_preferences.getBoolean("property.events.stubCreate") && (aSTNode = listenerMethod) instanceof MethodDeclaration) {
            void methodDeclaration;
            MethodDeclaration methodDeclaration2 = (MethodDeclaration)aSTNode;
            MethodDeclaration cfr_ignored_0 = (MethodDeclaration)aSTNode;
            MethodDeclaration stubMethod = this.findStubMethod_orNull((MethodDeclaration)methodDeclaration);
            if (stubMethod == null) {
                stubMethod = this.addStubMethod(this.m_method, (MethodDeclaration)methodDeclaration);
            }
            return stubMethod;
        }
        return listenerMethod;
    }

    private MethodDeclaration addStubMethod(ListenerMethodInfo methodInfo, MethodDeclaration listenerMethod) throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        if (listenerMethod.getParent().getParent() instanceof TypeDeclaration) {
            return listenerMethod;
        }
        String stubMethodName = this.getStubMethodName(methodInfo);
        String signature = methodInfo.getSignature();
        signature = StringUtils.replace((String)signature, (String)methodInfo.getName(), (String)stubMethodName);
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration(this.m_javaInfo);
        MethodDeclaration stubMethod = AstNodeUtils.getMethodBySignature(typeDeclaration, signature);
        if (stubMethod == null) {
            ExecutionFlowDescription flowDescription = EditorState.get(editor).getFlowDescription();
            boolean isStaticContext = flowDescription.isStatic();
            String modifiers = isStaticContext ? "protected static " : "protected ";
            String header = modifiers + "void " + stubMethodName + "(" + editor.getParametersSource(listenerMethod) + ")";
            stubMethod = editor.addMethodDeclaration(header, Collections.emptyList(), new BodyDeclarationTarget(typeDeclaration, false));
        }
        String lineInvoke = stubMethodName + "(" + StringUtils.join((Object[])editor.getParameterNames(listenerMethod), (String)", ") + ");";
        List<Object> lines = this.m_preferences.getInt("property.events.codeType") == 2 ? this.getConditionalStubInvocationSource(listenerMethod, editor, lineInvoke) : List.of(lineInvoke);
        if (lines != null) {
            StatementTarget target = new StatementTarget(listenerMethod, true);
            TemplateUtils.addStatement(this.m_javaInfo, target, lines);
        }
        return stubMethod;
    }

    private List<String> getConditionalStubInvocationSource(MethodDeclaration listenerMethod, AstEditor editor, String lineInvoke) throws Exception {
        List<SingleVariableDeclaration> parameters = DomGenerics.parameters(listenerMethod);
        for (SingleVariableDeclaration parameter : parameters) {
            String componentAccess;
            ComponentDescription eventClassDescription = (ComponentDescription)ExecutionUtils.runObjectIgnore(() -> {
                ClassLoader editorLoader = EditorState.get(editor).getEditorLoader();
                String parameterTypeName = AstNodeUtils.getFullyQualifiedName(parameter.getType(), true);
                Class parameterType = ReflectionUtils.getClassByName((ClassLoader)editorLoader, (String)parameterTypeName);
                return ComponentDescriptionHelper.getDescription(editor, parameterType);
            }, null);
            if (eventClassDescription == null || (componentAccess = eventClassDescription.getParameter("eventsProperty.componentAccess")) == null) continue;
            String lineIf = TemplateUtils.format("if ({0}{1} == {2}) '{'", new Object[]{parameter.getName().getIdentifier(), componentAccess, this.m_javaInfo});
            return List.of(lineIf, "\t" + lineInvoke, "}");
        }
        return null;
    }

    private String getStubMethodName(ListenerMethodInfo methodInfo) {
        TreeMap<String, String> valueMap = new TreeMap<String, String>();
        String componentName = ListenerMethodProperty.getComponentName(this.m_javaInfo);
        valueMap.put("component_name", componentName);
        valueMap.put("Component_name", StringUtils.capitalize((String)componentName));
        String componentType = CodeUtils.getShortClass(this.m_javaInfo.getDescription().getComponentClass().getName());
        valueMap.put("component_class_name", componentType);
        valueMap.put("Component_class_name", StringUtils.capitalize((String)componentType));
        String methodName = methodInfo.getName();
        valueMap.put("event_name", methodName);
        valueMap.put("Event_name", StringUtils.capitalize((String)methodName));
        String template = this.m_preferences.getString("stubName");
        return StringSubstitutor.replace((Object)template, valueMap);
    }

    /*
     * WARNING - void declaration
     */
    private MethodDeclaration findStubMethod_orNull(MethodDeclaration listenerMethod) {
        if (listenerMethod == null) {
            return null;
        }
        MethodDeclaration stubMethod = this.findStubMethod((Statement)listenerMethod.getBody());
        if (stubMethod != null) {
            return stubMethod;
        }
        List<Statement> statements = DomGenerics.statements(listenerMethod.getBody());
        for (Statement statement : statements) {
            InfixExpression condition;
            void ifStatement;
            Statement statement2 = statement;
            if (!(statement2 instanceof IfStatement)) continue;
            IfStatement cfr_ignored_0 = (IfStatement)statement2;
            IfStatement cfr_ignored_1 = (IfStatement)statement2;
            if (!(ifStatement.getExpression() instanceof InfixExpression) || (condition = (InfixExpression)ifStatement.getExpression()).getOperator() != InfixExpression.Operator.EQUALS || !this.m_javaInfo.isRepresentedBy((ASTNode)condition.getRightOperand())) continue;
            Statement thenStatement = ifStatement.getThenStatement();
            MethodDeclaration stubMethod2 = this.findStubMethod(thenStatement);
            if (stubMethod2 == null) break;
            return stubMethod2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private MethodDeclaration findStubMethod(Statement listenerStatement) {
        Statement statement;
        Statement statement2;
        List<Statement> statements = listenerStatement instanceof Block ? DomGenerics.statements((Block)listenerStatement) : List.of(listenerStatement);
        if (statements.size() == 1 && (statement2 = (statement = statements.get(0))) instanceof ExpressionStatement) {
            void expressionStatement;
            ExpressionStatement expressionStatement2 = (ExpressionStatement)statement2;
            ExpressionStatement cfr_ignored_0 = (ExpressionStatement)statement2;
            if (expressionStatement.getExpression() instanceof MethodInvocation) {
                MethodInvocation invocation = (MethodInvocation)expressionStatement.getExpression();
                TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration(this.m_javaInfo);
                String methodSignature = AstNodeUtils.getMethodSignature(invocation);
                return AstNodeUtils.getMethodBySignature(typeDeclaration, methodSignature);
            }
        }
        return null;
    }

    private static abstract class AbstractListenerTypeDeclaration<T extends ASTNode>
    implements ListenerTypeDeclaration {
        private final T m_node;

        public AbstractListenerTypeDeclaration(T node) {
            this.m_node = node;
        }

        public T getActualType() {
            return this.m_node;
        }

        @Override
        public Optional<Integer> getStartPosition() {
            ASTNode stubMethod = this.findStubMethod();
            return Optional.ofNullable(stubMethod).map(ASTNode::getStartPosition);
        }
    }

    private final class LambdaListenerTypeDeclaration
    extends AbstractListenerTypeDeclaration<Expression> {
        public LambdaListenerTypeDeclaration(Expression expression, IMethodBinding methodBinding) {
            super(expression);
        }

        @Override
        public boolean isModified() {
            return true;
        }

        @Override
        public void removeListener() throws Exception {
            ListenerMethodProperty.this.m_javaInfo.removeMethodInvocations(ListenerMethodProperty.this.m_listener.getMethodSignature());
            ExecutionUtils.refresh((ObjectInfo)ListenerMethodProperty.this.m_javaInfo);
        }

        @Override
        public void removeListenerMethod() throws Exception {
            this.removeListener();
        }

        public final Expression findListenerMethod() {
            return (Expression)this.getActualType();
        }

        public final Expression findStubMethod() {
            return this.findListenerMethod();
        }
    }

    static interface ListenerTypeDeclaration {
        public void removeListener() throws Exception;

        public void removeListenerMethod() throws Exception;

        public ASTNode findStubMethod();

        public ASTNode findListenerMethod();

        public Optional<Integer> getStartPosition();

        public boolean isModified();
    }

    private final class StandardListenerTypeDeclaration
    extends AbstractListenerTypeDeclaration<TypeDeclaration> {
        public StandardListenerTypeDeclaration(TypeDeclaration typeDeclaration) {
            super(typeDeclaration);
        }

        @Override
        public boolean isModified() {
            MethodDeclaration listenerMethod = this.findListenerMethod();
            if (listenerMethod != null) {
                if (StandardListenerTypeDeclaration.hasStubRouting(listenerMethod)) {
                    return ListenerMethodProperty.this.findStubMethod_orNull(listenerMethod) != null;
                }
                return true;
            }
            return false;
        }

        private static boolean hasStubRouting(MethodDeclaration listenerMethod) {
            InfixExpression condition;
            IfStatement ifStatement;
            List<Statement> statements = DomGenerics.statements(listenerMethod.getBody());
            return !statements.isEmpty() && statements.get(0) instanceof IfStatement && (ifStatement = (IfStatement)statements.get(0)).getExpression() instanceof InfixExpression && (condition = (InfixExpression)ifStatement.getExpression()).getOperator() == InfixExpression.Operator.EQUALS;
        }

        @Override
        public void removeListener() throws Exception {
            TypeDeclaration listenerType = (TypeDeclaration)this.getActualType();
            if (listenerType != null && listenerType.getParent() instanceof TypeDeclaration) {
                this.removeListener_inner(listenerType);
            } else {
                if (ListenerMethodProperty.this.m_preferences.getBoolean("property.events.stubDelete")) {
                    this.removeListenerStubs();
                }
                ListenerMethodProperty.this.m_javaInfo.removeMethodInvocations(ListenerMethodProperty.this.m_listener.getMethodSignature());
            }
            ExecutionUtils.refresh((ObjectInfo)ListenerMethodProperty.this.m_javaInfo);
        }

        private void removeListener_inner(TypeDeclaration listenerType) throws Exception {
            List<ClassInstanceCreation> listenerCreations = AstNodeUtils.getClassInstanceCreations(listenerType);
            boolean removeAllListenerArtifacts = true;
            if (listenerCreations.size() > 1) {
                if (ListenerMethodProperty.this.m_javaInfo.isDeleting()) {
                    removeAllListenerArtifacts = false;
                } else {
                    String message = MessageFormat.format(ModelMessages.ListenerMethodProperty_deleteAllListenerUsagesMessage, ListenerMethodProperty.this.m_listener.getName());
                    if (!MessageDialog.openQuestion((Shell)DesignerPlugin.getShell(), (String)ModelMessages.ListenerMethodProperty_deleteAllListenerUsagesTitle, (String)message)) {
                        removeAllListenerArtifacts = false;
                    }
                }
            }
            if (ListenerMethodProperty.this.m_preferences.getBoolean("property.events.stubDelete") && removeAllListenerArtifacts) {
                this.removeListenerStubs();
            }
            ListenerMethodProperty.this.m_javaInfo.removeMethodInvocations(ListenerMethodProperty.this.m_listener.getMethodSignature());
            if (removeAllListenerArtifacts) {
                for (ClassInstanceCreation classInstanceCreation : listenerCreations) {
                    ListenerMethodProperty.this.m_javaInfo.getEditor().removeEnclosingStatement((ASTNode)classInstanceCreation);
                }
                ListenerMethodProperty.this.m_javaInfo.getEditor().removeBodyDeclaration((BodyDeclaration)listenerType);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void removeListenerStubs() throws Exception {
            ListenerMethodProperty[] listenerMethodPropertyArray = ListenerMethodProperty.this.m_siblings;
            int n = ListenerMethodProperty.this.m_siblings.length;
            int n2 = 0;
            while (n2 < n) {
                ListenerMethodProperty property = listenerMethodPropertyArray[n2];
                ASTNode aSTNode = property.findListenerMethod();
                if (aSTNode instanceof MethodDeclaration) {
                    void listenerMethod;
                    MethodDeclaration cfr_ignored_0 = (MethodDeclaration)aSTNode;
                    MethodDeclaration cfr_ignored_1 = (MethodDeclaration)aSTNode;
                    property.removeStubMethod((MethodDeclaration)listenerMethod);
                }
                ++n2;
            }
        }

        @Override
        public void removeListenerMethod() throws Exception {
            TypeDeclaration listenerType = (TypeDeclaration)this.getActualType();
            if (listenerType == null) {
                return;
            }
            MethodDeclaration listenerMethod = this.findListenerMethod();
            if (listenerMethod == null) {
                return;
            }
            if (listenerType == JavaInfoUtils.getTypeDeclaration(ListenerMethodProperty.this.m_javaInfo)) {
                ListenerMethodProperty.this.removeStubMethod(listenerMethod);
                return;
            }
            if (ListenerMethodProperty.this.m_listener.hasAdapter() && AstNodeUtils.isSuccessorOf(AstNodeUtils.getTypeBinding(listenerType), ListenerMethodProperty.this.m_listener.getAdapter())) {
                if (!MessageDialog.openConfirm((Shell)DesignerPlugin.getShell(), (String)ModelMessages.ListenerMethodProperty_deleteMethodTitle, (String)MessageFormat.format(ModelMessages.ListenerMethodProperty_deleteMethodMessage, ListenerMethodProperty.this.m_method.getName()))) {
                    return;
                }
                this.removeListenerMethod(listenerType, listenerMethod);
            } else {
                if (!MessageDialog.openConfirm((Shell)DesignerPlugin.getShell(), (String)ModelMessages.ListenerMethodProperty_deleteListenerTitle, (String)MessageFormat.format(ModelMessages.ListenerMethodProperty_deleteListenerMessage, ListenerMethodProperty.this.m_listener.getName()))) {
                    return;
                }
                this.removeListener();
            }
        }

        private void removeListenerMethod(TypeDeclaration typeDeclaration, MethodDeclaration listenerMethod) throws Exception {
            AstEditor editor = ListenerMethodProperty.this.m_javaInfo.getEditor();
            ListenerMethodProperty.this.removeStubMethod(listenerMethod);
            editor.removeBodyDeclaration((BodyDeclaration)listenerMethod);
            if (typeDeclaration.bodyDeclarations().isEmpty()) {
                this.removeListener();
            }
        }

        public MethodDeclaration findListenerMethod() {
            return AstNodeUtils.getMethodBySignature((TypeDeclaration)this.getActualType(), ListenerMethodProperty.this.m_method.getSignatureAST());
        }

        public MethodDeclaration findStubMethod() {
            MethodDeclaration listenerMethod = this.findListenerMethod();
            return this.findStubMethod(listenerMethod);
        }

        private MethodDeclaration findStubMethod(MethodDeclaration listenerMethod) {
            MethodDeclaration stubMethod = ListenerMethodProperty.this.findStubMethod_orNull(listenerMethod);
            if (stubMethod != null) {
                return stubMethod;
            }
            return listenerMethod;
        }
    }
}

