/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugUtil;
import org.eclipse.m2m.qvt.oml.debug.core.Trace;
import org.osgi.framework.BundleContext;

public class QVTODebugCore
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.m2m.qvt.oml.debug.core";
    public static final String BREAKPOINT_MARKER_ID = "org.eclipse.m2m.qvt.oml.debug.core.QVTOBreakpointMarker";
    public static final String MODEL_ID = "org.eclipse.m2m.qvt.oml.debug";
    public static final String DEBUGGER_ACTIVE_PROPERTY = "org.eclipse.m2m.qvt.oml.debug.debuggerActive";
    public static Trace TRACE = new Trace();
    private static QVTODebugCore plugin;
    private Map<URI, URI> platformPluginMap;
    private IResourceChangeListener resourceListener;
    private Object pluginMapLock = new Object();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        TRACE.start(plugin);
        this.resourceListener = this.createResourceListen();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        TRACE.stop();
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        }
    }

    public static QVTODebugCore getDefault() {
        return plugin;
    }

    public static IStatus createStatus(int severity, String message, Throwable throwable) {
        return new Status(severity, PLUGIN_ID, message, throwable);
    }

    public static IStatus createStatus(int severity, String message) {
        return QVTODebugCore.createStatus(severity, message, null);
    }

    public static IStatus createError(String message, int code, Throwable throwable) {
        return new Status(4, PLUGIN_ID, code, message, throwable);
    }

    public static void log(IStatus status) {
        QVTODebugCore debugPlugin = QVTODebugCore.getDefault();
        if (debugPlugin != null) {
            debugPlugin.getLog().log(status);
        }
    }

    public static void log(Throwable e) {
        QVTODebugCore.log((IStatus)new Status(4, PLUGIN_ID, "Exception caught", e));
    }

    public static <T extends IBreakpoint> List<T> getQVTOBreakpoints(Class<T> breakpointType) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(MODEL_ID);
        ArrayList<IBreakpoint> result = new ArrayList<IBreakpoint>(breakpoints.length);
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            if (breakpointType.isInstance(bp)) {
                result.add((IBreakpoint)breakpointType.cast(bp));
            }
            ++n2;
        }
        return result;
    }

    public URI resolvePlatformPluginURI(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        return this.resolvePlatformPluginURI(uri);
    }

    public URI resolvePlatformPluginURI(URI uri) {
        Map<URI, URI> uriMap = this.getPlatformPluginMap();
        if (uri.isPlatformResource() && uri.segmentCount() > 2) {
            URI baseURI = uri.trimSegments(uri.segmentCount() - 2);
            URI key = baseURI.appendSegment("");
            URI mappedBaseURI = uriMap.get(key);
            if (mappedBaseURI == null) {
                mappedBaseURI = uriMap.get(baseURI);
            }
            if (mappedBaseURI != null) {
                List segmentsList = uri.segmentsList();
                segmentsList = segmentsList.subList(2, segmentsList.size());
                if (mappedBaseURI.hasTrailingPathSeparator()) {
                    mappedBaseURI = mappedBaseURI.trimSegments(1);
                }
                return mappedBaseURI.appendSegments(segmentsList.toArray(new String[segmentsList.size()]));
            }
        }
        return null;
    }

    public IFile resolveWorskpaceFile(URI uri) {
        IFile sourceFile = QVTODebugUtil.toFile(uri);
        if (sourceFile == null && uri.isPlatformPlugin() && uri.segmentCount() > 2) {
            URI baseURI;
            URI key;
            Map<URI, URI> uriMap = this.getPlatformPluginMap();
            URI mappedBaseURI = uriMap.get(key = (baseURI = uri.trimSegments(uri.segmentCount() - 2)).appendSegment(""));
            if (mappedBaseURI == null) {
                mappedBaseURI = uriMap.get(baseURI);
            }
            if (mappedBaseURI != null) {
                List segmentsList = uri.segmentsList();
                segmentsList = segmentsList.subList(2, segmentsList.size());
                URI mappedURI = mappedBaseURI.appendSegments(segmentsList.toArray(new String[segmentsList.size()]));
                sourceFile = QVTODebugUtil.toFile(mappedURI);
            }
        }
        return sourceFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URI, URI> getPlatformPluginMap() {
        Object object = this.pluginMapLock;
        synchronized (object) {
            if (this.platformPluginMap == null) {
                this.platformPluginMap = new HashMap<URI, URI>();
                Map plugin2ResourceMap = EcorePlugin.computePlatformPluginToPlatformResourceMap();
                this.platformPluginMap.putAll(plugin2ResourceMap);
                for (Map.Entry entry : plugin2ResourceMap.entrySet()) {
                    this.platformPluginMap.put((URI)entry.getValue(), (URI)entry.getKey());
                }
            }
        }
        return this.platformPluginMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPlatformPluginMap() {
        Object object = this.pluginMapLock;
        synchronized (object) {
            this.platformPluginMap = null;
        }
    }

    private boolean process(IResourceDelta delta) {
        IResourceDelta[] affectedChildren;
        IResource resource = delta.getResource();
        if (this.isManifest(resource)) {
            return true;
        }
        IResourceDelta[] iResourceDeltaArray = affectedChildren = delta.getAffectedChildren();
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            if (this.process(childDelta)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isManifest(IResource resource) {
        return resource.getType() == 1 && resource.getName().equals("MANIFEST.MF") && resource.getProjectRelativePath().equals((Object)new Path("META-INF/MANIFEST.MF"));
    }

    private IResourceChangeListener createResourceListen() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getResource() instanceof IProject) {
                    QVTODebugCore.this.resetPlatformPluginMap();
                }
                if (event.getDelta() != null && QVTODebugCore.this.process(event.getDelta())) {
                    QVTODebugCore.this.resetPlatformPluginMap();
                }
            }
        };
    }
}

