/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class OpenActionUtil {
    private static final String DIALOG_SETTINGS_SECTION_NAME = "org.eclipse.cdt.ui.OPEN_ACTION_SELECTION_DIALOG_SECTION";

    private OpenActionUtil() {
    }

    public static void open(Object element) throws CModelException, PartInitException {
        OpenActionUtil.open(element, true);
    }

    public static void open(Object element, boolean activate) throws CModelException, PartInitException {
        IEditorPart part = EditorUtility.openInEditor(element, activate);
        if (element instanceof ICElement) {
            EditorUtility.revealInEditor(part, (ICElement)element);
        }
    }

    public static List<ISourceReference> filterResolveResults(ICElement[] codeResolveResults) {
        int nResults = codeResolveResults.length;
        ArrayList<ISourceReference> refs = new ArrayList<ISourceReference>(nResults);
        int i = 0;
        while (i < nResults) {
            if (codeResolveResults[i] instanceof ISourceReference) {
                refs.add((ISourceReference)codeResolveResults[i]);
            }
            ++i;
        }
        return refs;
    }

    public static ICElement selectCElement(ICElement[] elements, Shell shell, String title, String message) {
        return OpenActionUtil.selectCElement(elements, shell, title, message, 0L, 0);
    }

    public static ICElement selectCElement(ICElement[] elements, Shell shell, String title, String message, long textFlags, int imageFlags) {
        Object[] selection;
        int nResults = elements.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return elements[0];
        }
        LabelProvider labelProvider = textFlags == 0L && imageFlags == 0 ? new CElementLabelProvider(CElementLabelProvider.SHOW_DEFAULT | 0x400) : new CUILabelProvider(textFlags, imageFlags);
        org.eclipse.ui.dialogs.ElementListSelectionDialog dialog = new org.eclipse.ui.dialogs.ElementListSelectionDialog(shell, (ILabelProvider)labelProvider){

            protected IDialogSettings getDialogBoundsSettings() {
                IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings();
                IDialogSettings section = settings.getSection(OpenActionUtil.DIALOG_SETTINGS_SECTION_NAME);
                if (section == null) {
                    section = settings.addNewSection(OpenActionUtil.DIALOG_SETTINGS_SECTION_NAME);
                }
                return section;
            }
        };
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements((Object[])elements);
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            nResults = selection.length;
            int i = 0;
            while (i < nResults) {
                Object current = selection[i];
                if (current instanceof ICElement) {
                    return (ICElement)current;
                }
                ++i;
            }
        }
        return null;
    }

    public static IPath selectPath(List<IPath> paths, String title, String message) {
        LabelProvider renderer = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IPath) {
                    IPath file = (IPath)element;
                    return String.valueOf(file.lastSegment()) + " - " + file.toString();
                }
                return super.getText(element);
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(CUIPlugin.getActiveWorkbenchShell(), (ILabelProvider)renderer, false, false);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements(paths);
        if (dialog.open() == 0) {
            return (IPath)dialog.getSelectedElement();
        }
        return null;
    }
}

