/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions;

import org.eclipse.acceleo.compatibility.model.mt.core.Template;
import org.eclipse.acceleo.compatibility.model.mt.expressions.ExpressionsFactory;
import org.eclipse.acceleo.compatibility.model.mt.expressions.Operator;
import org.eclipse.acceleo.internal.compatibility.AcceleoCompatibilityMessages;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions.ExpressionParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateConstants;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TextSearch;

public final class OperatorParser {
    private OperatorParser() {
    }

    public static Operator createOperator(int offset, String buffer, Region range, Template template) throws TemplateSyntaxException {
        Region localRange = range;
        Region trim = TextSearch.trim(buffer, localRange.b(), localRange.e());
        if (trim.b() == -1) {
            throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.MissingElement"), template, localRange);
        }
        localRange = trim;
        int i = 0;
        while (i < TemplateConstants.getDefault().getOperators().length) {
            Region[] positions = TextSearch.splitPositionsIn(buffer, localRange, new String[]{TemplateConstants.getDefault().getOperators()[i]}, false, TemplateConstants.getDefault().getSpec(), TemplateConstants.getDefault().getInhibsExpression());
            if (OperatorParser.validateOperands(buffer, TemplateConstants.getDefault().getOperators()[i], positions)) {
                Operator operator = ExpressionsFactory.eINSTANCE.createOperator();
                operator.setOperator(TemplateConstants.getDefault().getOperators()[i]);
                operator.setBegin(offset + localRange.b());
                operator.setEnd(offset + localRange.e());
                int j = 0;
                while (j < positions.length) {
                    Region pos = positions[j];
                    operator.getOperands().add((Object)ExpressionParser.createExpression(offset, buffer, pos, template));
                    ++j;
                }
                return operator;
            }
            ++i;
        }
        return null;
    }

    private static boolean validateOperands(String buffer, String operator, Region[] operandPos) {
        boolean res = operandPos.length > 1;
        int i = 0;
        while (i < operandPos.length && res) {
            if (TemplateConstants.getDefault().getOperatorInf().equals(operator) || TemplateConstants.getDefault().getOperatorSup().equals(operator)) {
                res = res && !buffer.substring(operandPos[i].b(), operandPos[i].e()).startsWith("=");
            }
            ++i;
        }
        return res;
    }
}

