"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDtsSnapshot = void 0;
var getCssExports_1 = require("./getCssExports");
var createDtsExports_1 = require("./createDtsExports");
var getDtsSnapshot = function (ts, processor, fileName, scriptSnapshot, options, logger, compilerOptions, directory) {
    var css = scriptSnapshot.getText(0, scriptSnapshot.getLength());
    /*
     * TODO: Temporary workaround for:
     * https://github.com/mrmckeb/typescript-plugin-css-modules/issues/41
     * Needs investigation for a more elegant solution.
     */
    if (css.includes('export default classes')) {
        return scriptSnapshot;
    }
    var cssExports = (0, getCssExports_1.getCssExports)({
        css: css,
        fileName: fileName,
        logger: logger,
        options: options,
        processor: processor,
        compilerOptions: compilerOptions,
        directory: directory,
    });
    var dts = (0, createDtsExports_1.createDtsExports)({ cssExports: cssExports, fileName: fileName, logger: logger, options: options });
    return ts.ScriptSnapshot.fromString(dts);
};
exports.getDtsSnapshot = getDtsSnapshot;
