/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.jdt.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.swt.api.Table;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.condition.TableHasRows;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.hamcrest.Matcher;

public interface CanImplement {
    default public void addExtendedInterface(String interfaceName) {
        new PushButton("Add...").click();
        new DefaultShell(new Matcher[]{new WithTextMatcher((Matcher)new RegexMatcher("[Extended|Implemented].*Interfaces Selection"))});
        new DefaultText(0, new Matcher[0]).setText(interfaceName);
        new WaitUntil((WaitCondition)new JobIsRunning(), TimePeriod.MEDIUM, false);
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.MEDIUM, false);
        new WaitUntil((WaitCondition)new TableHasRows((Table)new DefaultTable(0, new Matcher[0])), TimePeriod.DEFAULT, false);
        switch (new DefaultTable(0, new Matcher[0]).getItems().size()) {
            case 0: {
                throw new RedDeerException("No item was found for given interface name '" + interfaceName + "'.");
            }
            case 1: {
                new PushButton("OK").click();
                break;
            }
            default: {
                throw new RedDeerException("More than 1 item was found for given interface name '" + interfaceName + "'.");
            }
        }
    }

    default public void removeExtendedInterface(String interfaceName) {
        DefaultTable table = new DefaultTable(0, new Matcher[0]);
        table.getItem(interfaceName).select();
        new PushButton("Remove").click();
    }

    default public ArrayList<String> getExtendedInterfaces() {
        DefaultTable table = new DefaultTable(0, new Matcher[0]);
        List tableItems = table.getItems();
        ArrayList<String> tableItemNames = new ArrayList<String>();
        for (TableItem item : tableItems) {
            tableItemNames.add(item.getText());
        }
        return tableItemNames;
    }
}

