/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.ui.providers.support;

import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.ptp.internal.rm.lml.core.model.Node;
import org.eclipse.ptp.internal.rm.lml.ui.messages.Messages;
import org.eclipse.ptp.rm.lml.core.elements.ObjectType;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.core.model.LMLNodeData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class MouseInteraction {
    private final ILguiItem lguiItem;
    private final DefaultToolTip toolTip;
    private final String emptyJobName = "empty";

    public MouseInteraction(ILguiItem lguiItem, Control interactControl) {
        this.lguiItem = lguiItem;
        this.toolTip = new DefaultToolTip(interactControl);
        this.toolTip.setText(null);
        this.toolTip.setShift(new Point(20, 20));
        this.toolTip.setHideOnMouseDown(false);
        this.toolTip.deactivate();
    }

    public void mouseDownAction(Node<LMLNodeData> focussed) {
        if (focussed != null && !this.isNodeEmpty(focussed) && this.lguiItem.getObjectStatus() != null) {
            this.lguiItem.getObjectStatus().mouseDown(this.lguiItem.getOIDToObject().getObjectByLMLNode((LMLNodeData)focussed.getData()));
        }
        this.setToolTipText(this.getToolTipText(focussed));
    }

    public void mouseDownAction(ObjectType focussed) {
        if (focussed != null && !this.isEmptyJob(focussed) && this.lguiItem.getObjectStatus() != null) {
            this.lguiItem.getObjectStatus().mouseDown(focussed);
        }
        this.setToolTipText(this.getToolTipText(focussed));
    }

    public void mouseExitAction() {
        if (this.lguiItem.getObjectStatus() != null) {
            this.lguiItem.getObjectStatus().mouseExitLast();
        }
        this.setToolTipText(this.getToolTipText((Node<LMLNodeData>)null));
    }

    public void mouseMoveAction(Node<LMLNodeData> focussed) {
        if (this.lguiItem.getObjectStatus() != null) {
            if (focussed != null && !this.isNodeEmpty(focussed)) {
                this.lguiItem.getObjectStatus().mouseOver(this.lguiItem.getOIDToObject().getObjectByLMLNode((LMLNodeData)focussed.getData()));
            } else {
                this.lguiItem.getObjectStatus().mouseExitLast();
            }
        }
        this.setToolTipText(this.getToolTipText(focussed));
    }

    public void mouseMoveAction(ObjectType focussed) {
        if (this.lguiItem.getObjectStatus() != null) {
            if (focussed != null && !this.isEmptyJob(focussed)) {
                this.lguiItem.getObjectStatus().mouseOver(focussed);
            } else {
                this.lguiItem.getObjectStatus().mouseExitLast();
            }
        }
        this.setToolTipText(this.getToolTipText(focussed));
    }

    public void mouseUpAction(Node<LMLNodeData> focussed) {
        if (focussed != null && !this.isNodeEmpty(focussed) && this.lguiItem.getObjectStatus() != null) {
            this.lguiItem.getObjectStatus().mouseUp(this.lguiItem.getOIDToObject().getObjectByLMLNode((LMLNodeData)focussed.getData()));
        }
        this.setToolTipText(this.getToolTipText(focussed));
    }

    public void mouseUpAction(ObjectType focussed) {
        if (focussed != null && !this.isEmptyJob(focussed) && this.lguiItem.getObjectStatus() != null) {
            this.lguiItem.getObjectStatus().mouseUp(focussed);
        }
        this.setToolTipText(this.getToolTipText(focussed));
    }

    private String getToolTipText(Node<LMLNodeData> focussed) {
        String info = "";
        if (focussed == null) {
            return null;
        }
        ObjectType object = this.lguiItem.getOIDToObject().getObjectByLMLNode((LMLNodeData)focussed.getData());
        info = String.valueOf(info) + this.getToolTipText(object);
        return info;
    }

    private String getToolTipText(ObjectType object) {
        String info = "";
        if (object == null) {
            return null;
        }
        info = this.isEmptyJob(object) ? Messages.MouseInteraction_0 : (object.getName() != null ? "Job: " + object.getName() : "Job: " + object.getId());
        return info;
    }

    private boolean isEmptyJob(ObjectType object) {
        if (object == null) {
            return true;
        }
        if (object.getId() == null) {
            return true;
        }
        return object.getId().equals("empty");
    }

    private boolean isNodeEmpty(Node<LMLNodeData> node) {
        if (node == null) {
            return true;
        }
        return this.isEmptyJob(this.lguiItem.getOIDToObject().getObjectByLMLNode((LMLNodeData)node.getData()));
    }

    private void setToolTipText(String text) {
        if (text == null) {
            this.toolTip.deactivate();
        } else {
            this.toolTip.activate();
        }
        this.toolTip.setText(text);
    }
}

