/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.widgets;

import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.widgets.MultipleValueWidget;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MultipleValueSelectionWidget
extends MultipleValueWidget {
    protected Composite selectorSection;
    protected Composite buttonsSection;
    protected Button add;
    protected Button remove;
    protected Button addAll;
    protected Button removeAll;

    public MultipleValueSelectionWidget(IElementSelector selector) {
        this(selector, false, false);
    }

    public MultipleValueSelectionWidget(IElementSelector selector, boolean unique) {
        this(selector, unique, false);
    }

    public MultipleValueSelectionWidget(IElementSelector selector, boolean unique, boolean ordered) {
        this(selector, unique, false, -1);
    }

    public MultipleValueSelectionWidget(IElementSelector selector, boolean unique, boolean ordered, int upperBound) {
        super(selector, unique, ordered, upperBound);
    }

    @Override
    protected void init() {
    }

    @Override
    protected void createSections(Composite parent) {
        Layout parentLayout = parent.getLayout();
        if (parentLayout instanceof GridLayout) {
            GridLayout layout = (GridLayout)parentLayout;
            layout.numColumns = 2;
            layout.makeColumnsEqualWidth = true;
            Composite selectorPane = new Composite(parent, 0);
            selectorPane.setLayout((Layout)new GridLayout(2, false));
            selectorPane.setLayoutData((Object)new GridData(4, 4, true, true));
            this.createSelectorSection(selectorPane);
            this.createControlsSection(selectorPane);
        }
        super.createSections(parent);
    }

    private void createSelectorSection(Composite parent) {
        this.selectorSection = new Composite(parent, 0);
        this.selectorSection.setLayout((Layout)new FillLayout());
        this.selectorSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.selector.createControls(this.selectorSection);
    }

    private void createControlsSection(Composite parent) {
        this.buttonsSection = new Composite(parent, 0);
        this.buttonsSection.setLayout((Layout)new GridLayout(1, true));
        this.add = new Button(this.buttonsSection, 8);
        this.add.setImage(Activator.getDefault().getImage("/icons/arrow_right.gif"));
        this.add.addSelectionListener((SelectionListener)this);
        this.add.setToolTipText(Messages.MultipleValueSelectorDialog_AddSelectedElements);
        this.remove = new Button(this.buttonsSection, 8);
        this.remove.setImage(Activator.getDefault().getImage("/icons/arrow_left.gif"));
        this.remove.addSelectionListener((SelectionListener)this);
        this.remove.setToolTipText(Messages.MultipleValueEditor_RemoveSelectedElements);
        this.addAll = new Button(this.buttonsSection, 8);
        this.addAll.setImage(Activator.getDefault().getImage("/icons/arrow_double.gif"));
        this.addAll.addSelectionListener((SelectionListener)this);
        this.addAll.setToolTipText(Messages.MultipleValueSelectorDialog_AddAllElements);
        if (this.upperBound != -1 && this.allElements.size() > this.upperBound) {
            this.addAll.setEnabled(false);
        }
        this.removeAll = new Button(this.buttonsSection, 8);
        this.removeAll.setImage(Activator.getDefault().getImage("/icons/arrow_left_double.gif"));
        this.removeAll.addSelectionListener((SelectionListener)this);
        this.removeAll.setToolTipText(Messages.MultipleValueSelectorDialog_RemoveAllElements);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.add) {
            this.addAction();
        } else if (e.widget == this.remove) {
            this.removeAction();
        } else if (e.widget == this.addAll) {
            this.addAllAction();
        } else if (e.widget == this.removeAll) {
            this.removeAllAction();
        }
        super.widgetSelected(e);
    }

    protected void addAction() {
        Object[] elements = this.selector.getSelectedElements();
        this.addElements(elements);
    }

    protected void removeAllAction() {
        this.allElements.clear();
        this.selector.setSelectedElements(new Object[0]);
        this.selectedElementsViewer.setSelection(null);
        this.selectedElementsViewer.refresh();
    }

    protected void addAllAction() {
        Object[] elements = this.selector.getAllElements();
        this.addElements(elements);
    }

    @Override
    public void updateControls() {
        this.updateControl((Control)this.add, this.canAdd());
        super.updateControls();
    }
}

