/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.internal.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.SymbolPackage;
import org.eclipse.jst.jsf.context.symbol.internal.impl.IMapSourceInfo;
import org.eclipse.jst.jsf.context.symbol.internal.impl.ITypeDescriptorImpl;

public class IMapTypeDescriptorImpl
extends ITypeDescriptorImpl
implements IMapTypeDescriptor {
    public static final String copyright = "Copyright 2006 Oracle";
    protected static final Map MAP_SOURCE_EDEFAULT = null;
    protected Map mapSource = MAP_SOURCE_EDEFAULT;
    protected static final boolean IMMUTABLE_EDEFAULT = true;
    private static final Object MAP_TYPE_DESCRIPTOR_PROP_KEY = new Object();
    protected boolean immutable = true;

    protected IMapTypeDescriptorImpl() {
    }

    protected EClass eStaticClass() {
        return SymbolPackage.Literals.IMAP_TYPE_DESCRIPTOR;
    }

    public Map getMapSource() {
        return this.mapSource;
    }

    public void setMapSource(Map newMapSource) {
        Map oldMapSource = this.mapSource;
        this.mapSource = newMapSource;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldMapSource, (Object)this.mapSource));
        }
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean newImmutable) {
        boolean oldImmutable = this.immutable;
        this.immutable = newImmutable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldImmutable, this.immutable));
        }
    }

    public String getTypeSignature() {
        if (this.eIsSet(4)) {
            return this.getTypeSignatureDelegate();
        }
        return "Ljava.util.Map;";
    }

    public EList getInterfaceTypeSignatures() {
        return ECollections.EMPTY_ELIST;
    }

    public EList getSuperTypeSignatures() {
        return ECollections.EMPTY_ELIST;
    }

    public EList getProperties() {
        EList cachedList;
        BasicEList list = new BasicEList();
        Map source = this.getMapSource();
        if (source instanceof IMapSourceInfo && !((IMapSourceInfo)((Object)source)).hasChanged(MAP_TYPE_DESCRIPTOR_PROP_KEY) && (cachedList = (EList)((IMapSourceInfo)((Object)source)).getCachedValue(MAP_TYPE_DESCRIPTOR_PROP_KEY)) != null) {
            return cachedList;
        }
        Map segmentMap = this.processSegments(source);
        list.addAll(segmentMap.values());
        if (source instanceof IMapSourceInfo) {
            ((IMapSourceInfo)((Object)source)).putCachedValue(MAP_TYPE_DESCRIPTOR_PROP_KEY, list);
        }
        return list;
    }

    public EList getMethods() {
        return ECollections.EMPTY_ELIST;
    }

    public IObjectSymbol getArrayElement() {
        return null;
    }

    public boolean isArray() {
        return false;
    }

    private Map processSegments(Map source) {
        HashMap<String, IPropertySymbol> segmentMap = new HashMap<String, IPropertySymbol>();
        Set entrySet = source.entrySet();
        for (Map.Entry entry : entrySet) {
            ITypeDescriptor typeDesc;
            String key = (String)entry.getKey();
            String[] segments = IMapTypeDescriptorImpl.fastTokenSplit(key);
            if (segments.length == 0) continue;
            IPropertySymbol property = (IPropertySymbol)segmentMap.get(segments[0]);
            if (property == null) {
                Object propValue = entry.getValue();
                property = SymbolFactory.eINSTANCE.createIPropertySymbol();
                property.setName(segments[0]);
                ITypeDescriptor typeDesc2 = null;
                if (propValue != null) {
                    if (propValue instanceof IType) {
                        typeDesc2 = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
                        typeDesc2.setType((IType)propValue);
                    } else if (propValue instanceof IInstanceSymbol) {
                        typeDesc2 = ((IInstanceSymbol)propValue).getTypeDescriptor();
                    } else if (propValue instanceof IPropertySymbol) {
                        typeDesc2 = ((IPropertySymbol)propValue).getTypeDescriptor();
                    } else {
                        String className = propValue.getClass().getName();
                        String typeSignature = Signature.createTypeSignature((String)className, (boolean)true);
                        typeDesc2 = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
                        ((IMapTypeDescriptor)typeDesc2).setMapSource(new HashMap());
                        ((IMapTypeDescriptor)typeDesc2).setTypeSignatureDelegate(typeSignature);
                        ((IMapTypeDescriptor)typeDesc2).setImmutable(this.isImmutable());
                        property.setIntermediate(true);
                    }
                    property.setTypeDescriptor(typeDesc2);
                    property.setReadable(true);
                    property.setWritable(!this.isImmutable());
                }
                segmentMap.put(segments[0], property);
            }
            if (!((typeDesc = property.getTypeDescriptor()) instanceof IMapTypeDescriptor)) continue;
            if (segments.length == 1) {
                property.setIntermediate(false);
                continue;
            }
            ((IMapTypeDescriptor)typeDesc).getMapSource().put(key.substring(key.indexOf(46) + 1), entry.getValue());
        }
        return segmentMap;
    }

    private static String[] fastTokenSplit(String splitValue) {
        if (splitValue == null || splitValue.length() == 0) {
            return new String[0];
        }
        if (splitValue.indexOf(46) > -1) {
            return IMapTypeDescriptorImpl.tokenizerSplit(splitValue);
        }
        return new String[]{splitValue};
    }

    private static String[] tokenizerSplit(String splitValue) {
        StringTokenizer stringTokenizer = new StringTokenizer(splitValue, ".");
        ArrayList<String> splitValues = new ArrayList<String>(32);
        while (stringTokenizer.hasMoreTokens()) {
            splitValues.add(stringTokenizer.nextToken());
        }
        return splitValues.toArray(new String[0]);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getMapSource();
            }
            case 10: {
                return this.isImmutable() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setMapSource((Map)newValue);
                return;
            }
            case 10: {
                this.setImmutable((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setMapSource(MAP_SOURCE_EDEFAULT);
                return;
            }
            case 10: {
                this.setImmutable(true);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return MAP_SOURCE_EDEFAULT == null ? this.mapSource != null : !MAP_SOURCE_EDEFAULT.equals(this.mapSource);
            }
            case 10: {
                return !this.immutable;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (mapSource: ");
        result.append(this.mapSource);
        result.append(", immutable: ");
        result.append(this.immutable);
        result.append(')');
        return result.toString();
    }
}

