/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ui.views;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

public class FeatureLabelProvider
extends StyledCellLabelProvider {
    private ILabelProvider delegateProvider = new AdapterFactoryLabelProvider((AdapterFactory)new EcoreItemProviderAdapterFactory());
    private EClass selection;
    private static final StyledString.Styler INHERITED_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            Font italic;
            textStyle.font = italic = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            textStyle.foreground = JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
        }
    };
    private static final StyledString.Styler DERIVED_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            Font italic;
            textStyle.font = italic = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            textStyle.foreground = JFaceResources.getColorRegistry().get("COUNTER_COLOR");
        }
    };

    public EClass getSelection() {
        return this.selection;
    }

    public void setSelection(EClass selection) {
        this.selection = selection;
    }

    public void update(ViewerCell cell) {
        Object obj = cell.getElement();
        StyledString styledString = new StyledString();
        if (obj instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)obj;
            if (this.selection != null) {
                EList localFeatures = this.selection.getEStructuralFeatures();
                if (!localFeatures.contains(feature)) {
                    styledString.append(String.valueOf(this.getName(obj)) + " [" + ((EClass)feature.eContainer()).getName() + "]", INHERITED_STYLER);
                } else {
                    styledString.append(this.getName(obj));
                }
                if (feature.isDerived()) {
                    styledString.append(" (derived)", DERIVED_STYLER);
                }
            }
        }
        cell.setText(styledString.toString());
        cell.setStyleRanges(styledString.getStyleRanges());
        cell.setImage(this.getImage(obj));
        super.update(cell);
    }

    public Image getImage(Object element) {
        return this.delegateProvider.getImage(element);
    }

    public String getName(Object element) {
        return this.delegateProvider.getText(element);
    }
}

