/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLookupFactory;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CProjectSourceLocation;
import org.eclipse.cdt.debug.internal.core.sourcelookup.InternalSourceLookupMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CSourceLocator
implements ICSourceLocator,
IPersistableSourceLocator,
IResourceChangeListener {
    private static final String SOURCE_LOCATOR_NAME = "cSourceLocator";
    private static final String DISABLED_GENERIC_PROJECT_NAME = "disabledGenericProject";
    private static final String ADDITIONAL_SOURCE_LOCATION_NAME = "additionalSourceLocation";
    private static final String SOURCE_LOCATION_NAME = "cSourceLocation";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_MEMENTO = "memento";
    private static final String ATTR_PROJECT_NAME = "projectName";
    private static final String ATTR_DUPLICATE_FILES = "duplicateFiles";
    private IProject fProject;
    private ICSourceLocation[] fSourceLocations;
    private List<IProject> fReferencedProjects = new ArrayList<IProject>(10);
    private boolean fDuplicateFiles;

    public CSourceLocator(IProject project) {
        this.setProject(project);
        this.setReferencedProjects();
        this.setSourceLocations(this.getDefaultSourceLocations());
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        return this.getInput(stackFrame);
    }

    @Override
    public int getLineNumber(IStackFrame frame) {
        return frame instanceof ICStackFrame ? ((ICStackFrame)frame).getFrameLineNumber() : 0;
    }

    protected Object getInput(IStackFrame f) {
        if (f instanceof ICStackFrame) {
            ICStackFrame frame = (ICStackFrame)f;
            LinkedList<Object> list = new LinkedList<Object>();
            Object result = null;
            String fileName = frame.getFile();
            if (fileName != null && fileName.length() > 0) {
                ICSourceLocation[] locations = this.getSourceLocations();
                int i = 0;
                while (i < locations.length) {
                    try {
                        result = locations[i].findSourceElement(fileName);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    if (result != null) {
                        if (result instanceof List) {
                            list.addAll((List)result);
                        } else {
                            list.add(result);
                        }
                        if (!this.searchForDuplicateFiles()) break;
                    }
                    ++i;
                }
            }
            return list.size() > 0 ? (list.size() == 1 ? list.getFirst() : list) : null;
        }
        return null;
    }

    @Override
    public boolean contains(IResource resource) {
        ICSourceLocation[] locations = this.getSourceLocations();
        int i = 0;
        while (i < locations.length) {
            if (resource instanceof IProject && locations[i] instanceof CProjectSourceLocation && ((CProjectSourceLocation)locations[i]).getProject().equals((Object)resource)) {
                return true;
            }
            if (resource instanceof IFile) {
                Object result;
                block7: {
                    result = locations[i].findSourceElement(resource.getLocation().toOSString());
                    if (!(result instanceof IFile) || !((IFile)result).equals((Object)resource)) break block7;
                    return true;
                }
                try {
                    if (result instanceof List && ((List)result).contains(resource)) {
                        return true;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public ICSourceLocation[] getSourceLocations() {
        return this.fSourceLocations;
    }

    @Override
    public void setSourceLocations(ICSourceLocation[] locations) {
        this.fSourceLocations = locations;
    }

    public static ICSourceLocation[] getDefaultSourceLocations(IProject project) {
        ArrayList<IProjectSourceLocation> list = new ArrayList<IProjectSourceLocation>();
        if (project != null && project.exists()) {
            list.add(SourceLookupFactory.createProjectSourceLocation(project));
            CSourceLocator.addReferencedSourceLocations(list, project);
        }
        return list.toArray(new ICSourceLocation[list.size()]);
    }

    private static void addReferencedSourceLocations(List<IProjectSourceLocation> list, IProject project) {
        if (project != null) {
            try {
                IProject[] projects = project.getReferencedProjects();
                int i = 0;
                while (i < projects.length) {
                    if (projects[i].exists() && !CSourceLocator.containsProject(list, projects[i])) {
                        list.add(SourceLookupFactory.createProjectSourceLocation(projects[i]));
                        CSourceLocator.addReferencedSourceLocations(list, projects[i]);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private static boolean containsProject(List<IProjectSourceLocation> list, IProject project) {
        for (CProjectSourceLocation cProjectSourceLocation : list) {
            if (!project.equals((Object)cProjectSourceLocation.getProject())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object findSourceElement(String fileName) {
        Object result = null;
        if (fileName != null && fileName.length() > 0) {
            ICSourceLocation[] locations = this.getSourceLocations();
            int i = 0;
            while (i < locations.length) {
                try {
                    result = locations[i].findSourceElement(fileName);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    public String getMemento() throws CoreException {
        Document document = null;
        Exception ex = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element node = document.createElement(SOURCE_LOCATOR_NAME);
            document.appendChild(node);
            ICSourceLocation[] locations = this.getSourceLocations();
            this.saveDisabledGenericSourceLocations(locations, document, node);
            this.saveAdditionalSourceLocations(locations, document, node);
            node.setAttribute(ATTR_DUPLICATE_FILES, String.valueOf(this.searchForDuplicateFiles()));
            return CDebugUtils.serializeDocument(document);
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        catch (TransformerException e) {
            ex = e;
        }
        this.abort(InternalSourceLookupMessages.CSourceLocator_0, ex);
        return null;
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.setSourceLocations(this.getDefaultSourceLocations());
    }

    public void initializeFromMemento(String memento) throws CoreException {
        Exception ex = null;
        try {
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            if (!root.getNodeName().equalsIgnoreCase(SOURCE_LOCATOR_NAME)) {
                this.abort(InternalSourceLookupMessages.CSourceLocator_1, null);
            }
            ArrayList<ICSourceLocation> sourceLocations = new ArrayList<ICSourceLocation>();
            IProject project = this.getProject();
            if (project != null && project.exists() && project.isOpen()) {
                sourceLocations.addAll(Arrays.asList(this.getDefaultSourceLocations()));
            }
            this.removeDisabledLocations(root, sourceLocations);
            this.addAdditionalLocations(root, sourceLocations);
            this.addOldLocations(root, sourceLocations);
            this.setSourceLocations(sourceLocations.toArray(new ICSourceLocation[sourceLocations.size()]));
            this.setSearchForDuplicateFiles(Boolean.valueOf(root.getAttribute(ATTR_DUPLICATE_FILES)));
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        this.abort(InternalSourceLookupMessages.CSourceLocator_2, ex);
    }

    private void removeDisabledLocations(Element root, List<ICSourceLocation> sourceLocations) {
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        HashSet<String> disabledProjects = new HashSet<String>(length);
        int i = 0;
        while (i < length) {
            Element entry;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(DISABLED_GENERIC_PROJECT_NAME)) {
                String projectName = entry.getAttribute(ATTR_PROJECT_NAME);
                if (this.isEmpty(projectName)) {
                    CDebugCorePlugin.log("Unable to restore C/C++ source locator - invalid format.");
                }
                disabledProjects.add(projectName.trim());
            }
            ++i;
        }
        Iterator<ICSourceLocation> it = sourceLocations.iterator();
        while (it.hasNext()) {
            ICSourceLocation location = it.next();
            if (!(location instanceof IProjectSourceLocation) || !disabledProjects.contains(((IProjectSourceLocation)location).getProject().getName())) continue;
            it.remove();
        }
    }

    private void addAdditionalLocations(Element root, List<ICSourceLocation> sourceLocations) throws CoreException {
        Bundle bundle = CDebugCorePlugin.getDefault().getBundle();
        MultiStatus status = new MultiStatus(CDebugCorePlugin.getUniqueIdentifier(), 1000, InternalSourceLookupMessages.CSourceLocator_3, null);
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            block12: {
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(ADDITIONAL_SOURCE_LOCATION_NAME)) {
                    String className = entry.getAttribute(ATTR_CLASS);
                    String data = entry.getAttribute(ATTR_MEMENTO);
                    if (this.isEmpty(className)) {
                        CDebugCorePlugin.log("Unable to restore C/C++ source locator - invalid format.");
                    } else {
                        Class clazz = null;
                        try {
                            clazz = bundle.loadClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            CDebugCorePlugin.log(MessageFormat.format("Unable to restore source location - class not found {0}", className));
                            break block12;
                        }
                        ICSourceLocation location = null;
                        try {
                            location = (ICSourceLocation)clazz.newInstance();
                        }
                        catch (IllegalAccessException e) {
                            CDebugCorePlugin.log("Unable to restore source location.");
                            break block12;
                        }
                        catch (InstantiationException e) {
                            CDebugCorePlugin.log("Unable to restore source location.");
                            break block12;
                        }
                        try {
                            location.initializeFrom(data);
                            sourceLocations.add(location);
                        }
                        catch (CoreException e) {
                            status.addAll(e.getStatus());
                        }
                    }
                }
            }
            ++i;
        }
        if (status.getSeverity() > 0) {
            throw new CoreException((IStatus)status);
        }
    }

    private void addOldLocations(Element root, List<ICSourceLocation> sourceLocations) throws CoreException {
        Bundle bundle = CDebugCorePlugin.getDefault().getBundle();
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            block11: {
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(SOURCE_LOCATION_NAME)) {
                    String className = entry.getAttribute(ATTR_CLASS);
                    String data = entry.getAttribute(ATTR_MEMENTO);
                    if (this.isEmpty(className)) {
                        CDebugCorePlugin.log("Unable to restore C/C++ source locator - invalid format.");
                    } else {
                        Class clazz = null;
                        try {
                            clazz = bundle.loadClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            CDebugCorePlugin.log(MessageFormat.format("Unable to restore source location - class not found {0}", className));
                            break block11;
                        }
                        ICSourceLocation location = null;
                        try {
                            location = (ICSourceLocation)clazz.newInstance();
                        }
                        catch (IllegalAccessException e) {
                            CDebugCorePlugin.log("Unable to restore source location.");
                            break block11;
                        }
                        catch (InstantiationException e) {
                            CDebugCorePlugin.log("Unable to restore source location.");
                            break block11;
                        }
                        location.initializeFrom(data);
                        if (!sourceLocations.contains(location)) {
                            if (location instanceof CProjectSourceLocation) {
                                ((CProjectSourceLocation)location).setGenerated(this.isReferencedProject(((CProjectSourceLocation)location).getProject()));
                            }
                            sourceLocations.add(location);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, message, e);
        throw new CoreException((IStatus)s);
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] deltas;
        if (event.getSource() instanceof IWorkspace && event.getDelta() != null && (deltas = event.getDelta().getAffectedChildren()) != null) {
            ArrayList<IResource> list = new ArrayList<IResource>(deltas.length);
            int i = 0;
            while (i < deltas.length) {
                if (deltas[i].getResource() instanceof IProject) {
                    list.add(deltas[i].getResource());
                }
                ++i;
            }
            this.resetSourceLocations(list);
        }
    }

    private void saveDisabledGenericSourceLocations(ICSourceLocation[] locations, Document doc, Element node) {
        IProject project = this.getProject();
        if (project != null && project.exists() && project.isOpen()) {
            List<IProject> list = CDebugUtils.getReferencedProjects(project);
            HashSet<String> names = new HashSet<String>(list.size() + 1);
            names.add(project.getName());
            for (IProject proj : list) {
                names.add(proj.getName());
            }
            int i = 0;
            while (i < locations.length) {
                if (locations[i] instanceof IProjectSourceLocation && ((IProjectSourceLocation)locations[i]).isGeneric()) {
                    names.remove(((IProjectSourceLocation)locations[i]).getProject().getName());
                }
                ++i;
            }
            for (String name : names) {
                Element child = doc.createElement(DISABLED_GENERIC_PROJECT_NAME);
                child.setAttribute(ATTR_PROJECT_NAME, name);
                node.appendChild(child);
            }
        }
    }

    private void saveAdditionalSourceLocations(ICSourceLocation[] locations, Document doc, Element node) {
        int i = 0;
        while (i < locations.length) {
            block4: {
                if (!(locations[i] instanceof IProjectSourceLocation) || !((IProjectSourceLocation)locations[i]).isGeneric()) {
                    Element child = doc.createElement(ADDITIONAL_SOURCE_LOCATION_NAME);
                    child.setAttribute(ATTR_CLASS, locations[i].getClass().getName());
                    try {
                        child.setAttribute(ATTR_MEMENTO, locations[i].getMemento());
                    }
                    catch (CoreException e) {
                        CDebugCorePlugin.log(e);
                        break block4;
                    }
                    node.appendChild(child);
                }
            }
            ++i;
        }
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    protected void setProject(IProject project) {
        this.fProject = project;
    }

    private boolean isReferencedProject(IProject ref) {
        if (this.getProject() != null) {
            try {
                return Arrays.asList(this.getProject().getReferencedProjects()).contains(ref);
            }
            catch (CoreException e) {
                CDebugCorePlugin.log(e);
            }
        }
        return false;
    }

    private void setReferencedProjects() {
        this.fReferencedProjects.clear();
        this.fReferencedProjects = CDebugUtils.getReferencedProjects(this.getProject());
    }

    protected ICSourceLocation[] getDefaultSourceLocations() {
        ArrayList<IProjectSourceLocation> list = new ArrayList<IProjectSourceLocation>(this.fReferencedProjects.size());
        if (this.getProject() != null && this.getProject().exists() && this.getProject().isOpen()) {
            list.add(SourceLookupFactory.createProjectSourceLocation(this.getProject()));
        }
        for (IProject project : this.fReferencedProjects) {
            if (project == null || !project.exists() || !project.isOpen()) continue;
            list.add(SourceLookupFactory.createProjectSourceLocation(project));
        }
        return list.toArray(new ICSourceLocation[list.size()]);
    }

    private void resetSourceLocations(List<IResource> affectedProjects) {
        if (affectedProjects.size() != 0 && this.getProject() != null) {
            if (!this.getProject().exists() || !this.getProject().isOpen()) {
                this.removeGenericSourceLocations();
            } else {
                this.updateGenericSourceLocations(affectedProjects);
            }
        }
    }

    private void removeGenericSourceLocations() {
        this.fReferencedProjects.clear();
        ICSourceLocation[] locations = this.getSourceLocations();
        ArrayList<ICSourceLocation> newLocations = new ArrayList<ICSourceLocation>(locations.length);
        int i = 0;
        while (i < locations.length) {
            if (!(locations[i] instanceof IProjectSourceLocation) || !((IProjectSourceLocation)locations[i]).isGeneric()) {
                newLocations.add(locations[i]);
            }
            ++i;
        }
        this.setSourceLocations(newLocations.toArray(new ICSourceLocation[newLocations.size()]));
    }

    private void updateGenericSourceLocations(List<IResource> affectedProjects) {
        List<IProject> newRefs = CDebugUtils.getReferencedProjects(this.getProject());
        ICSourceLocation[] locations = this.getSourceLocations();
        ArrayList<ICSourceLocation> newLocations = new ArrayList<ICSourceLocation>(locations.length);
        int i = 0;
        while (i < locations.length) {
            if (!(locations[i] instanceof IProjectSourceLocation) || !((IProjectSourceLocation)locations[i]).isGeneric()) {
                newLocations.add(locations[i]);
            } else {
                IProject project = ((IProjectSourceLocation)locations[i]).getProject();
                if (project.exists() && project.isOpen() && (newRefs.contains(project) || project.equals((Object)this.getProject()))) {
                    newLocations.add(locations[i]);
                    newRefs.remove(project);
                }
            }
            ++i;
        }
        for (IProject project : newRefs) {
            if (this.fReferencedProjects.contains(project)) continue;
            newLocations.add(SourceLookupFactory.createProjectSourceLocation(project));
        }
        this.fReferencedProjects = newRefs;
        this.setSourceLocations(newLocations.toArray(new ICSourceLocation[newLocations.size()]));
    }

    @Override
    public boolean searchForDuplicateFiles() {
        return this.fDuplicateFiles;
    }

    @Override
    public void setSearchForDuplicateFiles(boolean search) {
        this.fDuplicateFiles = search;
        ICSourceLocation[] locations = this.getSourceLocations();
        int i = 0;
        while (i < locations.length) {
            locations[i].setSearchForDuplicateFiles(search);
            ++i;
        }
    }
}

