/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.sourcelookup;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.internal.core.sourcelookup.InternalSourceLookupMessages;
import org.eclipse.cdt.debug.internal.core.sourcelookup.SourceUtils;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;

public class CProjectSourceContainer
extends CompositeSourceContainer {
    public static final String TYPE_ID = String.valueOf(CDebugCorePlugin.getUniqueIdentifier()) + ".containerType.project";
    private final IProject fOwnProject;
    private IProject fProject;
    private boolean fSearchReferencedProjects;
    private URI fRootURI;
    private IFileStore fRootFile;
    private IWorkspaceRoot fRoot;

    public CProjectSourceContainer(IProject project, boolean referenced) {
        this.fOwnProject = project;
        this.fProject = project;
        this.fSearchReferencedProjects = referenced;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void init(ISourceLookupDirector director) {
        super.init(director);
        if (this.fProject == null && director != null) {
            this.fProject = SourceUtils.getLaunchConfigurationProject(director);
        }
        if (this.fProject != null) {
            this.fRootURI = this.fProject.getLocationURI();
            if (this.fRootURI == null) {
                return;
            }
            try {
                this.fRootFile = EFS.getStore((URI)this.fRootURI);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.fRoot = ResourcesPlugin.getWorkspace().getRoot();
        }
    }

    public void dispose() {
        this.fProject = this.fOwnProject;
        super.dispose();
    }

    public Object[] findSourceElements(String name) throws CoreException {
        int n;
        int n2;
        Object[] objectArray;
        if (this.fProject == null) {
            return EMPTY;
        }
        ArrayList<Object> sources = new ArrayList<Object>();
        if (this.validateFile(name)) {
            IFile file = this.fProject.getFile((IPath)new Path(name));
            if (file.exists()) {
                sources.add(file);
            } else {
                if (this.fRootURI == null) {
                    return EMPTY;
                }
                IFileStore target = this.fRootFile.getFileStore((IPath)new Path(name));
                if (target.fetchInfo().exists()) {
                    IFile[] files = this.fRoot.findFilesForLocationURI(target.toURI());
                    if (this.isFindDuplicates() && files.length > 1) {
                        objectArray = files;
                        n2 = files.length;
                        n = 0;
                        while (n < n2) {
                            Object f = objectArray[n];
                            sources.add(f);
                            ++n;
                        }
                    } else if (files.length > 0) {
                        sources.add(files[0]);
                    }
                }
            }
        }
        if (this.isFindDuplicates() || sources.isEmpty()) {
            ISourceContainer[] containers = this.getSourceContainers();
            int i = 0;
            while (i < containers.length) {
                Object[] objects = containers[i].findSourceElements(name);
                if (objects != null && objects.length != 0) {
                    if (this.isFindDuplicates()) {
                        objectArray = objects;
                        n2 = objects.length;
                        n = 0;
                        while (n < n2) {
                            Object object = objectArray[n];
                            sources.add(object);
                            ++n;
                        }
                    } else {
                        sources.add(objects[0]);
                        break;
                    }
                }
                ++i;
            }
        }
        if (sources.isEmpty()) {
            return EMPTY;
        }
        return sources.toArray();
    }

    public String getName() {
        return this.fProject != null ? this.fProject.getName() : InternalSourceLookupMessages.CProjectSourceContainer_0;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof CProjectSourceContainer) {
            CProjectSourceContainer loc = (CProjectSourceContainer)((Object)obj);
            return this.fProject == null ? loc.fProject == null : this.fProject.equals((Object)loc.fProject);
        }
        return false;
    }

    public int hashCode() {
        return TYPE_ID.hashCode() * 31 + (this.fProject == null ? 0 : this.fProject.hashCode());
    }

    public boolean isComposite() {
        return true;
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        if (this.fProject != null && this.fProject.isOpen()) {
            if (this.isSearchReferencedProjects()) {
                IProject[] projects = SourceUtils.getAllReferencedProjects(this.fProject);
                ISourceContainer[] folders = this.createFolderSourceContainers(this.fProject);
                ArrayList<Object> containers = new ArrayList<Object>(folders.length + projects.length);
                ISourceContainer[] iSourceContainerArray = folders;
                int n = folders.length;
                int n2 = 0;
                while (n2 < n) {
                    ISourceContainer folder = iSourceContainerArray[n2];
                    containers.add(folder);
                    ++n2;
                }
                iSourceContainerArray = projects;
                n = projects.length;
                n2 = 0;
                while (n2 < n) {
                    ISourceContainer ref = iSourceContainerArray[n2];
                    if (ref.exists() && ref.isOpen()) {
                        CProjectSourceContainer container = new CProjectSourceContainer((IProject)ref, false);
                        container.init(this.getDirector());
                        containers.add((Object)container);
                    }
                    ++n2;
                }
                return containers.toArray(new ISourceContainer[containers.size()]);
            }
            return this.createFolderSourceContainers(this.fProject);
        }
        return new ISourceContainer[0];
    }

    private ISourceContainer[] createFolderSourceContainers(IProject project) throws CoreException {
        ISourceContainer[] containers;
        IResource[] resources = project.members();
        ArrayList<FolderSourceContainer> list = new ArrayList<FolderSourceContainer>(resources.length);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 2) {
                list.add(new FolderSourceContainer((IContainer)((IFolder)resource), true));
            }
            ++n2;
        }
        ISourceContainer[] iSourceContainerArray = containers = list.toArray(new ISourceContainer[list.size()]);
        int n3 = containers.length;
        n = 0;
        while (n < n3) {
            ISourceContainer container = iSourceContainerArray[n];
            container.init(this.getDirector());
            ++n;
        }
        return containers;
    }

    private boolean validateFile(String name) {
        if (this.fProject == null) {
            return false;
        }
        IPath path = this.fProject.getFullPath().append(name);
        return ResourcesPlugin.getWorkspace().validatePath(path.toOSString(), 1).isOK();
    }

    public boolean isSearchReferencedProjects() {
        return this.fSearchReferencedProjects;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }
}

