/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.executables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.IExecutableImporter;
import org.eclipse.cdt.debug.core.executables.IExecutablesChangeListener;
import org.eclipse.cdt.debug.core.executables.IExecutablesChangeListener2;
import org.eclipse.cdt.debug.core.executables.IProjectExecutablesProvider;
import org.eclipse.cdt.debug.core.executables.ISourceFileRemappingFactory;
import org.eclipse.cdt.debug.core.executables.ISourceFilesProvider;
import org.eclipse.cdt.debug.core.executables.StandardExecutableProvider;
import org.eclipse.cdt.debug.internal.core.Trace;
import org.eclipse.cdt.debug.internal.core.executables.StandardExecutableImporter;
import org.eclipse.cdt.debug.internal.core.executables.StandardSourceFileRemappingFactory;
import org.eclipse.cdt.debug.internal.core.executables.StandardSourceFilesProvider;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;

public class ExecutablesManager
extends PlatformObject
implements ICProjectDescriptionListener,
IElementChangedListener,
IResourceChangeListener {
    private Map<IProject, IProjectExecutablesProvider> executablesProviderMap = new HashMap<IProject, IProjectExecutablesProvider>();
    private List<IExecutablesChangeListener> changeListeners = Collections.synchronizedList(new ArrayList());
    private List<IProjectExecutablesProvider> executableProviders;
    private List<ISourceFilesProvider> sourceFileProviders;
    private List<ISourceFileRemappingFactory> sourceFileRemappingFactories;
    private List<IExecutableImporter> executableImporters;
    private Map<String, String> locatorMementos = new HashMap<String, String>();
    private Map<IProject, List<Executable>> executablesMap = new HashMap<IProject, List<Executable>>();
    private SearchJob searchJob = new SearchJob();
    private Object searchSchedulingLock = new Object();
    private static ExecutablesManager executablesManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Executable> flattenExecutablesMap() {
        ArrayList<Executable> result = new ArrayList<Executable>(this.executablesMap.size() * 5);
        Map<IProject, List<Executable>> map = this.executablesMap;
        synchronized (map) {
            for (List<Executable> exes : this.executablesMap.values()) {
                for (Executable exe : exes) {
                    if (result.contains((Object)exe)) continue;
                    result.add(exe);
                }
            }
        }
        return result;
    }

    public static ExecutablesManager getExecutablesManager() {
        if (executablesManager == null) {
            executablesManager = new ExecutablesManager();
        }
        return executablesManager;
    }

    public ExecutablesManager() {
        this.searchJob.setPriority(20);
        this.loadExecutableProviderExtensions();
        this.loadSoureFileProviderExtensions();
        this.loadSoureRemappingExtensions();
        this.loadExecutableImporterExtensions();
        this.executableProviders.add(0, new StandardExecutableProvider());
        this.sourceFileProviders.add(0, new StandardSourceFilesProvider());
        this.sourceFileRemappingFactories.add(0, new StandardSourceFileRemappingFactory());
        this.executableImporters.add(0, new StandardExecutableImporter());
        CModelManager.getDefault().addElementChangedListener((IElementChangedListener)this);
        CoreModel.getDefault().getProjectDescriptionManager().addCProjectDescriptionListener((ICProjectDescriptionListener)this, 4);
        CDebugCorePlugin.getDefault().getCommonSourceLookupDirector().addParticipants(new ISourceLookupParticipant[]{new ISourceLookupParticipant(){

            public void init(ISourceLookupDirector director) {
            }

            public Object[] findSourceElements(Object object) {
                return new Object[0];
            }

            public String getSourceName(Object object) throws CoreException {
                return "";
            }

            public void dispose() {
            }

            public void sourceContainersChanged(ISourceLookupDirector director) {
                ExecutablesManager.this.flushExecutablesSourceMappings();
            }
        }});
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(new ILaunchConfigurationListener(){

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
                if (configuration.isWorkingCopy()) {
                    return;
                }
                try {
                    String configName = configuration.getName();
                    String mementoBefore = ExecutablesManager.this.locatorMementos.get(configName);
                    String mementoNow = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, "");
                    if (mementoNow.equals(mementoBefore)) {
                        return;
                    }
                    ExecutablesManager.this.locatorMementos.put(configName, mementoNow);
                }
                catch (CoreException e) {
                    CDebugCorePlugin.log(e);
                }
                ExecutablesManager.this.flushExecutablesSourceMappings();
            }

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
                this.configAddedOrRemoved(configuration);
            }

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
                this.configAddedOrRemoved(configuration);
            }

            private void configAddedOrRemoved(ILaunchConfiguration configuration) {
                if (configuration.isWorkingCopy()) {
                    return;
                }
                ExecutablesManager.this.flushExecutablesSourceMappings();
            }
        });
        this.scheduleExecutableSearch(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushExecutablesSourceMappings() {
        List<Executable> exes = this.flattenExecutablesMap();
        for (Executable exe : exes) {
            exe.setRemapSourceFiles(true);
        }
        List<IExecutablesChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (IExecutablesChangeListener listener : this.changeListeners) {
                listener.executablesChanged(exes);
            }
        }
    }

    public void addExecutablesChangeListener(IExecutablesChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeExecutablesChangeListener(IExecutablesChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public Collection<Executable> getExecutables(boolean wait) {
        if (Trace.DEBUG_EXECUTABLES) {
            Trace.getTrace().traceEntry(null, (Object)wait);
        }
        if (wait && this.searchJob.getState() != 0) {
            if (Trace.DEBUG_EXECUTABLES) {
                Trace.getTrace().trace(null, "Waiting for executable search to finish...");
            }
            try {
                this.searchJob.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (Trace.DEBUG_EXECUTABLES) {
                Trace.getTrace().trace(null, "...executable search finished.");
            }
        }
        if (Trace.DEBUG_EXECUTABLES) {
            Trace.getTrace().traceExit(null);
        }
        return this.flattenExecutablesMap();
    }

    public Collection<Executable> getExecutables() {
        return this.getExecutables(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Executable> getExecutablesForProject(IProject project) {
        ArrayList<Executable> executables = new ArrayList<Executable>();
        Map<IProject, List<Executable>> map = this.executablesMap;
        synchronized (map) {
            List<Executable> exes = this.executablesMap.get(project);
            if (exes != null) {
                for (Executable exe : exes) {
                    if (executables.contains((Object)exe)) continue;
                    executables.add(exe);
                }
            }
        }
        return executables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importExecutables(final String[] fileNames, IProgressMonitor monitor) {
        boolean handled = false;
        monitor.beginTask("Import Executables", this.executableImporters.size());
        List<IExecutableImporter> list = this.executableImporters;
        synchronized (list) {
            Collections.sort(this.executableImporters, new Comparator<IExecutableImporter>(){

                @Override
                public int compare(IExecutableImporter arg0, IExecutableImporter arg1) {
                    int p1;
                    int p0 = arg0.getPriority(fileNames);
                    if (p0 < (p1 = arg1.getPriority(fileNames))) {
                        return 1;
                    }
                    if (p0 > p1) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (IExecutableImporter importer : this.executableImporters) {
                handled = importer.importExecutables(fileNames, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (handled || monitor.isCanceled()) break;
            }
        }
        if (handled) {
            this.scheduleExecutableSearch(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean executableExists(IPath exePath) {
        Map<IProject, List<Executable>> map = this.executablesMap;
        synchronized (map) {
            Iterator<List<Executable>> iterator = this.executablesMap.values().iterator();
            block3: while (true) {
                Executable exe;
                if (!iterator.hasNext()) {
                    return false;
                }
                List<Executable> exes = iterator.next();
                Iterator<Executable> iterator2 = exes.iterator();
                do {
                    if (!iterator2.hasNext()) continue block3;
                } while (!(exe = iterator2.next()).getPath().equals((Object)exePath));
                break;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSourceFiles(final Executable executable, IProgressMonitor monitor) {
        if (Trace.DEBUG_EXECUTABLES) {
            Trace.getTrace().traceEntry(null, (Object)executable);
        }
        String[] result = new String[]{};
        List<ISourceFilesProvider> list = this.sourceFileProviders;
        synchronized (list) {
            Collections.sort(this.sourceFileProviders, new Comparator<ISourceFilesProvider>(){

                @Override
                public int compare(ISourceFilesProvider arg0, ISourceFilesProvider arg1) {
                    int p1;
                    int p0 = arg0.getPriority(executable);
                    if (p0 < (p1 = arg1.getPriority(executable))) {
                        return 1;
                    }
                    if (p0 > p1) {
                        return -1;
                    }
                    return 0;
                }
            });
            monitor.beginTask("Finding source files in " + executable.getName(), this.sourceFileProviders.size() * 1000);
            for (ISourceFilesProvider provider : this.sourceFileProviders) {
                String[] sourceFiles = provider.getSourceFiles(executable, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (sourceFiles.length <= 0) continue;
                result = sourceFiles;
                if (!Trace.DEBUG_EXECUTABLES) break;
                Trace.getTrace().trace(null, "Got " + sourceFiles.length + " files from " + provider.toString());
                break;
            }
            monitor.done();
        }
        if (Trace.DEBUG_EXECUTABLES) {
            Trace.getTrace().traceExit(null, (Object)result);
        }
        return result;
    }

    public IStatus removeExecutables(Executable[] executables, IProgressMonitor monitor) {
        MultiStatus status = new MultiStatus("org.eclipse.cdt.debug.core", 2, "Couldn't remove all of the selected executables", null);
        monitor.beginTask("Remove Executables", executables.length);
        Executable[] executableArray = executables;
        int n = executables.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus result;
            Executable executable = executableArray[n2];
            IProjectExecutablesProvider provider = this.getExecutablesProviderForProject(executable.getProject());
            if (provider != null && !(result = provider.removeExecutable(executable, (IProgressMonitor)new SubProgressMonitor(monitor, 1))).isOK()) {
                status.add(result);
            }
            ++n2;
        }
        return status;
    }

    public void refresh(List<IProject> projectsToRefresh) {
        this.scheduleExecutableSearch(projectsToRefresh != null ? projectsToRefresh.toArray(new IProject[projectsToRefresh.size()]) : null);
    }

    @Deprecated
    public void resourceChanged(IResourceChangeEvent event) {
    }

    public void handleEvent(CProjectDescriptionEvent event) {
        int eventType;
        if (Trace.DEBUG_EXECUTABLES) {
            Trace.getTrace().traceEntry(null, (Object)event);
        }
        if ((eventType = event.getEventType()) == 4) {
            ICProjectDescription newDesc = event.getNewCProjectDescription();
            ICProjectDescription oldDesc = event.getOldCProjectDescription();
            if (oldDesc != null && newDesc != null) {
                String oldConfigName;
                String newConfigName = newDesc.getActiveConfiguration().getName();
                if (!newConfigName.equals(oldConfigName = oldDesc.getActiveConfiguration().getName())) {
                    if (Trace.DEBUG_EXECUTABLES) {
                        Trace.getTrace().trace(null, "Scheduling refresh because active build configuration changed");
                    }
                    this.scheduleExecutableSearch(new IProject[]{newDesc.getProject()});
                }
            } else if (newDesc != null && oldDesc == null) {
                this.scheduleExecutableSearch(null);
                if (Trace.DEBUG_EXECUTABLES) {
                    Trace.getTrace().trace(null, "Scheduling refresh because project " + newDesc.getProject().getName() + " created");
                }
            }
        }
    }

    private void scheduleExecutableSearch(final IProject[] projectsToRefresh) {
        if (Trace.DEBUG_EXECUTABLES) {
            Trace.getTrace().traceEntry(null, (Object[])projectsToRefresh);
        }
        Job job = new Job("Executable search scheduler"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                Object object = ExecutablesManager.this.searchSchedulingLock;
                synchronized (object) {
                    ExecutablesManager.this.searchJob.cancel();
                    if (ExecutablesManager.this.searchJob.getState() != 0) {
                        try {
                            if (Trace.DEBUG_EXECUTABLES) {
                                Trace.getTrace().trace(null, "Waiting for canceled job to terminate");
                            }
                            ExecutablesManager.this.searchJob.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (Trace.DEBUG_EXECUTABLES) {
                        Trace.getTrace().trace(null, "Scheduling new search job");
                    }
                    ExecutablesManager.this.searchJob.schedule(projectsToRefresh);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    private IProjectExecutablesProvider getExecutablesProviderForProject(IProject project) {
        IProjectExecutablesProvider provider = this.executablesProviderMap.get(project);
        if (provider == null) {
            try {
                IProjectDescription description = project.getDescription();
                int mostNaturesMatched = 0;
                for (IProjectExecutablesProvider exeProvider : this.executableProviders) {
                    List<String> natures = exeProvider.getProjectNatures();
                    int naturesMatched = 0;
                    String[] stringArray = description.getNatureIds();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String nature = stringArray[n2];
                        if (natures.contains(nature)) {
                            ++naturesMatched;
                        }
                        ++n2;
                    }
                    if (naturesMatched <= mostNaturesMatched) continue;
                    provider = exeProvider;
                    mostNaturesMatched = naturesMatched;
                }
                this.executablesProviderMap.put(project, provider);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return provider;
    }

    ISourceFileRemappingFactory[] getSourceFileRemappingFactories() {
        return this.sourceFileRemappingFactories.toArray(new ISourceFileRemappingFactory[this.sourceFileRemappingFactories.size()]);
    }

    private void loadExecutableProviderExtensions() {
        this.executableProviders = Collections.synchronizedList(new ArrayList());
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.cdt.debug.core.ExecutablesProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            IConfigurationElement element = elements[0];
            boolean failed = false;
            try {
                Object extObject = element.createExecutableExtension("class");
                if (extObject instanceof IProjectExecutablesProvider) {
                    this.executableProviders.add((IProjectExecutablesProvider)extObject);
                } else {
                    failed = true;
                }
            }
            catch (CoreException e) {
                failed = true;
            }
            if (failed) {
                CDebugCorePlugin.log("Unable to load ExecutablesProvider extension from " + extension.getContributor().getName());
            }
            ++i;
        }
    }

    private void loadSoureFileProviderExtensions() {
        this.sourceFileProviders = Collections.synchronizedList(new ArrayList());
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.cdt.debug.core.SourceFilesProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            IConfigurationElement element = elements[0];
            boolean failed = false;
            try {
                Object extObject = element.createExecutableExtension("class");
                if (extObject instanceof ISourceFilesProvider) {
                    this.sourceFileProviders.add((ISourceFilesProvider)extObject);
                } else {
                    failed = true;
                }
            }
            catch (CoreException e) {
                failed = true;
            }
            if (failed) {
                CDebugCorePlugin.log("Unable to load SourceFilesProvider extension from " + extension.getContributor().getName());
            }
            ++i;
        }
    }

    private void loadSoureRemappingExtensions() {
        this.sourceFileRemappingFactories = Collections.synchronizedList(new ArrayList());
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.cdt.debug.core.SourceRemappingProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            IConfigurationElement element = elements[0];
            boolean failed = false;
            try {
                Object extObject = element.createExecutableExtension("class");
                if (extObject instanceof ISourceFileRemappingFactory) {
                    this.sourceFileRemappingFactories.add((ISourceFileRemappingFactory)extObject);
                } else {
                    failed = true;
                }
            }
            catch (CoreException e) {
                failed = true;
            }
            if (failed) {
                CDebugCorePlugin.log("Unable to load SourceRemappingProvider extension from " + extension.getContributor().getName());
            }
            ++i;
        }
    }

    private void loadExecutableImporterExtensions() {
        this.executableImporters = Collections.synchronizedList(new ArrayList());
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.cdt.debug.core.ExecutablesImporter");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            IConfigurationElement element = elements[0];
            boolean failed = false;
            try {
                Object extObject = element.createExecutableExtension("class");
                if (extObject instanceof IExecutableImporter) {
                    this.executableImporters.add((IExecutableImporter)extObject);
                } else {
                    failed = true;
                }
            }
            catch (CoreException e) {
                failed = true;
            }
            if (failed) {
                CDebugCorePlugin.log("Unable to load ExecutablesImporter extension from " + extension.getContributor().getName());
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elementChanged(ElementChangedEvent event) {
        List<IExecutablesChangeListener> list;
        Object list2;
        if (Trace.DEBUG_EXECUTABLES) {
            Trace.getTrace().traceEntry(null);
        }
        if (Trace.DEBUG_EXECUTABLES) {
            Trace.getTrace().trace(null, "event = \n" + event);
        }
        HashSet<IProject> refreshProjects = new HashSet<IProject>(5);
        HashSet<Executable> executablesChanged = new HashSet<Executable>(5);
        HashSet<Executable> executablesRemoved = new HashSet<Executable>(5);
        this.processDeltas(event.getDelta().getAddedChildren(), null, refreshProjects, executablesRemoved, executablesChanged);
        this.processDeltas(event.getDelta().getChangedChildren(), null, refreshProjects, executablesRemoved, executablesChanged);
        this.processDeltas(event.getDelta().getRemovedChildren(), null, refreshProjects, executablesRemoved, executablesChanged);
        if (refreshProjects.size() > 0) {
            if (Trace.DEBUG_EXECUTABLES) {
                Trace.getTrace().trace(null, "One or more projects need to be re-searched");
            }
            this.scheduleExecutableSearch(refreshProjects.toArray(new IProject[refreshProjects.size()]));
        }
        if (executablesChanged.size() > 0) {
            if (Trace.DEBUG_EXECUTABLES) {
                Trace.getTrace().trace(null, "One or more executables changed");
            }
            for (Executable exec : executablesChanged) {
                exec.setRefreshSourceFiles(true);
            }
            list2 = Arrays.asList(executablesChanged.toArray(new Executable[executablesChanged.size()]));
            list = this.changeListeners;
            synchronized (list) {
                for (IExecutablesChangeListener iExecutablesChangeListener : this.changeListeners) {
                    iExecutablesChangeListener.executablesChanged((List<Executable>)list2);
                }
            }
        }
        if (executablesRemoved.size() > 0) {
            if (Trace.DEBUG_EXECUTABLES) {
                Trace.getTrace().trace(null, "One or more executables were removed");
            }
            list2 = this.executablesMap;
            synchronized (list2) {
                for (Executable executableRemoved : executablesRemoved) {
                    List<Executable> execs = this.executablesMap.get(executableRemoved.getProject());
                    assert (execs != null) : "considering the list was used in populating 'executablesRemoved', how could it be gone now?";
                    if (execs == null) continue;
                    execs.remove((Object)executableRemoved);
                }
            }
            List<Executable> list3 = Arrays.asList(executablesRemoved.toArray(new Executable[executablesRemoved.size()]));
            list = this.changeListeners;
            synchronized (list) {
                for (IExecutablesChangeListener iExecutablesChangeListener : this.changeListeners) {
                    if (iExecutablesChangeListener instanceof IExecutablesChangeListener2) {
                        ((IExecutablesChangeListener2)iExecutablesChangeListener).executablesRemoved(list3);
                    }
                    iExecutablesChangeListener.executablesListChanged();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeltas(ICElementDelta[] deltas, ICProject cproject, Set<IProject> projectsToRefresh, Set<Executable> removedExecutables, Set<Executable> changedExecutables) {
        ICElementDelta[] iCElementDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            ICElementDelta delta = iCElementDeltaArray[n2];
            ICElement element = delta.getElement();
            if (element instanceof ICProject) {
                project = ((ICProject)element).getProject();
                if (delta.getKind() == 2) {
                    projectsToRefresh.add(project);
                    List<Executable> execs = null;
                    Map<IProject, List<Executable>> map = this.executablesMap;
                    synchronized (map) {
                        execs = this.executablesMap.get(project);
                    }
                    if (execs != null) {
                        for (Executable exec : execs) {
                            if (!exec.getResource().equals((Object)delta.getElement().getResource())) continue;
                            removedExecutables.add(exec);
                            break;
                        }
                    }
                }
            } else if (element instanceof IBinary) {
                project = cproject.getProject();
                int deltaKind = delta.getKind();
                switch (deltaKind) {
                    case 1: {
                        projectsToRefresh.add(project);
                        break;
                    }
                    case 2: 
                    case 4: {
                        List<Executable> execs = null;
                        Map<IProject, List<Executable>> map = this.executablesMap;
                        synchronized (map) {
                            execs = this.executablesMap.get(project);
                            if (execs == null) {
                                projectsToRefresh.add(project);
                            } else {
                                for (Executable exec : execs) {
                                    if (!exec.getResource().equals((Object)delta.getElement().getResource())) continue;
                                    if (deltaKind == 2) {
                                        removedExecutables.add(exec);
                                        break;
                                    }
                                    changedExecutables.add(exec);
                                    break;
                                }
                            }
                            break;
                        }
                    }
                }
            }
            if (element instanceof ICProject) {
                cproject = (ICProject)element;
            }
            this.processDeltas(delta.getAffectedChildren(), cproject, projectsToRefresh, removedExecutables, changedExecutables);
            ++n2;
        }
    }

    class SearchJob
    extends Job {
        private IProject[] projectsToRefresh;

        SearchJob() {
            super("Executables Search");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            Object object;
            if (Trace.DEBUG_EXECUTABLES) {
                Trace.getTrace().trace(null, "Search for executables started");
            }
            IStatus status = Status.OK_STATUS;
            List<Executable> before = ExecutablesManager.this.flattenExecutablesMap();
            ArrayList<IProject> projects = new ArrayList<IProject>();
            Map<IProject, List<Executable>> map = ExecutablesManager.this.executablesMap;
            synchronized (map) {
                IProject project;
                int n;
                int n2;
                if (this.projectsToRefresh == null) {
                    ExecutablesManager.this.executablesMap.clear();
                } else {
                    object = this.projectsToRefresh;
                    n2 = this.projectsToRefresh.length;
                    n = 0;
                    while (n < n2) {
                        project = object[n];
                        ExecutablesManager.this.executablesMap.remove(project);
                        ++n;
                    }
                }
                object = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                n2 = ((IProject[])object).length;
                n = 0;
                while (n < n2) {
                    project = object[n];
                    if (!ExecutablesManager.this.executablesMap.containsKey(project) && CoreModel.hasCNature((IProject)project)) {
                        projects.add(project);
                    }
                    ++n;
                }
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)projects.size());
            for (IProject project : projects) {
                if (subMonitor.isCanceled()) {
                    if (Trace.DEBUG_EXECUTABLES) {
                        Trace.getTrace().trace(null, "Search for executables canceled");
                    }
                    status = Status.CANCEL_STATUS;
                    break;
                }
                subMonitor.subTask("Checking project: " + project.getName());
                IProjectExecutablesProvider provider = ExecutablesManager.this.getExecutablesProviderForProject(project);
                if (provider == null) continue;
                if (Trace.DEBUG_EXECUTABLES) {
                    Trace.getTrace().trace(null, "Getting executables for project: " + project.getName() + " using " + provider.toString());
                }
                List<Executable> executables = provider.getExecutables(project, (IProgressMonitor)subMonitor.newChild(1, 0));
                Map<IProject, List<Executable>> map2 = ExecutablesManager.this.executablesMap;
                synchronized (map2) {
                    ExecutablesManager.this.executablesMap.put(project, executables);
                }
            }
            List<Executable> after = ExecutablesManager.this.flattenExecutablesMap();
            List<Executable> removed = before;
            ArrayList<Executable> added = new ArrayList<Executable>(after.size());
            for (Executable a : after) {
                if (removed.remove((Object)a)) continue;
                added.add(a);
            }
            object = ExecutablesManager.this.changeListeners;
            synchronized (object) {
                if (removed.size() > 0 || added.size() > 0) {
                    for (IExecutablesChangeListener listener : ExecutablesManager.this.changeListeners) {
                        if (listener instanceof IExecutablesChangeListener2) {
                            if (removed.size() > 0) {
                                ((IExecutablesChangeListener2)listener).executablesRemoved(removed);
                            }
                            if (added.size() > 0) {
                                ((IExecutablesChangeListener2)listener).executablesAdded(added);
                            }
                        }
                        listener.executablesListChanged();
                    }
                }
            }
            if (Trace.DEBUG_EXECUTABLES) {
                Trace.getTrace().trace(null, "Search for executables finished");
            }
            return status;
        }

        public void schedule(IProject[] projectsToRefresh) {
            this.projectsToRefresh = projectsToRefresh;
            super.schedule();
        }
    }
}

