/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.logging;

import org.eclipse.reddeer.common.exception.RedDeerException;

public enum LogLevel {
    OFF(0),
    FATAL(100),
    ERROR(200),
    DUMP(250),
    STEP(250),
    WARN(300),
    INFO(400),
    DEBUG(500),
    TRACE(600),
    ALL(Integer.MAX_VALUE);

    private final int value;

    private LogLevel(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return new Integer(this.value).toString();
    }

    public LogLevel fromString(String string) {
        String upper;
        switch (upper = string.toUpperCase()) {
            case "OFF": {
                return OFF;
            }
            case "FATAL": {
                return FATAL;
            }
            case "ERROR": {
                return ERROR;
            }
            case "STEP": {
                return STEP;
            }
            case "WARN": {
                return WARN;
            }
            case "INFO": {
                return INFO;
            }
            case "DEBUG": {
                return DEBUG;
            }
            case "TRACE": {
                return TRACE;
            }
            case "ALL": {
                return ALL;
            }
        }
        throw new RedDeerException("Unsupported log level value" + upper);
    }
}

