/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.target;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.wizards.target.EditTargetNode;
import org.eclipse.pde.internal.ui.wizards.target.NewTargetDefinitionWizard2;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class TargetCreationPage
extends WizardSelectionPage {
    protected static final int USE_EMPTY = 0;
    protected static final int USE_DEFAULT = 1;
    protected static final int USE_CURRENT_TP = 2;
    protected static final int USE_EXISTING_TARGET = 3;
    private Button fEmptyButton;
    private Button fDefaultButton;
    private Button fCurrentTPButton;
    private Button fExistingTargetButton;
    private Combo fTargets;
    private String[] fTargetIds;
    private String templateTargetId;
    private ITargetDefinition[] fTargetDefs = new ITargetDefinition[4];

    public TargetCreationPage(String pageName) {
        super(pageName);
        this.setTitle(PDEUIMessages.TargetProfileWizardPage_title);
        this.setDescription(PDEUIMessages.TargetProfileWizardPage_description);
    }

    protected ITargetPlatformService getTargetService() {
        return (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808);
        SWTFactory.createLabel(comp, PDEUIMessages.TargetCreationPage_0, 3);
        this.fEmptyButton = SWTFactory.createRadioButton(comp, PDEUIMessages.TargetCreationPage_1, 2);
        this.fDefaultButton = SWTFactory.createRadioButton(comp, PDEUIMessages.TargetCreationPage_2, 2);
        this.fCurrentTPButton = SWTFactory.createRadioButton(comp, PDEUIMessages.TargetCreationPage_3, 2);
        this.fExistingTargetButton = SWTFactory.createRadioButton(comp, PDEUIMessages.TargetCreationPage_4, 1);
        this.fExistingTargetButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean enabled = this.fExistingTargetButton.getSelection();
            this.fTargets.setEnabled(enabled);
        }));
        this.fEmptyButton.setSelection(true);
        this.fTargets = SWTFactory.createCombo(comp, 12, 1, 1, null);
        this.fTargets.setEnabled(false);
        this.initializeTargetCombo();
        this.fTargets.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String string = this.templateTargetId = this.fTargetIds[this.fTargets.getSelectionIndex()];
        }));
        Dialog.applyDialogFont((Control)comp);
        this.setSelectedNode(new EditTargetNode());
        this.setControl((Control)comp);
        this.setPageComplete(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.pde.doc.user.new_target_wizard");
    }

    protected void initializeTargetCombo() {
        IConfigurationElement[] elements = PDECore.getDefault().getTargetProfileManager().getSortedTargets();
        this.fTargetIds = new String[elements.length];
        int i = 0;
        while (i < elements.length) {
            String name = elements[i].getAttribute("name");
            if (this.fTargets.indexOf(name) == -1) {
                this.fTargets.add(name);
            }
            this.fTargetIds[i] = elements[i].getAttribute("id");
            ++i;
        }
        if (elements.length > 0) {
            this.fTargets.select(0);
            this.setTargetId(this.fTargetIds[this.fTargets.getSelectionIndex()]);
        }
    }

    protected int getInitializationOption() {
        if (this.fEmptyButton.getSelection()) {
            return 0;
        }
        if (this.fDefaultButton.getSelection()) {
            return 1;
        }
        if (this.fCurrentTPButton.getSelection()) {
            return 2;
        }
        return 3;
    }

    protected String getTargetId() {
        return this.templateTargetId;
    }

    protected void setTargetId(String targetId) {
        this.templateTargetId = targetId;
    }

    protected ITargetDefinition createTarget(int targetOption) {
        ITargetPlatformService service = this.getTargetService();
        if (service != null) {
            ITargetDefinition definition = service.newTarget();
            switch (targetOption) {
                case 0: {
                    definition.setName(PDEUIMessages.TargetCreationPage_6);
                    break;
                }
                case 1: {
                    try {
                        this.populateBasicTarget(definition);
                        break;
                    }
                    catch (CoreException e) {
                        this.setErrorMessage(e.getMessage());
                        return null;
                    }
                }
                case 2: {
                    try {
                        this.populateFromCurrentTargetPlatform(definition);
                        break;
                    }
                    catch (CoreException e) {
                        this.setErrorMessage(e.getMessage());
                        return null;
                    }
                }
                case 3: {
                    try {
                        this.populateFromTemplate(definition, this.getTargetId());
                        break;
                    }
                    catch (CoreException e) {
                        this.setErrorMessage(e.getMessage());
                        return null;
                    }
                }
            }
            return definition;
        }
        return null;
    }

    private void populateBasicTarget(ITargetDefinition definition) throws CoreException {
        ITargetPlatformService service = this.getTargetService();
        if (service != null) {
            ITargetDefinition def = service.newDefaultTarget();
            service.copyTargetDefinition(def, definition);
        }
    }

    private void populateFromCurrentTargetPlatform(ITargetDefinition definition) throws CoreException {
        ITargetPlatformService service = this.getTargetService();
        if (service != null) {
            ITargetDefinition current = service.getWorkspaceTargetDefinition();
            service.copyTargetDefinition(current, definition);
        }
    }

    private void populateFromTemplate(ITargetDefinition definition, String id) throws CoreException {
        ITargetPlatformService service = this.getTargetService();
        if (service != null) {
            service.loadTargetDefinition(definition, id);
        }
    }

    public IWizardPage getNextPage() {
        int option = this.getInitializationOption();
        if (this.fTargetDefs[option] == null) {
            this.fTargetDefs[option] = this.createTarget(option);
        } else if (option == 3) {
            try {
                this.populateFromTemplate(this.fTargetDefs[option], this.getTargetId());
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
            }
        }
        ITargetDefinition target = this.fTargetDefs[option];
        if (target != null) {
            ((NewTargetDefinitionWizard2)this.getWizard()).setTargetDefinition(target);
            ((EditTargetNode)this.getSelectedNode()).setTargetDefinition(target);
            return super.getNextPage();
        }
        return null;
    }
}

