/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.launcher.PluginStatusDialog;
import org.eclipse.pde.internal.ui.shared.CachedCheckboxTreeViewer;
import org.eclipse.pde.internal.ui.shared.FilteredCheckboxTree;
import org.eclipse.pde.internal.ui.util.PersistablePluginObject;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.util.SourcePluginFilter;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.ui.launcher.BundlesTab;
import org.eclipse.pde.ui.launcher.PluginsTab;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.dialogs.PatternFilter;

public abstract class AbstractPluginBlock {
    protected AbstractLauncherTab fTab;
    private FilteredCheckboxTree fPluginFilteredTree;
    protected CachedCheckboxTreeViewer fPluginTreeViewer;
    private NamedElement fWorkspacePlugins;
    private NamedElement fExternalPlugins;
    private IPluginModelBase[] fExternalModels;
    private IPluginModelBase[] fWorkspaceModels;
    protected int fNumExternalChecked;
    protected int fNumWorkspaceChecked;
    private Button fAutoIncludeRequirementsButton;
    private boolean fAutoIncludeRequirementsButtonChanged;
    private Button fIncludeOptionalButton;
    protected Button fAddWorkspaceButton;
    private Button fAutoValidate;
    private Button fSelectAllButton;
    private Button fDeselectButton;
    private Button fWorkingSetButton;
    private Button fAddRequiredButton;
    private Button fDefaultsButton;
    private Button fFilterButton;
    protected ILaunchConfiguration fLaunchConfig;
    private Listener fListener = new Listener();
    private Label fCounter;
    private Button fValidateButton;
    private HashMap<Object, String> levelColumnCache = new HashMap();
    private HashMap<Object, String> autoColumnCache = new HashMap();
    private TreeEditor levelColumnEditor = null;
    private TreeEditor autoColumnEditor = null;
    private boolean fIsDisposed = false;
    private PluginStatusDialog fDialog;

    public AbstractPluginBlock(AbstractLauncherTab tab) {
        this.fTab = tab;
        PDEPlugin.getDefault().getLabelProvider().connect(this);
    }

    protected IPluginModelBase[] getExternalModels() {
        if (this.fExternalModels == null) {
            this.fExternalModels = this.collectModelsToDisplay(PluginRegistry.getExternalModels());
        }
        return this.fExternalModels;
    }

    protected IPluginModelBase[] getWorkspaceModels() {
        if (this.fWorkspaceModels == null) {
            this.fWorkspaceModels = this.collectModelsToDisplay(PluginRegistry.getWorkspaceModels());
        }
        return this.fWorkspaceModels;
    }

    private IPluginModelBase[] collectModelsToDisplay(IPluginModelBase[] models) {
        SourcePluginFilter sourcePluginFilter = new SourcePluginFilter();
        return (IPluginModelBase[])Arrays.stream(models).filter(model -> model.getBundleDescription() != null).filter(sourcePluginFilter).toArray(IPluginModelBase[]::new);
    }

    protected void updateCounter() {
        if (this.fCounter != null) {
            int checked = this.fNumExternalChecked + this.fNumWorkspaceChecked;
            int total = this.getWorkspaceModels().length + this.getExternalModels().length;
            this.fCounter.setText(NLS.bind((String)PDEUIMessages.AbstractPluginBlock_counter, (Object)checked, (Object)total));
        }
    }

    public void createControl(Composite parent, int span, int indent) {
        this.createPluginViewer(parent, span - 1, indent);
        this.createButtonContainer(parent);
        if (this.fTab instanceof PluginsTab) {
            this.fAutoIncludeRequirementsButton = this.createButton(parent, span, indent, PDEUIMessages.AdvancedLauncherTab_autoIncludeRequirements_plugins);
        } else if (this.fTab instanceof BundlesTab) {
            this.fAutoIncludeRequirementsButton = this.createButton(parent, span, indent, PDEUIMessages.AdvancedLauncherTab_autoIncludeRequirements_bundles);
        }
        this.fAutoIncludeRequirementsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.fAutoIncludeRequirementsButtonChanged = true;
        }));
        this.fIncludeOptionalButton = this.fTab instanceof PluginsTab ? this.createButton(parent, span, indent, PDEUIMessages.AdvancedLauncherTab_includeOptional_plugins) : (this.fTab instanceof BundlesTab ? this.createButton(parent, span, indent, PDEUIMessages.AdvancedLauncherTab_includeOptional_bundles) : this.createButton(parent, span, indent, NLS.bind((String)PDEUIMessages.AdvancedLauncherTab_includeOptional, (Object)this.fTab.getName().toLowerCase(Locale.ENGLISH))));
        this.fAddWorkspaceButton = this.fTab instanceof PluginsTab ? this.createButton(parent, span, indent, PDEUIMessages.AdvancedLauncherTab_addNew_plugins) : (this.fTab instanceof BundlesTab ? this.createButton(parent, span, indent, PDEUIMessages.AdvancedLauncherTab_addNew_bundles) : this.createButton(parent, span, indent, NLS.bind((String)PDEUIMessages.AdvancedLauncherTab_addNew, (Object)this.fTab.getName().toLowerCase(Locale.ENGLISH))));
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        Label label = new Label(parent, 258);
        label.setLayoutData((Object)gd);
        this.fAutoValidate = this.fTab instanceof PluginsTab ? this.createButton(parent, span - 1, indent, PDEUIMessages.PluginsTabToolBar_auto_validate_plugins) : (this.fTab instanceof BundlesTab ? this.createButton(parent, span - 1, indent, PDEUIMessages.PluginsTabToolBar_auto_validate_bundles) : this.createButton(parent, span - 1, indent, NLS.bind((String)PDEUIMessages.PluginsTabToolBar_auto_validate, (Object)this.fTab.getName().replace("&", "").toLowerCase(Locale.ENGLISH))));
        this.fValidateButton = new Button(parent, 8);
        this.fValidateButton.setLayoutData((Object)new GridData(128));
        if (this.fTab instanceof PluginsTab) {
            this.fValidateButton.setText(PDEUIMessages.PluginsTabToolBar_validate_plugins);
        } else if (this.fTab instanceof BundlesTab) {
            this.fValidateButton.setText(PDEUIMessages.PluginsTabToolBar_validate_bundles);
        } else {
            this.fValidateButton.setText(NLS.bind((String)PDEUIMessages.PluginsTabToolBar_validate, (Object)this.fTab.getName().replace("&", "")));
        }
        SWTUtil.setButtonDimensionHint(this.fValidateButton);
        this.fValidateButton.addSelectionListener((SelectionListener)this.fListener);
    }

    private Button createButton(Composite parent, int span, int indent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.horizontalIndent = indent;
        button.setLayoutData((Object)gd);
        button.addSelectionListener((SelectionListener)this.fListener);
        button.setFont(parent.getFont());
        return button;
    }

    protected ILabelProvider getLabelProvider() {
        return new OSGiLabelProvider();
    }

    protected void createPluginViewer(Composite composite, int span, int indent) {
        PatternFilter patternFilter = new PatternFilter();
        patternFilter.setIncludeLeadingWildcard(true);
        this.fPluginFilteredTree = new FilteredCheckboxTree(composite, null, this.getTreeViewerStyle(), patternFilter);
        this.fPluginTreeViewer = this.fPluginFilteredTree.getCheckboxTreeViewer();
        this.fPluginTreeViewer.addCheckStateListener(event -> {
            TreeItem[] items;
            if (!event.getChecked()) {
                return;
            }
            TreeItem[] treeItemArray = items = this.fPluginTreeViewer.getTree().getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (event.getElement() == item.getData()) {
                    this.fFilterButton.setSelection(false);
                    this.handleFilterButton();
                    return;
                }
                ++n2;
            }
        });
        this.fPluginTreeViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.fPluginTreeViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fPluginTreeViewer.setAutoExpandLevel(2);
        this.fPluginTreeViewer.addCheckStateListener(event -> {
            Object element = event.getElement();
            if (element instanceof IPluginModelBase) {
                this.handleCheckStateChanged(event);
            } else {
                this.countSelectedModels();
            }
            this.fTab.updateLaunchConfigurationDialog();
        });
        this.fPluginTreeViewer.setComparator(new ListUtil.PluginComparator(){

            public int category(Object obj) {
                if (obj == AbstractPluginBlock.this.fWorkspacePlugins) {
                    return -1;
                }
                return 0;
            }
        });
        GridData gd = new GridData(1808);
        gd.horizontalSpan = span;
        gd.horizontalIndent = indent;
        this.fPluginFilteredTree.setLayoutData(gd);
        Image siteImage = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_SITE_OBJ);
        this.fWorkspacePlugins = new NamedElement(PDEUIMessages.AdvancedLauncherTab_workspacePlugins, siteImage);
        this.fExternalPlugins = new NamedElement(PDEUIMessages.PluginsTab_target, siteImage);
        this.fPluginTreeViewer.addFilter(new Filter());
        Tree tree = this.fPluginTreeViewer.getTree();
        TreeColumn column1 = new TreeColumn(tree, 16384);
        column1.setText(this.fTab.getName());
        column1.setWidth(400);
        TreeColumn column2 = new TreeColumn(tree, 0x1000000);
        column2.setText(PDEUIMessages.EquinoxPluginBlock_levelColumn);
        column2.setWidth(80);
        TreeColumn column3 = new TreeColumn(tree, 0x1000000);
        column3.setText(PDEUIMessages.EquinoxPluginBlock_autoColumn);
        column3.setWidth(80);
        tree.setHeaderVisible(true);
        tree.setFont(composite.getFont());
        this.fPluginFilteredTree.getFilterControl().setFont(composite.getFont());
        this.createEditors();
    }

    private void createEditors() {
        Tree tree = this.fPluginTreeViewer.getTree();
        this.levelColumnEditor = new TreeEditor(tree);
        this.levelColumnEditor.horizontalAlignment = 0x1000000;
        this.levelColumnEditor.minimumWidth = 60;
        if (Util.isMac()) {
            this.levelColumnEditor.minimumHeight = 27;
        }
        this.autoColumnEditor = new TreeEditor(tree);
        this.autoColumnEditor.horizontalAlignment = 0x1000000;
        this.autoColumnEditor.grabHorizontal = true;
        this.autoColumnEditor.minimumWidth = 60;
        tree.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TreeItem item;
            Control oldEditor = this.levelColumnEditor.getEditor();
            if (oldEditor != null && !oldEditor.isDisposed()) {
                oldEditor.dispose();
            }
            if ((oldEditor = this.autoColumnEditor.getEditor()) != null && !oldEditor.isDisposed()) {
                oldEditor.dispose();
            }
            if ((item = (TreeItem)e.item) != null && !this.isEditable(item)) {
                return;
            }
            if (item != null && !this.isFragment(item)) {
                Spinner spinner = new Spinner((Composite)tree, 2048);
                spinner.setMinimum(0);
                String level = item.getText(1);
                int defaultLevel = level.length() == 0 || "default".equals(level) ? 0 : Integer.parseInt(level);
                spinner.setSelection(defaultLevel);
                spinner.addModifyListener(e1 -> {
                    if (item.getChecked()) {
                        int selection = spinner.getSelection();
                        item.setText(1, selection == 0 ? "default" : Integer.toString(selection));
                        this.levelColumnCache.put(item.getData(), item.getText(1));
                        this.fTab.updateLaunchConfigurationDialog();
                    }
                });
                if (Util.isGtk()) {
                    Point spinnerSize = spinner.computeSize(-1, -1);
                    this.levelColumnEditor.minimumWidth = spinnerSize.x;
                    TreeColumn levelColumn = tree.getColumn(1);
                    levelColumn.setWidth(spinnerSize.x);
                }
                this.levelColumnEditor.setEditor((Control)spinner, item, 1);
                CCombo combo = new CCombo((Composite)tree, 2056);
                combo.setItems(new String[]{"default", Boolean.toString(true), Boolean.toString(false)});
                combo.setText(item.getText(2));
                combo.pack();
                combo.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
                    if (item.getChecked()) {
                        item.setText(2, combo.getText());
                        this.autoColumnCache.put(item.getData(), item.getText(2));
                        this.fTab.updateLaunchConfigurationDialog();
                    }
                }));
                this.autoColumnEditor.setEditor((Control)combo, item, 2);
            }
        }));
    }

    private boolean isEditable(TreeItem item) {
        Object obj = item.getData();
        if (obj instanceof IPluginModelBase) {
            IPluginModelBase model = (IPluginModelBase)obj;
            String systemBundleId = PDECore.getDefault().getModelManager().getSystemBundleId();
            if (!systemBundleId.equals(model.getPluginBase().getId())) {
                return this.fPluginTreeViewer.getChecked(model);
            }
        }
        return false;
    }

    private boolean isFragment(TreeItem item) {
        Object obj = item.getData();
        if (obj instanceof IPluginModelBase) {
            return ((IPluginModelBase)obj).isFragmentModel();
        }
        return false;
    }

    private void createButtonContainer(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, 1, 1, 1040);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1040));
        this.fSelectAllButton = this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_selectAll, 8);
        this.fDeselectButton = this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_deselectAll, 8);
        this.fWorkingSetButton = this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_workingSet, 8);
        this.fAddRequiredButton = this.fTab instanceof PluginsTab ? this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_subset_plugins, 8) : (this.fTab instanceof BundlesTab ? this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_subset_bundles, 8) : this.createButton(composite, NLS.bind((String)PDEUIMessages.AdvancedLauncherTab_subset, (Object)this.fTab.getName()), 8));
        this.fDefaultsButton = this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_defaults, 8);
        this.fFilterButton = this.createButton(composite, PDEUIMessages.AdvancedLauncherTab_selectedBundles, 32);
        GridData filterButtonGridData = new GridData(1816);
        this.fFilterButton.setLayoutData((Object)filterButtonGridData);
        this.fCounter = SWTFactory.createLabel(composite, "", 1);
        this.fCounter.setLayoutData((Object)new GridData(776));
        this.updateCounter();
    }

    protected int getTreeViewerStyle() {
        return 67584;
    }

    private Button createButton(Composite composite, String text, int style) {
        Button button = new Button(composite, style);
        button.setText(text);
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)this.fListener);
        return button;
    }

    protected void handleCheckStateChanged(CheckStateChangedEvent event) {
        this.countSelectedModels();
        this.resetText((IPluginModelBase)event.getElement());
    }

    protected void setText(IPluginModelBase model, String value) {
        Widget widget = this.fPluginTreeViewer.testFindItem(model);
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            int index = value == null ? -1 : value.indexOf(58);
            String levelValue = index == -1 ? "" : value.substring(0, index);
            String autoValue = null;
            String modelName = model.getBundleDescription().getSymbolicName();
            item.setText(1, levelValue);
            if (model.isFragmentModel()) {
                autoValue = "false";
                item.setText(2, autoValue);
            } else if ("org.eclipse.core.runtime".equals(modelName) || "org.eclipse.equinox.ds".equals(modelName)) {
                autoValue = "true";
                item.setText(2, autoValue);
            } else {
                autoValue = index == -1 ? "" : value.substring(index + 1);
                item.setText(2, autoValue);
            }
            this.levelColumnCache.put(model, levelValue);
            this.autoColumnCache.put(model, autoValue);
        }
    }

    protected void resetText(IPluginModelBase model) {
        String levelText = "";
        String autoText = "";
        Widget widget = this.fPluginTreeViewer.testFindItem(model);
        if (this.fPluginTreeViewer.getChecked(model)) {
            levelText = this.levelColumnCache.get(model);
            levelText = levelText == null || levelText.length() == 0 ? "default" : levelText;
            autoText = this.autoColumnCache.get(model);
            autoText = autoText == null || autoText.length() == 0 ? "default" : autoText;
            String systemValue = BundleLauncherHelper.resolveSystemRunLevelText((BundleDescription)model.getBundleDescription());
            levelText = systemValue != null ? systemValue : levelText;
            systemValue = BundleLauncherHelper.resolveSystemAutoText((BundleDescription)model.getBundleDescription());
            autoText = systemValue != null ? systemValue : autoText;
            this.levelColumnCache.put(model, levelText);
            this.autoColumnCache.put(model, autoText);
        }
        if (widget instanceof TreeItem) {
            ((TreeItem)widget).setText(1, levelText);
        }
        if (widget instanceof TreeItem) {
            ((TreeItem)widget).setText(2, autoText);
        }
    }

    protected void handleGroupStateChanged(Object group, boolean checked) {
        NamedElement namedElement;
        TreeItem item;
        if (!this.fPluginFilteredTree.getPatternFilter().select((Viewer)this.fPluginTreeViewer, null, group)) {
            return;
        }
        this.fPluginTreeViewer.setChecked(group, checked);
        if (group instanceof NamedElement && (item = (TreeItem)this.fPluginTreeViewer.testFindItem(namedElement = (NamedElement)group)) != null) {
            TreeItem[] children = item.getItems();
            if (children == null) {
                return;
            }
            TreeItem[] treeItemArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem childItem = treeItemArray[n2];
                Object child = childItem.getData();
                if (child instanceof IPluginModelBase) {
                    this.resetText((IPluginModelBase)child);
                }
                ++n2;
            }
        }
    }

    protected void toggleGroups(boolean select) {
        this.handleGroupStateChanged(this.fWorkspacePlugins, select);
        this.handleGroupStateChanged(this.fExternalPlugins, select);
        this.countSelectedModels();
    }

    protected void handleFilterButton() {
        this.fPluginTreeViewer.refresh();
        this.fPluginTreeViewer.expandAll();
    }

    protected void setChecked(IPluginModelBase model, boolean checked) {
        this.fPluginTreeViewer.setChecked(model, checked);
        this.resetText(model);
    }

    public void initializeFrom(ILaunchConfiguration config, boolean enableTable) throws CoreException {
        this.fLaunchConfig = config;
        this.initializeButtonsFrom(config);
        this.levelColumnCache = new HashMap();
        this.autoColumnCache = new HashMap();
        this.fPluginFilteredTree.getPatternFilter().setPattern(null);
        if (!enableTable) {
            this.fPluginTreeViewer.setInput(null);
        } else if (this.fPluginTreeViewer.getInput() == null) {
            this.fPluginTreeViewer.setUseHashlookup(true);
            this.fPluginTreeViewer.setInput(PDEPlugin.getDefault());
            this.fPluginTreeViewer.reveal(this.fWorkspacePlugins);
        }
    }

    protected void initializeButtonsFrom(ILaunchConfiguration config) throws CoreException {
        boolean autoIncludeRequired = config.getAttribute("automaticIncludeRequirements", false);
        this.fAutoIncludeRequirementsButton.setSelection(autoIncludeRequired);
        this.fIncludeOptionalButton.setSelection(config.getAttribute("includeOptional", true));
        this.fAddWorkspaceButton.setSelection(config.getAttribute("automaticAdd", true));
        this.fAutoValidate.setSelection(config.getAttribute("automaticValidate", true));
        this.fFilterButton.setSelection(config.getAttribute("show_selected_only", false));
    }

    protected void addRequiredPlugins() {
        DependencyManager.Options[] optionsArray;
        Object[] checked = this.fPluginTreeViewer.getCheckedLeafElements();
        List toCheck = Arrays.stream(checked).filter(IPluginModelBase.class::isInstance).map(IPluginModelBase.class::cast).collect(Collectors.toList());
        if (this.fIncludeOptionalButton.getSelection()) {
            DependencyManager.Options[] optionsArray2 = new DependencyManager.Options[2];
            optionsArray2[0] = DependencyManager.Options.INCLUDE_NON_TEST_FRAGMENTS;
            optionsArray = optionsArray2;
            optionsArray2[1] = DependencyManager.Options.INCLUDE_OPTIONAL_DEPENDENCIES;
        } else {
            DependencyManager.Options[] optionsArray3 = new DependencyManager.Options[1];
            optionsArray = optionsArray3;
            optionsArray3[0] = DependencyManager.Options.INCLUDE_NON_TEST_FRAGMENTS;
        }
        DependencyManager.Options[] options = optionsArray;
        Set additionalBundles = DependencyManager.getDependencies(toCheck, (DependencyManager.Options[])options);
        additionalBundles.stream().map(PluginRegistry::findModel).filter(Objects::nonNull).forEach(toCheck::add);
        checked = toCheck.toArray();
        this.setCheckedElements(checked);
        this.countSelectedModels();
    }

    protected IPluginModelBase findPlugin(String id) {
        ModelEntry entry = PluginRegistry.findEntry((String)id);
        if (entry != null) {
            IPluginModelBase pluginModel;
            IPluginModelBase[] models;
            IPluginModelBase model = entry.getModel();
            if (this.fPluginTreeViewer.getChecked(model)) {
                return model;
            }
            IPluginModelBase[] iPluginModelBaseArray = models = entry.getWorkspaceModels();
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                pluginModel = iPluginModelBaseArray[n2];
                if (this.fPluginTreeViewer.getChecked(pluginModel)) {
                    return pluginModel;
                }
                ++n2;
            }
            iPluginModelBaseArray = models = entry.getExternalModels();
            n = models.length;
            n2 = 0;
            while (n2 < n) {
                pluginModel = iPluginModelBaseArray[n2];
                if (this.fPluginTreeViewer.getChecked(pluginModel)) {
                    return pluginModel;
                }
                ++n2;
            }
            return null;
        }
        return null;
    }

    protected void setCheckedElements(Object[] checked) {
        this.fPluginTreeViewer.setCheckedElements(checked);
        this.updateGroup(this.fWorkspacePlugins);
        this.updateGroup(this.fExternalPlugins);
    }

    private void updateGroup(Object group) {
        Widget item = this.fPluginTreeViewer.testFindItem(group);
        if (item instanceof TreeItem) {
            TreeItem[] items;
            TreeItem[] treeItemArray = items = ((TreeItem)item).getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object model;
                TreeItem childItem = treeItemArray[n2];
                if (childItem.getChecked() == (childItem.getText(1).length() == 0) && (model = childItem.getData()) instanceof IPluginModelBase) {
                    this.resetText((IPluginModelBase)model);
                }
                ++n2;
            }
        }
    }

    private void countSelectedModels() {
        this.fNumWorkspaceChecked = this.countChecked(this.getWorkspaceModels());
        this.fNumExternalChecked = this.countChecked(this.getExternalModels());
    }

    private int countChecked(Object[] elements) {
        return (int)Arrays.stream(elements).filter(this.fPluginTreeViewer::isCheckedLeafElement).count();
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.fAutoIncludeRequirementsButtonChanged) {
            boolean includeRequirements = this.fAutoIncludeRequirementsButton.getSelection();
            config.setAttribute("automaticIncludeRequirements", includeRequirements);
            this.fAutoIncludeRequirementsButtonChanged = false;
        }
        config.setAttribute("includeOptional", this.fIncludeOptionalButton.getSelection());
        config.setAttribute("automaticAdd", this.fAddWorkspaceButton.getSelection());
        config.setAttribute("automaticValidate", this.fAutoValidate.getSelection());
        config.setAttribute("show_selected_only", this.fFilterButton.getSelection());
        this.savePluginState(config);
        this.updateCounter();
    }

    protected abstract void savePluginState(ILaunchConfigurationWorkingCopy var1);

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("includeOptional", true);
        config.setAttribute("automaticAdd", true);
        config.setAttribute("automaticValidate", true);
        config.setAttribute("show_selected_only", false);
    }

    public void enableViewer(boolean enable) {
        this.fPluginFilteredTree.setEnabled(enable);
        this.fAddRequiredButton.setEnabled(enable);
        this.fDefaultsButton.setEnabled(enable);
        this.fWorkingSetButton.setEnabled(enable);
        this.fSelectAllButton.setEnabled(enable);
        this.fDeselectButton.setEnabled(enable);
        this.fAutoIncludeRequirementsButton.setEnabled(enable);
        this.fIncludeOptionalButton.setEnabled(enable);
        this.fAddWorkspaceButton.setEnabled(enable);
        this.fCounter.setEnabled(enable);
        this.fFilterButton.setEnabled(enable);
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        this.fIsDisposed = true;
    }

    protected boolean isEnabled() {
        return this.fPluginTreeViewer.getTree().isEnabled();
    }

    protected void handleRestoreDefaults() {
        Object[] selected;
        IPluginModelBase[] externalModels;
        IPluginModelBase model;
        TreeSet<String> wtable = new TreeSet<String>();
        ArrayList<IPluginModelBase> checkedModels = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < this.getWorkspaceModels().length) {
            model = this.getWorkspaceModels()[i];
            checkedModels.add(model);
            String id = model.getPluginBase().getId();
            if (id != null) {
                wtable.add(model.getPluginBase().getId());
            }
            ++i;
        }
        IPluginModelBase[] iPluginModelBaseArray = externalModels = this.getExternalModels();
        int n = externalModels.length;
        int id = 0;
        while (id < n) {
            model = iPluginModelBaseArray[id];
            boolean masked = wtable.contains(model.getPluginBase().getId());
            if (!masked && model.isEnabled()) {
                checkedModels.add(model);
            }
            ++id;
        }
        this.fPluginTreeViewer.setCheckedElements(checkedModels.toArray());
        this.countSelectedModels();
        Object[] objectArray = selected = this.fPluginTreeViewer.getCheckedElements();
        int n2 = selected.length;
        n = 0;
        while (n < n2) {
            Object selectedElement = objectArray[n];
            if (selectedElement instanceof IPluginModelBase) {
                this.resetText((IPluginModelBase)selectedElement);
            }
            ++n;
        }
    }

    protected Shell getShell() {
        try {
            Control c = this.fTab.getControl();
            if (!c.isDisposed()) {
                return c.getShell();
            }
        }
        catch (SWTException sWTException) {}
        return PDEPlugin.getActiveWorkbenchShell();
    }

    public void handleValidate() {
        try {
            LaunchValidationOperation fOperation = this.createValidationOperation();
            fOperation.run((IProgressMonitor)new NullProgressMonitor());
            if (this.fDialog == null) {
                if (fOperation.hasErrors()) {
                    this.fDialog = new PluginStatusDialog(this.getShell(), 2160);
                    this.fDialog.setInput(fOperation.getInput());
                    this.fDialog.open();
                    this.fDialog = null;
                } else if (fOperation.isEmpty()) {
                    if (this.fTab instanceof PluginsTab) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)PDEUIMessages.AbstractLauncherToolbar_noSelection_plugins);
                    } else if (this.fTab instanceof BundlesTab) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)PDEUIMessages.AbstractLauncherToolbar_noSelection_bundles);
                    } else {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)NLS.bind((String)PDEUIMessages.AbstractLauncherToolbar_noSelection, (Object)this.fTab.getName().toLowerCase(Locale.ENGLISH)));
                    }
                } else {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)PDEUIMessages.AbstractLauncherToolbar_noProblems);
                }
            } else if (fOperation.getInput().size() > 0) {
                this.fDialog.refresh(fOperation.getInput());
            } else {
                HashMap<String, IStatus> input = new HashMap<String, IStatus>(1);
                input.put(PDEUIMessages.AbstractLauncherToolbar_noProblems, Status.OK_STATUS);
                this.fDialog.refresh(input);
            }
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
    }

    protected void setVisible(boolean visible) {
        if (!visible && this.fDialog != null) {
            this.fDialog.close();
            this.fDialog = null;
        }
    }

    protected abstract LaunchValidationOperation createValidationOperation() throws CoreException;

    protected void refreshTreeView(CheckboxTreeViewer treeView) {
        if (treeView.getTree().getItemCount() > 0) {
            treeView.getTree().setSelection(treeView.getTree().getItem(0));
        } else {
            treeView.setSelection((ISelection)new StructuredSelection((Object)StructuredSelection.EMPTY));
        }
        if (this.levelColumnEditor != null && this.levelColumnEditor.getEditor() != null && !this.levelColumnEditor.getEditor().isDisposed()) {
            this.levelColumnEditor.getEditor().dispose();
        }
        if (this.autoColumnEditor != null && this.autoColumnEditor.getEditor() != null && !this.autoColumnEditor.getEditor().isDisposed()) {
            this.autoColumnEditor.getEditor().dispose();
        }
    }

    protected void resetGroup(NamedElement group) {
        Widget widget = this.fPluginTreeViewer.testFindItem(group);
        if (widget instanceof TreeItem) {
            TreeItem[] items = ((TreeItem)widget).getItems();
            int i = 0;
            while (i < items.length) {
                Object model;
                if (!items[i].getChecked() && (model = items[i].getData()) instanceof IPluginModelBase) {
                    this.resetText((IPluginModelBase)model);
                }
                ++i;
            }
        }
    }

    protected final void initializePluginsState(Map<IPluginModelBase, String> selectedPlugins) {
        for (Map.Entry<IPluginModelBase, String> entry : selectedPlugins.entrySet()) {
            IPluginModelBase model = entry.getKey();
            this.setText(model, entry.getValue());
        }
        this.fPluginTreeViewer.setCheckedElements(selectedPlugins.keySet().toArray());
        this.countSelectedModels();
        this.resetGroup(this.fWorkspacePlugins);
        this.resetGroup(this.fExternalPlugins);
        if (this.fFilterButton.getSelection()) {
            this.handleFilterButton();
        }
        this.updateCounter();
    }

    class Filter
    extends ViewerFilter {
        Filter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (AbstractPluginBlock.this.fFilterButton.getSelection()) {
                if (parentElement == PDEPlugin.getDefault()) {
                    return true;
                }
                return AbstractPluginBlock.this.fPluginTreeViewer.isCheckedLeafElement(element);
            }
            return true;
        }
    }

    class Listener
    extends SelectionAdapter {
        Listener() {
        }

        private void filterAffectingControl(SelectionEvent e) {
            boolean resetFilterButton = false;
            Object source = e.getSource();
            if (AbstractPluginBlock.this.fFilterButton.getSelection()) {
                AbstractPluginBlock.this.fFilterButton.setSelection(false);
                AbstractPluginBlock.this.handleFilterButton();
                resetFilterButton = true;
            }
            if (source == AbstractPluginBlock.this.fSelectAllButton) {
                AbstractPluginBlock.this.toggleGroups(true);
            } else if (source == AbstractPluginBlock.this.fDeselectButton) {
                AbstractPluginBlock.this.toggleGroups(false);
            } else if (source == AbstractPluginBlock.this.fWorkingSetButton) {
                this.handleWorkingSets();
            } else if (source == AbstractPluginBlock.this.fAddRequiredButton) {
                AbstractPluginBlock.this.addRequiredPlugins();
            } else if (source == AbstractPluginBlock.this.fDefaultsButton) {
                AbstractPluginBlock.this.handleRestoreDefaults();
            }
            if (resetFilterButton) {
                AbstractPluginBlock.this.fFilterButton.setSelection(true);
                AbstractPluginBlock.this.handleFilterButton();
            }
        }

        private void handleWorkingSets() {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            IWorkingSetSelectionDialog dialog = workingSetManager.createWorkingSetSelectionDialog(AbstractPluginBlock.this.getShell(), true);
            if (dialog.open() == 0) {
                String[] ids = this.getPluginIDs(dialog.getSelection());
                ArrayList<IPluginModelBase> newCheckedModels = new ArrayList<IPluginModelBase>();
                ArrayList<Object> allCheckedModels = new ArrayList<Object>();
                String[] stringArray = ids;
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    IPluginModelBase model = PluginRegistry.findModel((String)id);
                    if (model != null && !AbstractPluginBlock.this.fPluginTreeViewer.getChecked(model)) {
                        newCheckedModels.add(model);
                    }
                    ++n2;
                }
                Object[] checkedElements = AbstractPluginBlock.this.fPluginTreeViewer.getCheckedElements();
                allCheckedModels.addAll(Arrays.asList(checkedElements));
                allCheckedModels.addAll(newCheckedModels);
                AbstractPluginBlock.this.fPluginTreeViewer.setCheckedElements(allCheckedModels.toArray());
                for (IPluginModelBase iPluginModelBase : newCheckedModels) {
                    AbstractPluginBlock.this.resetText(iPluginModelBase);
                }
                AbstractPluginBlock.this.countSelectedModels();
            }
        }

        private String[] getPluginIDs(IWorkingSet[] workingSets) {
            HashSet<String> set = new HashSet<String>();
            IWorkingSet[] iWorkingSetArray = workingSets;
            int n = workingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable[] elements;
                IWorkingSet workingSet = iWorkingSetArray[n2];
                IAdaptable[] iAdaptableArray = elements = workingSet.getElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAdaptable element2 = iAdaptableArray[n4];
                    IAdaptable element = element2;
                    if (element instanceof PersistablePluginObject) {
                        set.add(((PersistablePluginObject)element).getPluginID());
                    } else {
                        IPluginModelBase model;
                        if (element instanceof IJavaProject) {
                            element = ((IJavaProject)element).getProject();
                        }
                        if (element instanceof IProject && (model = PluginRegistry.findModel((IProject)((IProject)element))) != null) {
                            set.add(model.getPluginBase().getId());
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            return set.toArray(new String[set.size()]);
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AbstractPluginBlock.this.fFilterButton) {
                AbstractPluginBlock.this.handleFilterButton();
            } else if (source == AbstractPluginBlock.this.fSelectAllButton || source == AbstractPluginBlock.this.fDeselectButton || source == AbstractPluginBlock.this.fWorkingSetButton || source == AbstractPluginBlock.this.fAddRequiredButton || source == AbstractPluginBlock.this.fDefaultsButton) {
                this.filterAffectingControl(e);
            } else if (source == AbstractPluginBlock.this.fValidateButton) {
                AbstractPluginBlock.this.handleValidate();
            }
            if (!AbstractPluginBlock.this.fIsDisposed) {
                AbstractPluginBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        }
    }

    class OSGiLabelProvider
    extends PDELabelProvider {
        OSGiLabelProvider() {
        }

        @Override
        public Image getColumnImage(Object obj, int index) {
            return index == 0 ? super.getColumnImage(obj, index) : null;
        }

        @Override
        public String getColumnText(Object obj, int index) {
            boolean isChecked = AbstractPluginBlock.this.fPluginTreeViewer.getChecked(obj);
            switch (index) {
                case 0: {
                    return super.getColumnText(obj, index);
                }
                case 1: {
                    if (isChecked && AbstractPluginBlock.this.levelColumnCache != null && AbstractPluginBlock.this.levelColumnCache.containsKey(obj)) {
                        return AbstractPluginBlock.this.levelColumnCache.get(obj);
                    }
                    return "";
                }
                case 2: {
                    if (isChecked && AbstractPluginBlock.this.autoColumnCache != null && AbstractPluginBlock.this.autoColumnCache.containsKey(obj)) {
                        return AbstractPluginBlock.this.autoColumnCache.get(obj);
                    }
                    return "";
                }
            }
            return "";
        }
    }

    class PluginContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public boolean hasChildren(Object parent) {
            return !(parent instanceof IPluginModelBase);
        }

        public Object[] getChildren(Object parent) {
            if (parent == AbstractPluginBlock.this.fExternalPlugins) {
                return AbstractPluginBlock.this.getExternalModels();
            }
            if (parent == AbstractPluginBlock.this.fWorkspacePlugins) {
                return AbstractPluginBlock.this.getWorkspaceModels();
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            if (child instanceof IPluginModelBase) {
                IResource resource = ((IPluginModelBase)child).getUnderlyingResource();
                return resource == null ? AbstractPluginBlock.this.fExternalPlugins : AbstractPluginBlock.this.fWorkspacePlugins;
            }
            return null;
        }

        public Object[] getElements(Object input) {
            ArrayList<NamedElement> list = new ArrayList<NamedElement>();
            if (AbstractPluginBlock.this.getWorkspaceModels().length > 0) {
                list.add(AbstractPluginBlock.this.fWorkspacePlugins);
            }
            if (AbstractPluginBlock.this.getExternalModels().length > 0) {
                list.add(AbstractPluginBlock.this.fExternalPlugins);
            }
            return list.toArray();
        }
    }

    class PluginModelNameBuffer {
        private Set<String> nameSet = new HashSet<String>();

        PluginModelNameBuffer() {
        }

        void add(IPluginModelBase model) {
            this.nameSet.add(this.getPluginName(model));
        }

        private String getPluginName(IPluginModelBase model) {
            String startLevel = null;
            String autoStart = null;
            if (AbstractPluginBlock.this.fPluginTreeViewer.isCheckedLeafElement(model)) {
                startLevel = AbstractPluginBlock.this.levelColumnCache.get(model) != null ? AbstractPluginBlock.this.levelColumnCache.get(model) : null;
                autoStart = AbstractPluginBlock.this.autoColumnCache.get(model) != null ? AbstractPluginBlock.this.autoColumnCache.get(model) : null;
            }
            return BundleLauncherHelper.formatBundleEntry((IPluginModelBase)model, startLevel, autoStart);
        }

        public Set<String> getNameSet() {
            return this.nameSet;
        }

        public String toString() {
            return String.join((CharSequence)",", this.nameSet);
        }
    }
}

