/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.internal.common.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.nattable.common.helper.TableViewPrototype;
import org.eclipse.papyrus.infra.nattable.common.modelresource.PapyrusNattableModel;
import org.eclipse.papyrus.infra.nattable.common.reconciler.TableVersioningUtils;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;

public class CreateAndOpenTableEditorCommand
extends RecordingCommand {
    private Collection<?> result;
    private final EObject context;
    private final EObject owner;
    private final TableConfiguration configuration;
    private final String name;
    private final String description;
    private final IPageManager pageManager;
    private final PapyrusNattableModel papyrusNattableModel;
    private final TableViewPrototype tableViewPrototype;

    public CreateAndOpenTableEditorCommand(TransactionalEditingDomain domain, PapyrusNattableModel papyrusNattableModel, TableViewPrototype tableViewPrototype, TableConfiguration configuration, EObject context, String name, IPageManager pageManager) {
        this(domain, papyrusNattableModel, tableViewPrototype, configuration, context, name, null, null, pageManager);
    }

    public CreateAndOpenTableEditorCommand(TransactionalEditingDomain domain, PapyrusNattableModel papyrusNattableModel, TableViewPrototype tableViewPrototype, TableConfiguration configuration, EObject context, String name, String description, IPageManager pageManager) {
        this(domain, papyrusNattableModel, tableViewPrototype, configuration, context, name, null, description, pageManager);
    }

    public CreateAndOpenTableEditorCommand(TransactionalEditingDomain domain, PapyrusNattableModel papyrusNattableModel, TableViewPrototype tableViewPrototype, TableConfiguration configuration, EObject context, String name, EObject owner, IPageManager pageManager) {
        this(domain, papyrusNattableModel, tableViewPrototype, configuration, context, name, owner, null, pageManager);
    }

    public CreateAndOpenTableEditorCommand(TransactionalEditingDomain domain, PapyrusNattableModel papyrusNattableModel, TableViewPrototype tableViewPrototype, TableConfiguration configuration, EObject context, String name, EObject owner, String description, IPageManager pageManager) {
        super(domain, "Create a new table editor");
        Assert.isNotNull((Object)((Object)tableViewPrototype));
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)configuration);
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)((Object)papyrusNattableModel));
        this.context = context;
        this.owner = owner;
        this.configuration = configuration;
        this.papyrusNattableModel = papyrusNattableModel;
        this.tableViewPrototype = tableViewPrototype;
        this.name = name;
        this.description = description;
        this.pageManager = pageManager;
    }

    protected void doExecute() {
        Table table = TableHelper.createTable((TableConfiguration)this.configuration, null, (String)this.name, (String)this.description);
        TableVersioningUtils.stampCurrentVersion(table);
        table.setContext(this.context);
        this.papyrusNattableModel.addPapyrusTable(table);
        if (this.owner == null) {
            table.setOwner(this.context);
        } else {
            table.setOwner(this.owner);
        }
        table.setTableKindId(this.tableViewPrototype.getRepresentationKind().getId());
        if (this.pageManager != null) {
            this.pageManager.openPage((Object)table);
        }
        this.result = Collections.singleton(table);
    }

    public Collection<?> getResult() {
        if (this.result != null) {
            return this.result;
        }
        return super.getResult();
    }
}

