/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions.breakpoints;

import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.breakpoints.ToggleCDynamicPrintfTargetFactory;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpoints.IToggleBreakpointsTargetCExtension;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class CAddDynamicPrintfInteractiveRulerAction
extends Action
implements IUpdate {
    private IWorkbenchPart fPart;
    private IDocument fDocument;
    private IVerticalRulerInfo fRulerInfo;
    private IToggleBreakpointsTargetCExtension fDynamicPrintfBreakpointsTarget;

    public CAddDynamicPrintfInteractiveRulerAction(IWorkbenchPart part, IDocument document, IVerticalRulerInfo rulerInfo) {
        super(ActionMessages.getString("CAddDynamicPrintfInteractiveRulerAction_label"));
        this.fPart = part;
        this.fDocument = document;
        this.fRulerInfo = rulerInfo;
    }

    public void run() {
        IDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        int line = this.fRulerInfo.getLineOfLastMouseButtonActivity();
        if (line == -1) {
            return;
        }
        try {
            ITextSelection selection;
            if (this.fDynamicPrintfBreakpointsTarget != null && this.fDynamicPrintfBreakpointsTarget.canCreateLineBreakpointsInteractive(this.fPart, (ISelection)(selection = this.getTextSelection(document, line)))) {
                this.fDynamicPrintfBreakpointsTarget.createLineBreakpointsInteractive(this.fPart, (ISelection)selection);
            }
        }
        catch (BadLocationException e) {
            this.reportException((Exception)((Object)e));
        }
        catch (CoreException e) {
            this.reportException((Exception)((Object)e));
        }
    }

    private void reportException(Exception e) {
        Status status = new Status(4, "org.eclipse.cdt.debug.ui", "Error creating dynamic printf: ", (Throwable)e);
        ErrorDialog.openError((Shell)this.fPart.getSite().getShell(), (String)ActionMessages.getString("CAddBreakpointInteractiveRulerAction_error_title"), (String)ActionMessages.getString("CAddDynamicPrintfInteractiveRulerAction_error_message"), (IStatus)status);
        CDebugUIPlugin.log((IStatus)status);
    }

    public void dispose() {
        this.fDocument = null;
        this.fPart = null;
        this.fRulerInfo = null;
    }

    private IDocument getDocument() {
        ITextEditor editor;
        IDocumentProvider provider;
        if (this.fDocument != null) {
            return this.fDocument;
        }
        if (this.fPart instanceof ITextEditor && (provider = (editor = (ITextEditor)this.fPart).getDocumentProvider()) != null) {
            return provider.getDocument((Object)editor.getEditorInput());
        }
        IDocument doc = (IDocument)this.fPart.getAdapter(IDocument.class);
        if (doc != null) {
            return doc;
        }
        return null;
    }

    public void update() {
        int line;
        IDocument document = this.getDocument();
        if (document != null && (line = this.fRulerInfo.getLineOfLastMouseButtonActivity()) > -1) {
            try {
                ITextSelection selection = this.getTextSelection(document, line);
                if (this.fDynamicPrintfBreakpointsTarget == null) {
                    this.fDynamicPrintfBreakpointsTarget = this.fetchDynamicPrintfBreakpointsTarget(selection);
                }
                if (this.fDynamicPrintfBreakpointsTarget == null) {
                    this.setEnabled(false);
                    return;
                }
                if (this.fDynamicPrintfBreakpointsTarget.canCreateLineBreakpointsInteractive(this.fPart, (ISelection)selection)) {
                    this.setEnabled(true);
                    return;
                }
            }
            catch (BadLocationException e) {
                this.reportException((Exception)((Object)e));
            }
        }
        this.setEnabled(false);
    }

    private ITextSelection getTextSelection(IDocument document, int line) throws BadLocationException {
        ISelection selection;
        IRegion region = document.getLineInformation(line);
        TextSelection textSelection = new TextSelection(document, region.getOffset(), 0);
        ISelectionProvider provider = this.fPart.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection && ((ITextSelection)selection).getStartLine() <= line && ((ITextSelection)selection).getEndLine() >= line) {
            textSelection = (ITextSelection)selection;
        }
        return textSelection;
    }

    private IToggleBreakpointsTargetCExtension fetchDynamicPrintfBreakpointsTarget(ITextSelection selection) {
        if (this.fDynamicPrintfBreakpointsTarget == null) {
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.debug.ui", "toggleBreakpointsTargetFactories");
            IConfigurationElement[] elements = ep.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String id = elements[i].getAttribute("id");
                if (id != null && id.equals("org.eclipse.cdt.debug.ui.ToggleCDynamicPrintfTargetFactory")) {
                    try {
                        IToggleBreakpointsTarget target;
                        Object obj = elements[i].createExecutableExtension("class");
                        if (!(obj instanceof IToggleBreakpointsTargetFactory) || !((target = ((IToggleBreakpointsTargetFactory)obj).createToggleTarget(ToggleCDynamicPrintfTargetFactory.TOGGLE_C_DYNAMICPRINTF_TARGET_ID)) instanceof IToggleBreakpointsTargetCExtension)) break;
                        this.fDynamicPrintfBreakpointsTarget = (IToggleBreakpointsTargetCExtension)target;
                    }
                    catch (CoreException coreException) {}
                    break;
                }
                ++i;
            }
        }
        return this.fDynamicPrintfBreakpointsTarget;
    }
}

