/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTStructuredBindingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPStructuredBindingComposite;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecIncomplete;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecSimpleDeclaration;
import org.eclipse.jdt.annotation.NonNull;

public class CPPASTStructuredBindingDeclaration
extends CPPASTSimpleDeclaration
implements ICPPASTStructuredBindingDeclaration {
    private ICPPASTFunctionDeclarator.RefQualifier refQualifier;
    private IASTName[] names;
    private IASTInitializer initializer;
    private IASTImplicitName implicitInitializerName;

    public CPPASTStructuredBindingDeclaration() {
    }

    public CPPASTStructuredBindingDeclaration(IASTDeclSpecifier declSpecifier, ICPPASTFunctionDeclarator.RefQualifier refQualifier, IASTName[] names, IASTInitializer initializer) {
        super(declSpecifier);
        this.refQualifier = refQualifier;
        IASTName[] iASTNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName name = iASTNameArray[n2];
            this.addName(name);
            ++n2;
        }
        this.setInitializer(initializer);
    }

    @Override
    public ICPPASTFunctionDeclarator.RefQualifier getRefQualifier() {
        return this.refQualifier;
    }

    public void setRefQualifier(ICPPASTFunctionDeclarator.RefQualifier refQualifier) {
        this.assertNotFrozen();
        this.refQualifier = refQualifier;
    }

    @Override
    public IASTName[] getNames() {
        if (this.names == null) {
            return IASTName.EMPTY_NAME_ARRAY;
        }
        this.names = ArrayUtil.trim(this.names);
        return this.names;
    }

    @Override
    public IASTInitializer getInitializer() {
        return this.initializer;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        IASTDeclSpecifier declSpecifier;
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if ((declSpecifier = this.getDeclSpecifier()) != null && !declSpecifier.accept(action)) {
            return false;
        }
        IASTName[] iASTNameArray = this.getNames();
        int n = iASTNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName name = iASTNameArray[n2];
            if (!name.accept(action)) {
                return false;
            }
            ++n2;
        }
        if (this.initializer != null && !this.initializer.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitNames && !this.getImplicitNames()[0].accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    protected void addName(IASTName name) {
        this.assertNotFrozen();
        if (name != null) {
            this.names = ArrayUtil.append(IASTName.class, this.names, name);
            name.setParent(this);
            name.setPropertyInParent(IDENTIFIER);
        }
    }

    protected void setInitializer(IASTInitializer initializer) {
        this.assertNotFrozen();
        if (initializer != null) {
            this.initializer = initializer;
            initializer.setParent(this);
            initializer.setPropertyInParent(INITIALIZER);
        }
    }

    @Override
    public CPPASTStructuredBindingDeclaration copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTStructuredBindingDeclaration copy(IASTNode.CopyStyle style) {
        CPPASTStructuredBindingDeclaration copy = new CPPASTStructuredBindingDeclaration();
        return this.copy(copy, style);
    }

    @Override
    protected <T extends CPPASTStructuredBindingDeclaration> T copy(@NonNull T copy, IASTNode.CopyStyle style) {
        copy.setRefQualifier(this.refQualifier);
        if (this.initializer != null) {
            copy.setInitializer(this.initializer.copy(style));
        }
        IASTName[] iASTNameArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName name = iASTNameArray[n2];
            if (name == null) break;
            copy.addName(name.copy(style));
            ++n2;
        }
        return super.copy(copy, style);
    }

    @Override
    public ICPPExecution getExecution() {
        IASTName[] names = this.getNames();
        ICPPExecution[] nameExecutions = (ICPPExecution[])Arrays.stream(names).map(name -> {
            IBinding binding = name.resolveBinding();
            if (binding instanceof CPPVariable) {
                CPPVariable variable = (CPPVariable)binding;
                ICPPEvaluation initializerEval = variable.getInitializerEvaluation();
                return new ExecDeclarator((ICPPBinding)binding, initializerEval);
            }
            return ExecIncomplete.INSTANCE;
        }).toArray(ICPPExecution[]::new);
        return new ExecSimpleDeclaration(nameExecutions);
    }

    @Override
    public int getRoleForName(IASTName name) {
        return 2;
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitInitializerName == null) {
            ICPPEvaluation initializerEvaluation = CPPVariable.evaluationOfInitializer(this.initializer);
            if (initializerEvaluation == null) {
                initializerEvaluation = EvalFixed.INCOMPLETE;
            }
            CPPASTImplicitName implicitName = new CPPASTImplicitName(this);
            implicitName.setIsDefinition(true);
            if (this.initializer != null) {
                implicitName.setOffsetAndLength((ASTNode)((Object)this.initializer));
            }
            this.implicitInitializerName = implicitName;
            CPPStructuredBindingComposite implicitInitializerVariable = new CPPStructuredBindingComposite(this.implicitInitializerName, initializerEvaluation);
            this.implicitInitializerName.setBinding(implicitInitializerVariable);
        }
        return new IASTImplicitName[]{this.implicitInitializerName};
    }
}

