/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.callback;

import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.tcf.te.runtime.callback.AsyncCallbackHandler;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;

public class AsyncCallbackCollector
extends AsyncCallbackHandler {
    final ICallback callback;
    private boolean isFinished;
    private boolean initDone;
    private ICallbackInvocationDelegate delegate = null;

    public AsyncCallbackCollector() {
        this(null, null);
    }

    public AsyncCallbackCollector(ICallback callback, ICallbackInvocationDelegate delegate) {
        if (callback != null) {
            Assert.isNotNull((Object)delegate);
        }
        this.addCallback(callback);
        this.callback = callback;
        this.delegate = delegate;
        this.isFinished = false;
        this.initDone = false;
    }

    @Override
    public final synchronized void addCallback(ICallback callback) {
        Assert.isTrue((!this.isFinished() || this.getError() != null ? 1 : 0) != 0);
        super.addCallback(callback);
    }

    protected final synchronized void checkAndFireCallback() {
        if (!this.isEmpty() || this.isFinished()) {
            return;
        }
        this.isFinished = true;
        this.onCollectorFinished();
    }

    protected void onCollectorFinished() {
        if (this.callback != null) {
            Assert.isNotNull((Object)this.delegate);
            this.delegate.invoke(new Runnable(){

                @Override
                public void run() {
                    AsyncCallbackCollector.this.callback.done(this, StatusHelper.getStatus(AsyncCallbackCollector.this.getError()));
                }
            });
        }
    }

    @Override
    public final synchronized void removeCallback(ICallback callback) {
        super.removeCallback(callback);
        this.checkAndFireCallback();
    }

    public final boolean isFinished() {
        return this.isFinished;
    }

    public final synchronized void initDone() {
        Assert.isTrue((!this.initDone ? 1 : 0) != 0);
        if (this.callback != null) {
            this.removeCallback(this.callback);
        }
        this.initDone = true;
    }

    public final synchronized void handleError(String errMsg, Throwable cause) {
        Assert.isTrue((!this.isFinished() || this.getError() != null ? 1 : 0) != 0);
        Throwable error = cause;
        if (!(error instanceof OperationCanceledException)) {
            error = new ExecutionException(errMsg, error);
        }
        error.fillInStackTrace();
        this.handleError(error);
    }

    public final synchronized void handleError(Throwable error) {
        Assert.isNotNull((Object)error);
        Assert.isTrue((!this.isFinished() || this.getError() != null ? 1 : 0) != 0);
        if (!this.isFinished()) {
            this.setError(error);
            this.clear();
            this.checkAndFireCallback();
        }
        if (error instanceof Error && !(error instanceof AssertionError)) {
            throw (Error)error;
        }
    }

    public static interface ICallbackInvocationDelegate {
        public void invoke(Runnable var1);
    }

    public static class SimpleCollectorCallback
    extends Callback {
        private final AsyncCallbackCollector collector;

        public SimpleCollectorCallback(AsyncCallbackCollector collector) {
            Assert.isNotNull((Object)collector);
            this.collector = collector;
            this.collector.addCallback(this);
        }

        @Override
        protected void internalDone(Object caller, IStatus status) {
            if (status.getException() != null) {
                this.collector.handleError(status.getMessage(), status.getException());
            } else {
                this.collector.removeCallback(this);
            }
        }

        protected AsyncCallbackCollector getCollector() {
            return this.collector;
        }
    }
}

