/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.databinding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingObservable;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;
import org.eclipse.papyrus.uml.tools.databinding.AggregatedPapyrusObservableValue;
import org.eclipse.papyrus.uml.tools.databinding.MultiplicityObservableValue;
import org.eclipse.papyrus.uml.tools.helper.UMLDatabindingHelper;
import org.eclipse.uml2.uml.UMLPackage;

@Deprecated
public class ExtendedMultiplicityObservableValue
extends ReferenceCountedObservable.Value
implements AggregatedObservable {
    private static final int NUMBER_OBSERVABLE_VALUES = 3;
    private final List<IObservableValue> observableValues;
    private final ReferenceCountedObservable.Support refCount = new ReferenceCountedObservable.Support((IObservable)this);
    private final EditingDomain domain;

    public ExtendedMultiplicityObservableValue(EditingDomain domain) {
        this(null, domain);
    }

    public ExtendedMultiplicityObservableValue(EObject eObject, EditingDomain domain) {
        this.domain = domain;
        this.observableValues = new ArrayList<IObservableValue>(3);
        if (eObject != null) {
            this.observableValues.add((IObservableValue)new MultiplicityObservableValue(eObject, domain));
            EReference lowerValueFeature = UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue();
            EReference upperValueFeature = UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue();
            this.observableValues.add(UMLDatabindingHelper.getObservableValue(eObject, (EStructuralFeature)lowerValueFeature, domain));
            this.observableValues.add(UMLDatabindingHelper.getObservableValue(eObject, (EStructuralFeature)upperValueFeature, domain));
        }
    }

    public AggregatedObservable aggregate(IObservable observable) {
        Object value;
        if (observable instanceof IObservableValue && (value = ((IObservableValue)observable).getValue()) instanceof List && 3 == ((List)value).size() && this.isAllIObservableValueType((List)value)) {
            ExtendedMultiplicityObservableValue result = new ExtendedMultiplicityObservableValue(this.domain);
            int count = 0;
            while (count < 3) {
                IObservableValue existingMultiplicityValues = this.observableValues.get(count);
                IObservableValue multiplicityValueToAggregate = (IObservableValue)((List)value).get(count);
                if (existingMultiplicityValues instanceof AggregatedObservable) {
                    IObservableValue aggregatedObservable = (IObservableValue)((AggregatedObservable)existingMultiplicityValues).aggregate((IObservable)multiplicityValueToAggregate);
                    result.getObservableValues().add((IObservableValue)DelegatingObservable.wrap((IObservable)aggregatedObservable));
                }
                ++count;
            }
            return result;
        }
        return new AggregatedPapyrusObservableValue(this.domain, new IObservable[]{this, observable});
    }

    private boolean isAllIObservableValueType(List<?> values) {
        boolean result = true;
        Iterator<?> value = values.iterator();
        while (result && value.hasNext()) {
            if (value.next() instanceof IObservableValue) continue;
            result = false;
        }
        return result;
    }

    public Object getValueType() {
        return null;
    }

    protected Object doGetValue() {
        return this.getObservableValues();
    }

    protected void doSetValue(Object value) {
        if (!(value instanceof List)) {
            throw new IllegalArgumentException("value is not a List");
        }
        List listValue = (List)value;
        if (listValue.size() != 3) {
            throw new IllegalArgumentException(String.format("value is not a list of %d IObservableValues", 3));
        }
        if (!listValue.stream().allMatch(IObservableValue.class::isInstance)) {
            throw new IllegalArgumentException(String.format("value is not a list of %d IObservableValues", 3));
        }
        if (!listValue.equals(this.observableValues)) {
            List newObservables = listValue;
            newObservables.forEach(ReferenceCountedObservable.Util::retain);
            this.observableValues.forEach(ReferenceCountedObservable.Util::autorelease);
            ArrayList<IObservableValue> oldObservables = new ArrayList<IObservableValue>(this.observableValues);
            this.observableValues.clear();
            this.observableValues.addAll(newObservables);
            this.fireValueChange(Diffs.createValueDiff(oldObservables, (Object)newObservables));
        }
    }

    public List<IObservableValue> getObservableValues() {
        return this.observableValues;
    }

    public synchronized void dispose() {
        for (IObservableValue observableValue : this.observableValues) {
            observableValue.dispose();
        }
        this.observableValues.clear();
        super.dispose();
    }

    public void retain() {
        this.refCount.retain();
    }

    public void release() {
        this.refCount.release();
    }

    public void autorelease() {
        this.refCount.autorelease();
    }

    public boolean hasDifferentValues() {
        return false;
    }
}

