/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.edit.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetViewMutabilityCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ICanonicalShapeCompartmentLayout;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.clazz.custom.edit.commands.RestoreRelatedLinksCommand;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;

public class InitializeDiagramCommand
extends AbstractTransactionalCommand {
    protected Diagram diagram;
    protected DiagramEditPart host;

    public InitializeDiagramCommand(DiagramEditPart diagramEditPart) {
        super(diagramEditPart.getEditingDomain(), "Initialize Diagram From Semantic Model", null);
        this.host = diagramEditPart;
        this.diagram = this.host.getDiagramView();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.host().refresh();
        LinkedList<Object> createdViews = new LinkedList<Object>();
        createdViews.addAll(this.populateSemanticNodes());
        if (createdViews.size() > 0) {
            RestoreRelatedLinksCommand restoreRelatedLinksCommand = new RestoreRelatedLinksCommand((DiagramEditPart)this.getHost(), createdViews);
            CommandUtil.executeCommand((Command)new ICommandProxy((ICommand)restoreRelatedLinksCommand), (IGraphicalEditPart)this.host());
        }
        List<Object> viewAdapters = this.prepareAdapterList(createdViews);
        SetViewMutabilityCommand immutable = SetViewMutabilityCommand.makeImmutable(viewAdapters);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable((Command)immutable){
            private final /* synthetic */ Command val$immutable;
            {
                this.val$immutable = command;
            }

            @Override
            public void run() {
                this.val$immutable.execute();
            }
        });
        return null;
    }

    protected Command getCreateViewCommand(CreateRequest request) {
        if (request instanceof CreateConnectionViewRequest) {
            CreateConnectionViewRequest ccr = (CreateConnectionViewRequest)request;
            EditPart ep = ccr.getTargetEditPart() == null ? ccr.getSourceEditPart() : ccr.getTargetEditPart();
            return ep.getCommand((Request)request);
        }
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        Command cmd = this.host().getCommand((Request)request);
        if (cmd == null) {
            assert (request instanceof CreateViewRequest);
            for (CreateViewRequest.ViewDescriptor descriptor : ((CreateViewRequest)request).getViewDescriptors()) {
                ICommand createCommand = this.getCreateViewCommand(descriptor);
                cc.compose((IUndoableOperation)createCommand);
            }
        } else {
            cc.compose((IUndoableOperation)new CommandProxy(cmd));
            for (CreateViewRequest.ViewDescriptor descriptor : ((CreateViewRequest)request).getViewDescriptors()) {
                cc.compose((IUndoableOperation)new CommandProxy((Command)SetViewMutabilityCommand.makeMutable((IAdaptable)descriptor)));
            }
        }
        return new ICommandProxy(cc.reduce());
    }

    protected ICommand getCreateViewCommand(CreateViewRequest.ViewDescriptor descriptor) {
        TransactionalEditingDomain editingDomain = this.getHost().getEditingDomain();
        CreateCommand createCommand = new CreateCommand(editingDomain, descriptor, (View)this.getHost().getModel());
        CompositeCommand cmd = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        cmd.compose((IUndoableOperation)createCommand);
        cmd.compose((IUndoableOperation)new CommandProxy((Command)SetViewMutabilityCommand.makeMutable((IAdaptable)descriptor)));
        return cmd;
    }

    protected CreateViewRequest getCreateViewRequest(List<CreateViewRequest.ViewDescriptor> descriptors) {
        CreateViewRequest cvr = new CreateViewRequest(descriptors);
        Point loc = ICanonicalShapeCompartmentLayout.UNDEFINED.getLocation();
        cvr.setLocation(loc);
        return cvr;
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    protected final IGraphicalEditPart getHost() {
        return this.host;
    }

    protected CreateViewRequest.ViewDescriptor getViewDescriptor(EObject element) {
        EObjectAdapter elementAdapter = new EObjectAdapter(element);
        CreateViewRequest.ViewDescriptor descriptor = this.getViewDescriptor((IAdaptable)elementAdapter, Node.class, null, -1);
        return descriptor;
    }

    protected CreateViewRequest.ViewDescriptor getViewDescriptor(IAdaptable elementAdapter, Class<?> viewKind, String hint, int index) {
        return new CreateViewRequest.ViewDescriptor(elementAdapter, viewKind, hint, index, false, this.host().getDiagramPreferencesHint());
    }

    protected final IGraphicalEditPart host() {
        return this.host;
    }

    protected List<CreateViewRequest.ViewDescriptor> populateSemanticNodes() {
        CreateViewRequest request;
        Command cmd;
        ArrayList<CreateViewRequest.ViewDescriptor> descriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        View viewObject = (View)this.getHost().getModel();
        EObject container = this.getDiagram().getElement();
        if (container instanceof Package) {
            Package rootPackage = (Package)container;
            for (PackageableElement element : rootPackage.getPackagedElements()) {
                String visualID;
                if (element instanceof AssociationClass || (visualID = UMLVisualIDRegistry.getNodeVisualID(viewObject, (EObject)element)) == null || visualID.isEmpty()) continue;
                CreateViewRequest.ViewDescriptor descriptor = this.getViewDescriptor((EObject)element);
                descriptors.add(descriptor);
            }
        }
        if (!descriptors.isEmpty() && (cmd = this.getCreateViewCommand((CreateRequest)(request = this.getCreateViewRequest(descriptors)))) != null && cmd.canExecute()) {
            SetViewMutabilityCommand.makeMutable((IAdaptable)new EObjectAdapter((EObject)this.host().getNotationView())).execute();
            CommandUtil.executeCommand((Command)cmd, (IGraphicalEditPart)this.host());
            List result = (List)request.getNewObject();
            return result;
        }
        return Collections.emptyList();
    }

    private List<Object> prepareAdapterList(List<Object> createdViews) {
        ArrayList<Object> viewAdapters = new ArrayList<Object>();
        viewAdapters.add(this.host());
        ListIterator<Object> li = createdViews.listIterator();
        while (li.hasNext()) {
            Object obj = li.next();
            if (obj == null) continue;
            if (!(obj instanceof IAdaptable) && obj instanceof EObject) {
                viewAdapters.add(new EObjectAdapter((EObject)obj));
                continue;
            }
            viewAdapters.add(obj);
        }
        return viewAdapters;
    }
}

