/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.util;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.IAnnotationValidatorLoader;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.IPatternAnnotationValidator;

@Singleton
public class ExtensionBasedAnnotationValidatorLoader
implements IAnnotationValidatorLoader {
    private static final String EXTENSIONID = "org.eclipse.viatra.query.patternlanguage.emf.annotation";
    private static final String PROVIDER_PARAMETER_NAME = "provider";
    @Inject
    private Logger log;
    @Inject
    private Injector injector;
    private Map<String, IPatternAnnotationValidator> validators;

    public Map<String, IPatternAnnotationValidator> getKnownValidators() {
        if (this.validators != null) {
            return this.validators;
        }
        this.validators = new HashMap<String, IPatternAnnotationValidator>();
        if (Platform.isRunning()) {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSIONID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    IPatternAnnotationValidator validator = (IPatternAnnotationValidator)e.createExecutableExtension(PROVIDER_PARAMETER_NAME);
                    this.injector.injectMembers((Object)validator);
                    this.validators.put(validator.getAnnotationName(), validator);
                }
                catch (CoreException ex) {
                    this.log.error((Object)String.format("Error while initializing the validator for annotation %s from plugin %s.", e.getAttribute("name"), e.getContributor().getName()), (Throwable)ex);
                }
                ++n2;
            }
        }
        return this.validators;
    }
}

