/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.PruneFolderVisitor;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.mappings.AbstractModelMergeOperation;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceModelParticipant;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceSubscriberContext;
import org.eclipse.team.internal.core.mapping.CompoundResourceTraversal;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IWorkbenchPart;

public class ModelUpdateOperation
extends AbstractModelMergeOperation {
    public ModelUpdateOperation(IWorkbenchPart targetPart, ResourceMapping[] selectedResourceMappings, boolean consultModels) {
        this(targetPart, WorkspaceSubscriberContext.createUpdateScopeManager(selectedResourceMappings, consultModels));
    }

    public ModelUpdateOperation(IWorkbenchPart targetPart, ResourceMapping[] resourceMappings) {
        this(targetPart, resourceMappings, true);
    }

    public ModelUpdateOperation(IWorkbenchPart targetPart, SubscriberScopeManager manager) {
        super(targetPart, (ISynchronizationScopeManager)manager, true);
    }

    protected String getJobName() {
        return CVSUIMessages.UpdateOperation_taskName;
    }

    public boolean isPreviewRequested() {
        return super.isPreviewRequested() || !this.isAttemptHeadlessMerge();
    }

    protected boolean isAttemptHeadlessMerge() {
        return CVSUIPlugin.getPlugin().getPreferenceStore().getString("pref_team_update_handling").equals("performUpdate");
    }

    protected int getMergeType() {
        return 3;
    }

    @Override
    protected ModelSynchronizeParticipant createParticipant() {
        return new WorkspaceModelParticipant(this.createMergeContext());
    }

    protected SynchronizationContext createMergeContext() {
        return WorkspaceSubscriberContext.createContext(this.getScopeManager(), this.getMergeType());
    }

    protected void executeMerge(IProgressMonitor monitor) throws CoreException {
        super.executeMerge(monitor);
        if (CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
            CompoundResourceTraversal ct = new CompoundResourceTraversal();
            ct.addTraversals(this.getContext().getScope().getTraversals());
            IResource[] roots = ct.getRoots();
            ArrayList<ICVSResource> cvsResources = new ArrayList<ICVSResource>();
            IResource[] iResourceArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getProject().isAccessible()) {
                    cvsResources.add(CVSWorkspaceRoot.getCVSResourceFor((IResource)resource));
                }
                ++n2;
            }
            new PruneFolderVisitor().visit(CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot()), cvsResources.toArray(new ICVSResource[cvsResources.size()]));
        }
    }
}

