/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.ccvs.core.mapping.CVSCheckedInChangeSet;
import org.eclipse.team.internal.ccvs.core.mapping.ChangeSetModelProvider;
import org.eclipse.team.internal.ccvs.core.mapping.UnassignedDiffChangeSet;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.mappings.ChangeSetSorter;
import org.eclipse.team.internal.ccvs.ui.mappings.CheckedInChangeSetCollector;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelParticipantChangeSetCapability;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.BatchingChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.core.subscribers.IChangeSetChangeListener;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceModelContentProvider;
import org.eclipse.team.internal.ui.mapping.ResourceModelLabelProvider;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorSorterService;

public class ChangeSetContentProvider
extends ResourceModelContentProvider
implements ITreePathContentProvider {
    private DiffChangeSet unassignedDiffs;
    private boolean firstDiffChange = true;
    private IChangeSetChangeListener collectorListener = new CollectorListener();
    private IDiffChangeListener diffTreeListener = new IDiffChangeListener(){

        public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
        }

        boolean isSetVisible(DiffChangeSet set) {
            return ChangeSetContentProvider.this.getVisibleSetsInViewer().contains(set);
        }

        public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
            Object input = ChangeSetContentProvider.this.getViewer().getInput();
            if (input instanceof ChangeSetModelProvider && ChangeSetContentProvider.this.unassignedDiffs != null && event.getTree() == ChangeSetContentProvider.this.unassignedDiffs.getDiffTree()) {
                Utils.asyncExec(() -> {
                    if (ChangeSetContentProvider.this.unassignedDiffs.isEmpty() || !ChangeSetContentProvider.this.hasChildren(TreePath.EMPTY.createChildPath((Object)ChangeSetContentProvider.this.getUnassignedSet()))) {
                        ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).remove((Object)ChangeSetContentProvider.this.unassignedDiffs);
                    } else if (!this.isSetVisible(ChangeSetContentProvider.this.unassignedDiffs)) {
                        Object input1 = ChangeSetContentProvider.this.getViewer().getInput();
                        ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).add(input1, (Object)ChangeSetContentProvider.this.unassignedDiffs);
                    } else {
                        ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).refresh((Object)ChangeSetContentProvider.this.unassignedDiffs);
                    }
                }, (StructuredViewer)((StructuredViewer)ChangeSetContentProvider.this.getViewer()));
            }
        }
    };
    private CheckedInChangeSetCollector checkedInCollector;
    private boolean collectorInitialized;

    protected String getModelProviderId() {
        return "org.eclipse.team.cvs.core.changeSetModel";
    }

    boolean isVisibleInMode(ChangeSet set) {
        Object input = this.getViewer().getInput();
        if (input instanceof ChangeSetModelProvider) {
            if (set instanceof ActiveChangeSet) {
                return this.getConfiguration().getMode() != 1;
            }
            if (set instanceof DiffChangeSet) {
                return this.getConfiguration().getMode() != 2;
            }
        }
        return false;
    }

    protected boolean isEnabled() {
        Object input = this.getViewer().getInput();
        return input instanceof ChangeSetModelProvider;
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof ISynchronizationContext) {
            return new Object[0];
        }
        if (parent == this.getModelProvider()) {
            return this.getRootElements();
        }
        return super.getElements(parent);
    }

    private Object[] getRootElements() {
        DiffChangeSet[] sets;
        if (!this.collectorInitialized) {
            this.initializeCheckedInChangeSetCollector(this.getChangeSetCapability());
            this.collectorInitialized = true;
        }
        ArrayList<DiffChangeSet> result = new ArrayList<DiffChangeSet>();
        DiffChangeSet[] diffChangeSetArray = sets = this.getAllSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            DiffChangeSet set = diffChangeSetArray[n2];
            if (this.hasChildren(TreePath.EMPTY.createChildPath((Object)set))) {
                result.add(set);
            }
            ++n2;
        }
        if (!this.getUnassignedSet().isEmpty() && this.hasChildren(TreePath.EMPTY.createChildPath((Object)this.getUnassignedSet()))) {
            result.add(this.getUnassignedSet());
        }
        return result.toArray();
    }

    synchronized DiffChangeSet getUnassignedSet() {
        if (this.unassignedDiffs == null) {
            this.unassignedDiffs = new UnassignedDiffChangeSet(CVSUIMessages.ChangeSetContentProvider_0);
            this.unassignedDiffs.getDiffTree().addDiffChangeListener(this.diffTreeListener);
            this.addAllUnassignedToUnassignedSet();
        }
        return this.unassignedDiffs;
    }

    private void addAllUnassignedToUnassignedSet() {
        IResourceDiffTree allChanges = this.getContext().getDiffTree();
        ArrayList diffs = new ArrayList();
        allChanges.accept(ResourcesPlugin.getWorkspace().getRoot().getFullPath(), diff -> {
            if (!this.isContainedInSet(diff)) {
                diffs.add(diff);
            }
            return true;
        }, 2);
        this.unassignedDiffs.add(diffs.toArray(new IDiff[diffs.size()]));
    }

    private ResourceDiffTree getTheRest() {
        return (ResourceDiffTree)this.getUnassignedSet().getDiffTree();
    }

    protected boolean isContainedInSet(IDiff diff) {
        DiffChangeSet[] sets;
        DiffChangeSet[] diffChangeSetArray = sets = this.getAllSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            DiffChangeSet set = diffChangeSetArray[n2];
            if (set.contains(ResourceDiffTree.getResourceFor((IDiff)diff))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected ResourceTraversal[] getTraversals(ISynchronizationContext context, Object object) {
        if (object instanceof ChangeSet) {
            ChangeSet set = (ChangeSet)object;
            IResource[] resources = set.getResources();
            return new ResourceTraversal[]{new ResourceTraversal(resources, 0, 0)};
        }
        return super.getTraversals(context, object);
    }

    public Object[] getChildren(TreePath parentPath) {
        IResourceDiffTree diffTree;
        if (!this.isEnabled()) {
            return new Object[0];
        }
        if (parentPath.getSegmentCount() == 0) {
            return this.getRootElements();
        }
        Object first = parentPath.getFirstSegment();
        if (!this.isVisibleInMode(first)) {
            return new Object[0];
        }
        Object parent = parentPath.getLastSegment();
        if (first instanceof DiffChangeSet) {
            DiffChangeSet set = (DiffChangeSet)first;
            diffTree = set.getDiffTree();
            if (parent instanceof DiffChangeSet) {
                parent = this.getModelRoot();
            }
        } else {
            return new Object[0];
        }
        Object[] children = this.getChildren(parent);
        HashSet<Object> result = new HashSet<Object>();
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (this.isVisible(child, diffTree)) {
                result.add(child);
            }
            ++n2;
        }
        return result.toArray();
    }

    private boolean isVisibleInMode(Object first) {
        if (first instanceof ChangeSet) {
            ChangeSet cs = (ChangeSet)first;
            int mode = this.getConfiguration().getMode();
            switch (mode) {
                case 4: {
                    return true;
                }
                case 8: {
                    return this.containsConflicts(cs);
                }
                case 1: {
                    return cs instanceof CVSCheckedInChangeSet || this.isUnassignedSet(cs) && this.hasIncomingChanges(cs);
                }
                case 2: {
                    return cs instanceof ActiveChangeSet || this.hasConflicts(cs) || this.isUnassignedSet(cs) && this.hasOutgoingChanges(cs);
                }
            }
        }
        return true;
    }

    private boolean hasIncomingChanges(ChangeSet cs) {
        if (cs instanceof DiffChangeSet) {
            DiffChangeSet dcs = (DiffChangeSet)cs;
            return dcs.getDiffTree().countFor(512, 768) > 0L;
        }
        return false;
    }

    private boolean hasOutgoingChanges(ChangeSet cs) {
        if (cs instanceof DiffChangeSet) {
            DiffChangeSet dcs = (DiffChangeSet)cs;
            return dcs.getDiffTree().countFor(256, 768) > 0L;
        }
        return false;
    }

    private boolean isUnassignedSet(ChangeSet cs) {
        return cs == this.unassignedDiffs;
    }

    private boolean hasConflicts(ChangeSet cs) {
        if (cs instanceof DiffChangeSet) {
            DiffChangeSet dcs = (DiffChangeSet)cs;
            return dcs.getDiffTree().countFor(768, 768) > 0L;
        }
        return false;
    }

    private boolean containsConflicts(ChangeSet cs) {
        if (cs instanceof DiffChangeSet) {
            DiffChangeSet dcs = (DiffChangeSet)cs;
            return dcs.getDiffTree().hasMatchingDiffs(ResourcesPlugin.getWorkspace().getRoot().getFullPath(), ResourceModelLabelProvider.CONFLICT_FILTER);
        }
        return false;
    }

    private boolean isVisible(Object object, IResourceDiffTree tree) {
        if (object instanceof IResource) {
            IDiff[] diffs;
            IResource resource = (IResource)object;
            IDiff diff = tree.getDiff(resource);
            if (diff != null && this.isVisible(diff)) {
                return true;
            }
            int depth = this.getTraversalCalculator().getLayoutDepth(resource, null);
            IDiff[] iDiffArray = diffs = tree.getDiffs(resource, depth);
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                IDiff child = iDiffArray[n2];
                if (this.isVisible(child)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean hasChildren(TreePath path) {
        Object first;
        if (path.getSegmentCount() == 1 && (first = path.getFirstSegment()) instanceof ChangeSet) {
            return this.isVisibleInMode(first) && this.hasChildrenInContext((ChangeSet)first);
        }
        return this.getChildren(path).length > 0;
    }

    private boolean hasChildrenInContext(ChangeSet set) {
        IResource[] resources;
        IResource[] iResourceArray = resources = set.getResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (this.getContext().getDiffTree().getDiff(resource) != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public TreePath[] getParents(Object element) {
        if (element instanceof ChangeSet) {
            return new TreePath[]{TreePath.EMPTY};
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            DiffChangeSet[] sets = this.getSetsContaining(resource);
            if (sets.length > 0) {
                ArrayList<TreePath> result = new ArrayList<TreePath>();
                DiffChangeSet[] diffChangeSetArray = sets;
                int n = sets.length;
                int n2 = 0;
                while (n2 < n) {
                    DiffChangeSet set = diffChangeSetArray[n2];
                    TreePath path = this.getPathForElement(set, (IResource)resource.getParent());
                    if (path != null) {
                        result.add(path);
                    }
                    ++n2;
                }
                return result.toArray(new TreePath[result.size()]);
            }
            TreePath path = this.getPathForElement(this.getUnassignedSet(), (IResource)resource.getParent());
            if (path != null) {
                return new TreePath[]{path};
            }
        }
        return new TreePath[0];
    }

    private DiffChangeSet[] getSetsContaining(IResource resource) {
        DiffChangeSet[] allSets;
        ArrayList<DiffChangeSet> result = new ArrayList<DiffChangeSet>();
        DiffChangeSet[] diffChangeSetArray = allSets = this.getAllSets();
        int n = allSets.length;
        int n2 = 0;
        while (n2 < n) {
            DiffChangeSet set = diffChangeSetArray[n2];
            if (this.isVisible(resource, set.getDiffTree())) {
                result.add(set);
            }
            ++n2;
        }
        return result.toArray(new DiffChangeSet[result.size()]);
    }

    private DiffChangeSet[] getAllSets() {
        ArrayList result = new ArrayList();
        ChangeSetCapability csc = this.getChangeSetCapability();
        if (csc.supportsActiveChangeSets()) {
            ActiveChangeSetManager collector = csc.getActiveChangeSetManager();
            ChangeSet[] sets = collector.getSets();
            Collections.addAll(result, sets);
        }
        if (this.checkedInCollector != null) {
            ChangeSet[] sets = this.checkedInCollector.getSets();
            Collections.addAll(result, sets);
        }
        return result.toArray(new DiffChangeSet[result.size()]);
    }

    private TreePath getPathForElement(DiffChangeSet set, IResource resource) {
        List pathList = this.getPath(set.getDiffTree(), resource);
        if (pathList != null) {
            pathList.add(0, set);
            TreePath path = new TreePath(pathList.toArray());
            return path;
        }
        return null;
    }

    private List getPath(IResourceDiffTree tree, IResource resource) {
        boolean hasDiff;
        if (resource == null) {
            return null;
        }
        boolean bl = hasDiff = tree.getDiff(resource) == null;
        if (hasDiff && tree.members(resource).length == 0) {
            return null;
        }
        if (resource.getType() == 8) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(resource.getProject());
        if (resource.getType() != 4) {
            String layout = this.getTraversalCalculator().getLayout();
            if (layout.equals("org.eclipse.team.ui.flay_layout")) {
                result.add(resource);
            } else if (layout.equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 2) {
                result.add(resource);
            } else if (layout.equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 1) {
                IContainer parent = resource.getParent();
                if (parent.getType() != 4) {
                    result.add(parent);
                }
                result.add(resource);
            } else {
                ArrayList<IResource> resourcePath = new ArrayList<IResource>();
                IResource next = resource;
                while (next.getType() != 4) {
                    resourcePath.add(next);
                    next = next.getParent();
                }
                int i = resourcePath.size() - 1;
                while (i >= 0) {
                    result.add(resourcePath.get(i));
                    --i;
                }
            }
        }
        return result;
    }

    public void init(ICommonContentExtensionSite site) {
        ChangeSetSorter sorter;
        super.init(site);
        ChangeSetCapability csc = this.getChangeSetCapability();
        if (csc.supportsActiveChangeSets()) {
            ActiveChangeSetManager collector = csc.getActiveChangeSetManager();
            collector.addListener(this.collectorListener);
        }
        if ((sorter = this.getSorter()) != null) {
            sorter.setConfiguration(this.getConfiguration());
        }
    }

    private ChangeSetSorter getSorter() {
        ViewerSorter sorter;
        INavigatorContentService contentService = this.getExtensionSite().getService();
        INavigatorSorterService sortingService = contentService.getSorterService();
        INavigatorContentExtension extension = this.getExtensionSite().getExtension();
        if (extension != null && (sorter = sortingService.findSorter(extension.getDescriptor(), (Object)this.getModelProvider(), (Object)new DiffChangeSet(), (Object)new DiffChangeSet())) instanceof ChangeSetSorter) {
            return (ChangeSetSorter)sorter;
        }
        return null;
    }

    private void initializeCheckedInChangeSetCollector(ChangeSetCapability csc) {
        if (csc.supportsCheckedInChangeSets()) {
            this.checkedInCollector = ((ModelParticipantChangeSetCapability)csc).createCheckedInChangeSetCollector(this.getConfiguration());
            this.getConfiguration().setProperty("org.eclipse.team.cvs.ui.CVSCheckedInCollector", (Object)this.checkedInCollector);
            this.checkedInCollector.addListener(this.collectorListener);
            this.checkedInCollector.add(((ResourceDiffTree)this.getContext().getDiffTree()).getDiffs());
        }
    }

    public void dispose() {
        ChangeSetCapability csc = this.getChangeSetCapability();
        if (csc.supportsActiveChangeSets()) {
            csc.getActiveChangeSetManager().removeListener(this.collectorListener);
        }
        if (this.checkedInCollector != null) {
            this.checkedInCollector.removeListener(this.collectorListener);
            this.checkedInCollector.dispose();
        }
        if (this.unassignedDiffs != null) {
            this.unassignedDiffs.getDiffTree().removeDiffChangeListener(this.diffTreeListener);
        }
        super.dispose();
    }

    public boolean isVisible(IDiff diff) {
        return super.isVisible(diff);
    }

    public IResourceDiffTree getDiffTree(TreePath path) {
        Object first;
        if (path.getSegmentCount() > 0 && (first = path.getFirstSegment()) instanceof DiffChangeSet) {
            DiffChangeSet set = (DiffChangeSet)first;
            return set.getDiffTree();
        }
        return this.getTheRest();
    }

    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        IPath[] removed = event.getRemovals();
        IDiff[] added = event.getAdditions();
        IDiff[] changed = event.getChanges();
        try {
            IPath diff;
            this.getTheRest().beginInput();
            IPath[] iPathArray = removed;
            int n = removed.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                this.getTheRest().remove(path);
                ++n2;
            }
            iPathArray = added;
            n = added.length;
            n2 = 0;
            while (n2 < n) {
                diff = iPathArray[n2];
                if (!this.isContainedInSet((IDiff)diff)) {
                    this.getTheRest().add((IDiff)diff);
                }
                ++n2;
            }
            iPathArray = changed;
            n = changed.length;
            n2 = 0;
            while (n2 < n) {
                diff = iPathArray[n2];
                if (this.getTheRest().getDiff(diff.getPath()) != null) {
                    this.getTheRest().add((IDiff)diff);
                }
                ++n2;
            }
        }
        finally {
            this.getTheRest().endInput(monitor);
        }
        if (this.checkedInCollector != null) {
            this.checkedInCollector.handleChange(event);
        }
        if (this.firstDiffChange) {
            this.firstDiffChange = false;
            Utils.asyncExec(() -> ((AbstractTreeViewer)this.getViewer()).refresh(), (StructuredViewer)((StructuredViewer)this.getViewer()));
        }
    }

    protected void updateLabels(ISynchronizationContext context, IPath[] paths) {
        super.updateLabels(context, paths);
        Object[] sets = this.getSetsShowingPropogatedStateFrom(paths);
        if (sets.length > 0) {
            ((AbstractTreeViewer)this.getViewer()).update(sets, null);
        }
    }

    private ChangeSet[] getSetsShowingPropogatedStateFrom(IPath[] paths) {
        HashSet result = new HashSet();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            DiffChangeSet[] sets = this.getSetsShowingPropogatedStateFrom(path);
            Collections.addAll(result, sets);
            ++n2;
        }
        return result.toArray(new ChangeSet[result.size()]);
    }

    protected DiffChangeSet[] getSetsShowingPropogatedStateFrom(IPath path) {
        DiffChangeSet[] allSets;
        ArrayList<DiffChangeSet> result = new ArrayList<DiffChangeSet>();
        DiffChangeSet[] diffChangeSetArray = allSets = this.getAllSets();
        int n = allSets.length;
        int n2 = 0;
        while (n2 < n) {
            DiffChangeSet set = diffChangeSetArray[n2];
            if (set.getDiffTree().getDiff(path) != null || set.getDiffTree().getChildren(path).length > 0) {
                result.add(set);
            }
            ++n2;
        }
        return result.toArray(new DiffChangeSet[result.size()]);
    }

    public ChangeSetCapability getChangeSetCapability() {
        ISynchronizeParticipant participant = this.getConfiguration().getParticipant();
        if (participant instanceof IChangeSetProvider) {
            IChangeSetProvider provider = (IChangeSetProvider)participant;
            return provider.getChangeSetCapability();
        }
        return null;
    }

    private Set getVisibleSetsInViewer() {
        TreeViewer viewer = (TreeViewer)this.getViewer();
        Tree tree = viewer.getTree();
        TreeItem[] children = tree.getItems();
        HashSet<ChangeSet> result = new HashSet<ChangeSet>();
        TreeItem[] treeItemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem control = treeItemArray[n2];
            Object data = control.getData();
            if (data instanceof ChangeSet) {
                ChangeSet set = (ChangeSet)data;
                result.add(set);
            }
            ++n2;
        }
        return result;
    }

    private final class CollectorListener
    implements IChangeSetChangeListener,
    BatchingChangeSetManager.IChangeSetCollectorChangeListener {
        private CollectorListener() {
        }

        public void setAdded(ChangeSet set) {
            if (set instanceof ActiveChangeSet) {
                if (ChangeSetContentProvider.this.isVisibleInMode(set)) {
                    Utils.syncExec(() -> {
                        Object input = ChangeSetContentProvider.this.getViewer().getInput();
                        ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).add(input, (Object)set);
                    }, (StructuredViewer)((StructuredViewer)ChangeSetContentProvider.this.getViewer()));
                }
                this.handleSetAddition(set);
            }
        }

        private void handleSetAddition(ChangeSet set) {
            ChangeSetContentProvider.this.getUnassignedSet().remove(set.getResources());
        }

        public void defaultSetChanged(ChangeSet previousDefault, ChangeSet set) {
            if (ChangeSetContentProvider.this.isVisibleInMode(set) || ChangeSetContentProvider.this.isVisibleInMode(previousDefault)) {
                Utils.asyncExec(() -> {
                    if (set == null) {
                        ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).update((Object)previousDefault, null);
                    } else if (previousDefault != null) {
                        ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).update(new Object[]{previousDefault, set}, null);
                    } else {
                        ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).update((Object)set, null);
                    }
                }, (StructuredViewer)((StructuredViewer)ChangeSetContentProvider.this.getViewer()));
            }
        }

        public void setRemoved(ChangeSet set) {
            if (set instanceof ActiveChangeSet) {
                if (ChangeSetContentProvider.this.isVisibleInMode(set)) {
                    Utils.syncExec(() -> ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).remove((Object)TreePath.EMPTY.createChildPath((Object)set)), (StructuredViewer)((StructuredViewer)ChangeSetContentProvider.this.getViewer()));
                }
                this.handleSetRemoval(set);
            }
        }

        private void handleSetRemoval(ChangeSet set) {
            IResource[] resources = set.getResources();
            ArrayList<IDiff> toAdd = new ArrayList<IDiff>();
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                IDiff diff = ChangeSetContentProvider.this.getContext().getDiffTree().getDiff(resource);
                if (diff != null && !ChangeSetContentProvider.this.isContainedInSet(diff)) {
                    toAdd.add(diff);
                }
                ++n2;
            }
            ChangeSetContentProvider.this.getUnassignedSet().add(toAdd.toArray(new IDiff[toAdd.size()]));
        }

        public void nameChanged(ChangeSet set) {
            if (ChangeSetContentProvider.this.isVisibleInMode(set)) {
                Utils.asyncExec(() -> ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).update((Object)set, null), (StructuredViewer)((StructuredViewer)ChangeSetContentProvider.this.getViewer()));
            }
        }

        public void resourcesChanged(ChangeSet set, IPath[] paths) {
            if (set instanceof ActiveChangeSet) {
                if (ChangeSetContentProvider.this.isVisibleInMode(set)) {
                    Utils.syncExec(() -> {
                        if (ChangeSetContentProvider.this.hasChildrenInContext(set)) {
                            if (ChangeSetContentProvider.this.getVisibleSetsInViewer().contains(set)) {
                                ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).refresh((Object)set, true);
                            } else {
                                ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).add(ChangeSetContentProvider.this.getViewer().getInput(), (Object)set);
                            }
                        } else {
                            ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).remove((Object)set);
                        }
                    }, (StructuredViewer)((StructuredViewer)ChangeSetContentProvider.this.getViewer()));
                }
                this.handleSetChange(set, paths);
            }
        }

        private void handleSetChange(ChangeSet set, IPath[] paths) {
            try {
                ChangeSetContentProvider.this.getTheRest().beginInput();
                IPath[] iPathArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    IDiff diff;
                    IPath path = iPathArray[n2];
                    boolean isContained = ((DiffChangeSet)set).contains(path);
                    if (isContained) {
                        diff = ((DiffChangeSet)set).getDiffTree().getDiff(path);
                        if (diff != null) {
                            ChangeSetContentProvider.this.getTheRest().remove(ResourceDiffTree.getResourceFor((IDiff)diff));
                        }
                    } else {
                        diff = ChangeSetContentProvider.this.getContext().getDiffTree().getDiff(path);
                        if (diff != null && !ChangeSetContentProvider.this.isContainedInSet(diff)) {
                            ChangeSetContentProvider.this.getTheRest().add(diff);
                        }
                    }
                    ++n2;
                }
            }
            finally {
                ChangeSetContentProvider.this.getTheRest().endInput(null);
            }
        }

        public void changeSetChanges(BatchingChangeSetManager.CollectorChangeEvent event, IProgressMonitor monitor) {
            ChangeSet[] addedSets = event.getAddedSets();
            Object[] visibleAddedSets = this.getVisibleSets(addedSets);
            ChangeSet[] removedSets = event.getRemovedSets();
            Object[] visibleRemovedSets = this.getVisibleSets(removedSets);
            ChangeSet[] changedSets = event.getChangedSets();
            ChangeSet[] visibleChangedSets = this.getVisibleSets(changedSets);
            if (visibleAddedSets.length > 0 || visibleRemovedSets.length > 0 || visibleChangedSets.length > 0) {
                Utils.syncExec(() -> {
                    try {
                        ChangeSetContentProvider.this.getViewer().getControl().setRedraw(false);
                        if (visibleAddedSets.length > 0) {
                            Object input = ChangeSetContentProvider.this.getViewer().getInput();
                            ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).add(input, visibleAddedSets);
                        }
                        if (visibleRemovedSets.length > 0) {
                            ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).remove(visibleRemovedSets);
                        }
                        ChangeSet[] changeSetArray2 = visibleChangedSets;
                        int n = visibleChangedSets.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ChangeSet set = changeSetArray2[n2];
                            ((AbstractTreeViewer)ChangeSetContentProvider.this.getViewer()).refresh((Object)set, true);
                            ++n2;
                        }
                    }
                    finally {
                        ChangeSetContentProvider.this.getViewer().getControl().setRedraw(true);
                    }
                }, (StructuredViewer)((StructuredViewer)ChangeSetContentProvider.this.getViewer()));
            }
            try {
                ChangeSet set;
                ChangeSetContentProvider.this.getTheRest().beginInput();
                ChangeSet[] changeSetArray = addedSets;
                int n = addedSets.length;
                int n2 = 0;
                while (n2 < n) {
                    set = changeSetArray[n2];
                    this.handleSetAddition(set);
                    ++n2;
                }
                if (removedSets.length > 0) {
                    ChangeSetContentProvider.this.addAllUnassignedToUnassignedSet();
                }
                changeSetArray = changedSets;
                n = changedSets.length;
                n2 = 0;
                while (n2 < n) {
                    set = changeSetArray[n2];
                    IPath[] paths = event.getChangesFor(set);
                    if (event.getSource().contains(set)) {
                        this.handleSetChange(set, paths);
                    } else {
                        try {
                            ChangeSetContentProvider.this.getTheRest().beginInput();
                            IPath[] iPathArray = paths;
                            int n3 = paths.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IPath path = iPathArray[n4];
                                IDiff diff = ChangeSetContentProvider.this.getContext().getDiffTree().getDiff(path);
                                if (diff != null && !ChangeSetContentProvider.this.isContainedInSet(diff)) {
                                    ChangeSetContentProvider.this.getTheRest().add(diff);
                                }
                                ++n4;
                            }
                        }
                        finally {
                            ChangeSetContentProvider.this.getTheRest().endInput(null);
                        }
                    }
                    ++n2;
                }
            }
            finally {
                ChangeSetContentProvider.this.getTheRest().endInput(monitor);
            }
        }

        private ChangeSet[] getVisibleSets(ChangeSet[] sets) {
            ArrayList<ChangeSet> result = new ArrayList<ChangeSet>(sets.length);
            ChangeSet[] changeSetArray = sets;
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeSet set = changeSetArray[n2];
                if (ChangeSetContentProvider.this.isVisibleInMode(set)) {
                    result.add(set);
                }
                ++n2;
            }
            return result.toArray(new ChangeSet[result.size()]);
        }
    }
}

