/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.breakpoints;

import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.gdb.breakpoints.Messages;
import org.eclipse.osgi.util.NLS;

public class GDBDynamicPrintfUtils {

    @Immutable
    public static class GDBDynamicPrintfString {
        private boolean fValid;
        private String fStringSection;
        private String[] fArgs;
        private String fErrorMessage;

        public GDBDynamicPrintfString(String str) {
            if (str == null) {
                this.fErrorMessage = Messages.DynamicPrintf_Invalid_string;
                return;
            }
            if ((str = str.trim()).isEmpty()) {
                this.fErrorMessage = Messages.DynamicPrintf_Invalid_string;
                return;
            }
            if (str.charAt(0) != '\"') {
                this.fErrorMessage = Messages.DynamicPrintf_Printf_must_start_with_quote;
                return;
            }
            if (str.charAt(str.length() - 1) == ')') {
                this.fErrorMessage = Messages.DynamicPrintf_Printf_not_expecting_a_closing_parenthesis;
                return;
            }
            char[] chars = str.toCharArray();
            int closingQuoteIndex = 0;
            int numArgExpected = 0;
            int i = 1;
            while (i < chars.length) {
                switch (chars[i]) {
                    case '\\': {
                        ++i;
                        break;
                    }
                    case '\"': {
                        closingQuoteIndex = i;
                        break;
                    }
                    case '%': {
                        if (chars.length > i + 1 && chars[i + 1] != '%') {
                            ++numArgExpected;
                        }
                        ++i;
                    }
                }
                if (closingQuoteIndex > 0) break;
                ++i;
            }
            if (closingQuoteIndex < 1) {
                this.fErrorMessage = Messages.DynamicPrintf_Printf_missing_closing_quote;
                return;
            }
            this.fStringSection = str.substring(0, closingQuoteIndex + 1);
            int numArgPresent = 0;
            if (closingQuoteIndex + 1 >= str.length()) {
                this.fArgs = new String[0];
                numArgPresent = 0;
            } else {
                String[] args;
                String argString = str.substring(closingQuoteIndex + 1).trim();
                if (argString.charAt(0) != ',') {
                    this.fErrorMessage = Messages.DynamicPrintf_Missing_comma;
                    return;
                }
                String[] stringArray = args = argString.substring(1).split(",", -1);
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String argument = stringArray[n2];
                    if (argument.trim().isEmpty()) {
                        this.fErrorMessage = Messages.DynamicPrintf_Empty_arg;
                        return;
                    }
                    ++n2;
                }
                this.fArgs = args;
                numArgPresent = this.fArgs.length;
            }
            if (numArgPresent != numArgExpected) {
                this.fErrorMessage = numArgPresent > numArgExpected ? NLS.bind((String)Messages.DynamicPrintf_Extra_arg, (Object)(numArgPresent - numArgExpected)) : NLS.bind((String)Messages.DynamicPrintf_Missing_arg, (Object)(numArgExpected - numArgPresent));
                return;
            }
            this.fValid = true;
        }

        public boolean isValid() {
            return this.fValid;
        }

        public String getString() {
            if (!this.isValid()) {
                return "";
            }
            return this.fStringSection;
        }

        public String[] getArguments() {
            if (!this.isValid()) {
                return new String[0];
            }
            return this.fArgs;
        }

        public String getErrorMessage() {
            return this.fErrorMessage;
        }
    }
}

