/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.util.HashSet;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIField;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIType;

public class StructsGenerator
extends JNIGenerator {
    boolean header;
    static final boolean GLOBAL_REF = false;

    public StructsGenerator(boolean header) {
        this.header = header;
    }

    @Override
    public void generateCopyright() {
        this.outputln(this.fixDelimiter(this.getMetaData().getCopyright()));
    }

    @Override
    public void generateIncludes() {
        if (this.header) {
            this.output("#include \"");
            this.output(this.getOutputName());
            this.outputln(".h\"");
        } else {
            this.outputln("#include \"swt.h\"");
            this.output("#include \"");
            this.output(this.getOutputName());
            this.outputln("_structs.h\"");
        }
        this.outputln();
    }

    @Override
    public void generate(JNIClass clazz) {
        int j = 0;
        JNIField[] fields = clazz.getDeclaredFields();
        while (j < fields.length) {
            JNIField field = fields[j];
            int mods = field.getModifiers();
            if ((mods & 1) != 0 && (mods & 8) == 0) break;
            ++j;
        }
        if (j == fields.length) {
            return;
        }
        if (this.header) {
            this.generateHeaderFile(clazz);
        } else {
            this.generateSourceFile(clazz);
        }
    }

    @Override
    public String getExtension() {
        return this.header ? ".h" : super.getExtension();
    }

    @Override
    public String getSuffix() {
        return "_structs";
    }

    void generateExcludes(JNIClass[] classes) {
        HashSet<String> excludes = new HashSet<String>();
        JNIClass[] jNIClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            JNIClass clazz = jNIClassArray[n2];
            String exclude = clazz.getExclude();
            if (exclude.length() != 0) {
                excludes.add(exclude);
            }
            ++n2;
        }
        for (String exclude : excludes) {
            this.outputln(exclude);
            JNIClass[] jNIClassArray2 = classes;
            int n3 = classes.length;
            int n4 = 0;
            while (n4 < n3) {
                JNIClass clazz = jNIClassArray2[n4];
                String classExclude = clazz.getExclude();
                if (exclude.equals(classExclude)) {
                    this.output("#define NO_");
                    this.outputln(clazz.getSimpleName());
                }
                ++n4;
            }
            this.outputln("#endif");
            this.outputln();
        }
    }

    void generateHeaderFile(JNIClass clazz) {
        this.generateSourceStart(clazz);
        this.generatePrototypes(clazz);
        this.generateBlankMacros(clazz);
        this.generateSourceEnd();
        this.outputln();
    }

    void generateSourceFile(JNIClass clazz) {
        this.generateSourceStart(clazz);
        this.generateFIDsStructure(clazz);
        this.outputln();
        this.generateGlobalVar(clazz);
        this.outputln();
        this.generateFunctions(clazz);
        this.generateSourceEnd();
        this.outputln();
    }

    void generateSourceStart(JNIClass clazz) {
        String clazzName = clazz.getSimpleName();
        this.output("#ifndef NO_");
        this.outputln(clazzName);
    }

    void generateSourceEnd() {
        this.outputln("#endif");
    }

    void generateGlobalVar(JNIClass clazz) {
        String clazzName = clazz.getSimpleName();
        this.output(clazzName);
        this.output("_FID_CACHE ");
        this.output(clazzName);
        this.outputln("Fc;");
    }

    void generateBlankMacros(JNIClass clazz) {
        String clazzName = clazz.getSimpleName();
        this.outputln("#else");
        this.output("#define cache");
        this.output(clazzName);
        this.outputln("Fields(a,b)");
        this.output("#define get");
        this.output(clazzName);
        this.outputln("Fields(a,b,c) NULL");
        this.output("#define set");
        this.output(clazzName);
        this.outputln("Fields(a,b,c)");
        this.output("#define ");
        this.output(clazzName);
        this.outputln("_sizeof() 0");
    }

    void generatePrototypes(JNIClass clazz) {
        String clazzName = clazz.getSimpleName();
        this.output("void cache");
        this.output(clazzName);
        this.outputln("Fields(JNIEnv *env, jobject lpObject);");
        if (clazz.getFlag("struct")) {
            this.output("struct ");
        }
        this.output(clazzName);
        this.output(" *get");
        this.output(clazzName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        if (clazz.getFlag("struct")) {
            this.output("struct ");
        }
        this.output(clazzName);
        this.outputln(" *lpStruct);");
        this.output("void set");
        this.output(clazzName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        if (clazz.getFlag("struct")) {
            this.output("struct ");
        }
        this.output(clazzName);
        this.outputln(" *lpStruct);");
        this.output("#define ");
        this.output(clazzName);
        this.output("_sizeof() sizeof(");
        if (clazz.getFlag("struct")) {
            this.output("struct ");
        }
        this.output(clazzName);
        this.outputln(")");
    }

    void generateFIDsStructure(JNIClass clazz) {
        String clazzName = clazz.getSimpleName();
        this.output("typedef struct ");
        this.output(clazzName);
        this.outputln("_FID_CACHE {");
        this.outputln("\tint cached;");
        this.outputln("\tjclass clazz;");
        this.output("\tjfieldID ");
        boolean first = true;
        JNIField[] jNIFieldArray = clazz.getDeclaredFields();
        int n = jNIFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            JNIField field = jNIFieldArray[n2];
            if (!this.ignoreField(field)) {
                if (!first) {
                    this.output(", ");
                }
                this.output(field.getName());
                first = false;
            }
            ++n2;
        }
        this.outputln(";");
        this.output("} ");
        this.output(clazzName);
        this.outputln("_FID_CACHE;");
    }

    void generateCacheFunction(JNIClass clazz) {
        String clazzName = clazz.getSimpleName();
        this.output("void cache");
        this.output(clazzName);
        this.outputln("Fields(JNIEnv *env, jobject lpObject)");
        this.outputln("{");
        this.output("\tif (");
        this.output(clazzName);
        this.outputln("Fc.cached) return;");
        JNIClass superclazz = clazz.getSuperclass();
        if (!superclazz.getName().equals("java.lang.Object")) {
            String superName = superclazz.getSimpleName();
            this.output("\tcache");
            this.output(superName);
            this.outputln("Fields(env, lpObject);");
        }
        this.output("\t");
        this.output(clazzName);
        boolean isCPP = this.getCPP();
        if (isCPP) {
            this.output("Fc.clazz = env->GetObjectClass(lpObject);");
        } else {
            this.output("Fc.clazz = (*env)->GetObjectClass(env, lpObject);");
        }
        this.outputln();
        JNIField[] jNIFieldArray = clazz.getDeclaredFields();
        int n = jNIFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            JNIField field = jNIFieldArray[n2];
            if (!this.ignoreField(field)) {
                this.output("\t");
                this.output(clazzName);
                this.output("Fc.");
                this.output(field.getName());
                if (isCPP) {
                    this.output(" = env->GetFieldID(");
                } else {
                    this.output(" = (*env)->GetFieldID(env, ");
                }
                this.output(clazzName);
                this.output("Fc.clazz, \"");
                this.output(field.getName());
                JNIType type = field.getType();
                this.output("\", ");
                this.output("\"");
                this.output(type.getTypeSignature());
                this.output("\"");
                this.outputln(");");
            }
            ++n2;
        }
        this.output("\t");
        this.output(clazzName);
        this.outputln("Fc.cached = 1;");
        this.outputln("}");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void generateGetFields(JNIClass clazz) {
        JNIClass superclazz = clazz.getSuperclass();
        String clazzName = clazz.getSimpleName();
        String superName = superclazz.getSimpleName();
        if (!superclazz.getName().equals("java.lang.Object")) {
            if (!clazzName.equals(String.valueOf(superName) + "A") && !clazzName.equals(String.valueOf(superName) + "W")) {
                this.output("\tget");
                this.output(superName);
                this.output("Fields(env, lpObject, (");
                this.output(superName);
                this.outputln(" *)lpStruct);");
            } else {
                this.generateGetFields(superclazz);
            }
        }
        JNIField[] jNIFieldArray = clazz.getDeclaredFields();
        int n = jNIFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            JNIField field = jNIFieldArray[n2];
            if (!this.ignoreField(field)) {
                boolean noWinCE;
                String exclude = field.getExclude();
                if (exclude.length() != 0) {
                    this.outputln(exclude);
                }
                if (noWinCE = field.getFlag("no_wince")) {
                    this.outputln("#ifndef _WIN32_WCE");
                }
                JNIType type = field.getType();
                String typeName = type.getSimpleName();
                String accessor = field.getAccessor();
                if (accessor == null || accessor.length() == 0) {
                    accessor = field.getName();
                }
                boolean isCPP = this.getCPP();
                if (type.isPrimitive()) {
                    this.output("\tlpStruct->");
                    this.output(accessor);
                    this.output(" = ");
                    this.output(field.getCast());
                    if (isCPP) {
                        this.output("env->Get");
                    } else {
                        this.output("(*env)->Get");
                    }
                    this.output(type.getTypeSignature1());
                    if (isCPP) {
                        this.output("Field(lpObject, ");
                    } else {
                        this.output("Field(env, lpObject, ");
                    }
                    this.output(field.getDeclaringClass().getSimpleName());
                    this.output("Fc.");
                    this.output(field.getName());
                    this.output(");");
                } else if (type.isArray()) {
                    JNIType componentType = type.getComponentType();
                    if (!componentType.isPrimitive()) throw new Error("not done");
                    this.outputln("\t{");
                    this.output("\t");
                    this.output(type.getTypeSignature2());
                    this.output(" lpObject1 = (");
                    this.output(type.getTypeSignature2());
                    if (isCPP) {
                        this.output(")env->GetObjectField(lpObject, ");
                    } else {
                        this.output(")(*env)->GetObjectField(env, lpObject, ");
                    }
                    this.output(field.getDeclaringClass().getSimpleName());
                    this.output("Fc.");
                    this.output(field.getName());
                    this.outputln(");");
                    if (isCPP) {
                        this.output("\tenv->Get");
                    } else {
                        this.output("\t(*env)->Get");
                    }
                    this.output(componentType.getTypeSignature1());
                    if (isCPP) {
                        this.output("ArrayRegion(lpObject1, 0, sizeof(lpStruct->");
                    } else {
                        this.output("ArrayRegion(env, lpObject1, 0, sizeof(lpStruct->");
                    }
                    this.output(accessor);
                    this.output(")");
                    if (!componentType.isType("byte")) {
                        this.output(" / sizeof(");
                        this.output(componentType.getTypeSignature2());
                        this.output(")");
                    }
                    this.output(", (");
                    this.output(type.getTypeSignature4(false));
                    this.output(")");
                    if (field.getFlag("struct")) {
                        this.output("&");
                    }
                    this.output("lpStruct->");
                    this.output(accessor);
                    this.outputln(");");
                    this.output("\t}");
                } else {
                    this.outputln("\t{");
                    if (isCPP) {
                        this.output("\tjobject lpObject1 = env->GetObjectField(lpObject, ");
                    } else {
                        this.output("\tjobject lpObject1 = (*env)->GetObjectField(env, lpObject, ");
                    }
                    this.output(field.getDeclaringClass().getSimpleName());
                    this.output("Fc.");
                    this.output(field.getName());
                    this.outputln(");");
                    this.output("\tif (lpObject1 != NULL) get");
                    this.output(typeName);
                    this.output("Fields(env, lpObject1, &lpStruct->");
                    this.output(accessor);
                    this.outputln(");");
                    this.output("\t}");
                }
                this.outputln();
                if (noWinCE) {
                    this.outputln("#endif");
                }
                if (exclude.length() != 0) {
                    this.outputln("#endif");
                }
            }
            ++n2;
        }
    }

    void generateGetFunction(JNIClass clazz) {
        String clazzName = clazz.getSimpleName();
        if (clazz.getFlag("struct")) {
            this.output("struct ");
        }
        this.output(clazzName);
        this.output(" *get");
        this.output(clazzName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        if (clazz.getFlag("struct")) {
            this.output("struct ");
        }
        this.output(clazzName);
        this.outputln(" *lpStruct)");
        this.outputln("{");
        this.output("\tif (!");
        this.output(clazzName);
        this.output("Fc.cached) cache");
        this.output(clazzName);
        this.outputln("Fields(env, lpObject);");
        this.generateGetFields(clazz);
        this.outputln("\treturn lpStruct;");
        this.outputln("}");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void generateSetFields(JNIClass clazz) {
        JNIClass superclazz = clazz.getSuperclass();
        String clazzName = clazz.getSimpleName();
        String superName = superclazz.getSimpleName();
        if (!superclazz.getName().equals("java.lang.Object")) {
            if (!clazzName.equals(String.valueOf(superName) + "A") && !clazzName.equals(String.valueOf(superName) + "W")) {
                this.output("\tset");
                this.output(superName);
                this.output("Fields(env, lpObject, (");
                this.output(superName);
                this.outputln(" *)lpStruct);");
            } else {
                this.generateSetFields(superclazz);
            }
        }
        JNIField[] jNIFieldArray = clazz.getDeclaredFields();
        int n = jNIFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            JNIField field = jNIFieldArray[n2];
            if (!this.ignoreField(field)) {
                boolean noWinCE;
                String exclude = field.getExclude();
                if (exclude.length() != 0) {
                    this.outputln(exclude);
                }
                if (noWinCE = field.getFlag("no_wince")) {
                    this.outputln("#ifndef _WIN32_WCE");
                }
                JNIType type = field.getType();
                String typeName = type.getSimpleName();
                String accessor = field.getAccessor();
                if (accessor == null || accessor.length() == 0) {
                    accessor = field.getName();
                }
                boolean isCPP = this.getCPP();
                if (type.isPrimitive()) {
                    if (isCPP) {
                        this.output("\tenv->Set");
                    } else {
                        this.output("\t(*env)->Set");
                    }
                    this.output(type.getTypeSignature1());
                    if (isCPP) {
                        this.output("Field(lpObject, ");
                    } else {
                        this.output("Field(env, lpObject, ");
                    }
                    this.output(field.getDeclaringClass().getSimpleName());
                    this.output("Fc.");
                    this.output(field.getName());
                    this.output(", (");
                    this.output(type.getTypeSignature2());
                    this.output(")lpStruct->");
                    this.output(accessor);
                    this.output(");");
                } else if (type.isArray()) {
                    JNIType componentType = type.getComponentType();
                    if (!componentType.isPrimitive()) throw new Error("not done");
                    this.outputln("\t{");
                    this.output("\t");
                    this.output(type.getTypeSignature2());
                    this.output(" lpObject1 = (");
                    this.output(type.getTypeSignature2());
                    if (isCPP) {
                        this.output(")env->GetObjectField(lpObject, ");
                    } else {
                        this.output(")(*env)->GetObjectField(env, lpObject, ");
                    }
                    this.output(field.getDeclaringClass().getSimpleName());
                    this.output("Fc.");
                    this.output(field.getName());
                    this.outputln(");");
                    if (isCPP) {
                        this.output("\tenv->Set");
                    } else {
                        this.output("\t(*env)->Set");
                    }
                    this.output(componentType.getTypeSignature1());
                    if (isCPP) {
                        this.output("ArrayRegion(lpObject1, 0, sizeof(lpStruct->");
                    } else {
                        this.output("ArrayRegion(env, lpObject1, 0, sizeof(lpStruct->");
                    }
                    this.output(accessor);
                    this.output(")");
                    if (!componentType.isType("byte")) {
                        this.output(" / sizeof(");
                        this.output(componentType.getTypeSignature2());
                        this.output(")");
                    }
                    this.output(", (");
                    this.output(type.getTypeSignature4(false));
                    this.output(")");
                    if (field.getFlag("struct")) {
                        this.output("&");
                    }
                    this.output("lpStruct->");
                    this.output(accessor);
                    this.outputln(");");
                    this.output("\t}");
                } else {
                    this.outputln("\t{");
                    this.output("\tjobject lpObject1 = (*env)->GetObjectField(env, lpObject, ");
                    this.output(field.getDeclaringClass().getSimpleName());
                    this.output("Fc.");
                    this.output(field.getName());
                    this.outputln(");");
                    this.output("\tif (lpObject1 != NULL) set");
                    this.output(typeName);
                    this.output("Fields(env, lpObject1, &lpStruct->");
                    this.output(accessor);
                    this.outputln(");");
                    this.output("\t}");
                }
                this.outputln();
                if (noWinCE) {
                    this.outputln("#endif");
                }
                if (exclude.length() != 0) {
                    this.outputln("#endif");
                }
            }
            ++n2;
        }
    }

    void generateSetFunction(JNIClass clazz) {
        String clazzName = clazz.getSimpleName();
        this.output("void set");
        this.output(clazzName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        if (clazz.getFlag("struct")) {
            this.output("struct ");
        }
        this.output(clazzName);
        this.outputln(" *lpStruct)");
        this.outputln("{");
        this.output("\tif (!");
        this.output(clazzName);
        this.output("Fc.cached) cache");
        this.output(clazzName);
        this.outputln("Fields(env, lpObject);");
        this.generateSetFields(clazz);
        this.outputln("}");
    }

    void generateFunctions(JNIClass clazz) {
        this.generateCacheFunction(clazz);
        this.outputln();
        this.generateGetFunction(clazz);
        this.outputln();
        this.generateSetFunction(clazz);
    }

    boolean ignoreField(JNIField field) {
        int mods = field.getModifiers();
        return field.getFlag("no_gen") || (mods & 1) == 0 || (mods & 0x10) != 0 || (mods & 8) != 0;
    }
}

