/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import java.util.Set;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.planar.ICurve;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.parts.AbstractFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.DefaultFocusFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class FocusFeedbackPart
extends AbstractFeedbackPart<GeometryNode<IGeometry>> {
    private static final double DEFAULT_STROKE_WIDTH = 1.5;
    private Provider<? extends IGeometry> feedbackGeometryProvider;
    private ListChangeListener<IContentPart<? extends Node>> selectionModelObserver = new ListChangeListener<IContentPart<? extends Node>>(){

        public void onChanged(ListChangeListener.Change<? extends IContentPart<? extends Node>> c) {
            FocusFeedbackPart.this.refreshVisual();
        }
    };

    @Override
    protected void doActivate() {
        super.doActivate();
        SelectionModel selectionModel = (SelectionModel)((Object)this.getViewer().getAdapter(SelectionModel.class));
        selectionModel.selectionUnmodifiableProperty().addListener(this.selectionModelObserver);
    }

    @Override
    protected GeometryNode<IGeometry> doCreateVisual() {
        GeometryNode visual = new GeometryNode();
        visual.setFill((Paint)Color.TRANSPARENT);
        visual.setMouseTransparent(true);
        visual.setManaged(false);
        visual.setStrokeType(StrokeType.OUTSIDE);
        visual.setStrokeWidth(1.5);
        visual.setStroke((Paint)this.getFocusStroke());
        return visual;
    }

    @Override
    protected void doDeactivate() {
        SelectionModel selectionModel = (SelectionModel)((Object)this.getViewer().getAdapter(SelectionModel.class));
        selectionModel.selectionUnmodifiableProperty().removeListener(this.selectionModelObserver);
        super.doDeactivate();
    }

    @Override
    public void doRefreshVisual(GeometryNode<IGeometry> visual) {
        Set anchorages = this.getAnchoragesUnmodifiable().keySet();
        if (anchorages.isEmpty()) {
            return;
        }
        IVisualPart anchorage = (IVisualPart)anchorages.iterator().next();
        IRootPart<Node> root = anchorage.getRoot();
        if (root == null) {
            return;
        }
        IGeometry feedbackGeometry = this.getFeedbackGeometry();
        if (feedbackGeometry == null) {
            return;
        }
        IViewer viewer = root.getViewer();
        ObservableList<IContentPart<? extends Node>> selected = ((SelectionModel)((Object)viewer.getAdapter(SelectionModel.class))).getSelectionUnmodifiable();
        if (feedbackGeometry instanceof ICurve) {
            visual.setStrokeType(StrokeType.CENTERED);
            if (selected.contains(anchorage)) {
                visual.setStrokeWidth(3.0);
            } else {
                visual.setStrokeWidth(1.5);
            }
        } else {
            visual.setStrokeType(StrokeType.OUTSIDE);
        }
        visual.setGeometry(feedbackGeometry);
        if (!(feedbackGeometry instanceof ICurve) && selected.contains(anchorage)) {
            Rectangle feedbackBounds = feedbackGeometry.getBounds();
            visual.resizeGeometry(feedbackBounds.getWidth() + 3.0, feedbackBounds.getHeight() + 3.0);
            visual.relocateGeometry(feedbackBounds.getX() - 1.5, feedbackBounds.getY() - 1.5);
        }
    }

    protected IGeometry getFeedbackGeometry() {
        return NodeUtils.sceneToLocal((Node)((GeometryNode)this.getVisual()).getParent(), (IGeometry)((IGeometry)this.feedbackGeometryProvider.get()));
    }

    protected Color getFocusStroke() {
        Provider focusFeedbackColorProvider = (Provider)this.getViewer().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Color>>(){}, (String)"FOCUS_FEEDBACK_COLOR_PROVIDER"));
        return focusFeedbackColorProvider == null ? DefaultFocusFeedbackPartFactory.DEFAULT_FOCUS_FEEDBACK_COLOR : (Color)focusFeedbackColorProvider.get();
    }

    public void setGeometryProvider(Provider<? extends IGeometry> geometryProvider) {
        this.feedbackGeometryProvider = geometryProvider;
    }
}

