/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.configuration;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.CoreTraceScopes;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.configuration.BaseRunConfiguration;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.configuration.BuildConfigurationPersistence;
import org.eclipse.buildship.core.internal.configuration.ConfigurationManager;
import org.eclipse.buildship.core.internal.configuration.DefaultBuildConfiguration;
import org.eclipse.buildship.core.internal.configuration.DefaultBuildConfigurationProperties;
import org.eclipse.buildship.core.internal.configuration.DefaultProjectConfiguration;
import org.eclipse.buildship.core.internal.configuration.DefaultRunConfiguration;
import org.eclipse.buildship.core.internal.configuration.DefaultTestRunConfiguration;
import org.eclipse.buildship.core.internal.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.internal.configuration.RunConfiguration;
import org.eclipse.buildship.core.internal.configuration.RunConfigurationProperties;
import org.eclipse.buildship.core.internal.configuration.TestRunConfiguration;
import org.eclipse.buildship.core.internal.configuration.TestRunConfigurationProperties;
import org.eclipse.buildship.core.internal.configuration.WorkspaceConfiguration;
import org.eclipse.buildship.core.internal.configuration.WorkspaceConfigurationPersistence;
import org.eclipse.buildship.core.internal.launch.BaseRunConfigurationAttributes;
import org.eclipse.buildship.core.internal.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.internal.launch.GradleTestRunConfigurationAttributes;
import org.eclipse.buildship.core.internal.util.file.RelativePathUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;

public class DefaultConfigurationManager
implements ConfigurationManager {
    WorkspaceConfigurationPersistence workspaceConfigurationPersistence = new WorkspaceConfigurationPersistence();
    BuildConfigurationPersistence buildConfigurationPersistence = new BuildConfigurationPersistence();

    @Override
    public WorkspaceConfiguration loadWorkspaceConfiguration() {
        return this.workspaceConfigurationPersistence.readWorkspaceConfig();
    }

    @Override
    public void saveWorkspaceConfiguration(WorkspaceConfiguration config) {
        this.workspaceConfigurationPersistence.saveWorkspaceConfiguration(config);
    }

    @Override
    public BuildConfiguration createBuildConfiguration(File rootProjectDirectory, boolean overrideWorkspaceSettings, GradleDistribution gradleDistribution, File gradleUserHome, File javaHome, boolean buildScansEnabled, boolean offlineMode, boolean autoSync, List<String> arguments, List<String> jvmArguments, boolean showConsoleView, boolean showExecutionsView) {
        DefaultBuildConfigurationProperties persistentBuildConfigProperties = new DefaultBuildConfigurationProperties(rootProjectDirectory, gradleDistribution, gradleUserHome, javaHome, overrideWorkspaceSettings, buildScansEnabled, offlineMode, autoSync, arguments, jvmArguments, showConsoleView, showExecutionsView);
        return new DefaultBuildConfiguration(persistentBuildConfigProperties, this.loadWorkspaceConfiguration());
    }

    @Override
    public BuildConfiguration loadBuildConfiguration(File rootDir) {
        DefaultBuildConfigurationProperties buildConfigProperties;
        Preconditions.checkNotNull((Object)rootDir);
        Preconditions.checkArgument((boolean)rootDir.exists());
        Optional<IProject> projectCandidate = CorePlugin.workspaceOperations().findProjectByLocation(rootDir);
        if (projectCandidate.isPresent() && ((IProject)projectCandidate.get()).isAccessible()) {
            IProject project = (IProject)projectCandidate.get();
            try {
                buildConfigProperties = this.buildConfigurationPersistence.readBuildConfiguratonProperties(project);
            }
            catch (Exception e) {
                buildConfigProperties = this.buildConfigurationPersistence.readBuildConfiguratonProperties(project.getLocation().toFile());
            }
        } else {
            buildConfigProperties = this.buildConfigurationPersistence.readBuildConfiguratonProperties(rootDir);
        }
        return new DefaultBuildConfiguration(buildConfigProperties, this.loadWorkspaceConfiguration());
    }

    @Override
    public void saveBuildConfiguration(BuildConfiguration configuration) {
        Preconditions.checkArgument((boolean)(configuration instanceof DefaultBuildConfiguration), (String)"Unknow configuration type: ", configuration.getClass());
        DefaultBuildConfigurationProperties properties = ((DefaultBuildConfiguration)configuration).getProperties();
        File rootDir = configuration.getRootProjectDirectory();
        Optional<IProject> rootProject = CorePlugin.workspaceOperations().findProjectByLocation(rootDir);
        if (rootProject.isPresent() && ((IProject)rootProject.get()).isAccessible()) {
            this.buildConfigurationPersistence.saveBuildConfiguration((IProject)rootProject.get(), properties);
        } else {
            this.buildConfigurationPersistence.saveBuildConfiguration(rootDir, properties);
        }
    }

    @Override
    public ProjectConfiguration createProjectConfiguration(BuildConfiguration configuration, File projectDir) {
        return new DefaultProjectConfiguration(projectDir, configuration);
    }

    @Override
    public ProjectConfiguration loadProjectConfiguration(IProject project) {
        String pathToRoot = this.buildConfigurationPersistence.readPathToRoot(project.getLocation().toFile());
        File rootDir = DefaultConfigurationManager.relativePathToProjectRoot(project.getLocation(), pathToRoot);
        BuildConfiguration buildConfig = this.loadBuildConfiguration(rootDir);
        return new DefaultProjectConfiguration(project.getLocation().toFile(), buildConfig);
    }

    @Override
    public ProjectConfiguration tryLoadProjectConfiguration(IProject project) {
        try {
            return this.loadProjectConfiguration(project);
        }
        catch (RuntimeException e) {
            CorePlugin.logger().trace(CoreTraceScopes.PREFERENCES, "Cannot load configuration for project " + project.getName(), e);
            return null;
        }
    }

    private ProjectConfiguration loadProjectConfiguration(File projectDir) {
        String pathToRoot = this.buildConfigurationPersistence.readPathToRoot(projectDir);
        File rootDir = DefaultConfigurationManager.relativePathToProjectRoot((IPath)new Path(projectDir.getAbsolutePath()), pathToRoot);
        BuildConfiguration buildConfig = this.loadBuildConfiguration(rootDir);
        return new DefaultProjectConfiguration(DefaultConfigurationManager.canonicalize(projectDir), buildConfig);
    }

    @Override
    public void saveProjectConfiguration(ProjectConfiguration projectConfiguration) {
        BuildConfiguration buildConfiguration = projectConfiguration.getBuildConfiguration();
        this.saveBuildConfiguration(buildConfiguration);
        File projectDir = projectConfiguration.getProjectDir();
        File rootDir = buildConfiguration.getRootProjectDirectory();
        String pathToRoot = DefaultConfigurationManager.projectRootToRelativePath(projectDir, rootDir);
        Optional<IProject> project = CorePlugin.workspaceOperations().findProjectByLocation(projectDir);
        if (project.isPresent() && ((IProject)project.get()).isAccessible()) {
            this.buildConfigurationPersistence.savePathToRoot((IProject)project.get(), pathToRoot);
        } else {
            this.buildConfigurationPersistence.savePathToRoot(projectDir, pathToRoot);
        }
    }

    @Override
    public void deleteProjectConfiguration(IProject project) {
        if (project.isAccessible()) {
            this.buildConfigurationPersistence.deletePathToRoot(project);
        } else {
            this.buildConfigurationPersistence.deletePathToRoot(project.getLocation().toFile());
        }
    }

    @Override
    public RunConfiguration loadRunConfiguration(ILaunchConfiguration launchConfiguration) {
        GradleRunConfigurationAttributes attributes = GradleRunConfigurationAttributes.from(launchConfiguration);
        ProjectConfiguration projectConfiguration = this.loadProjectConfiguration(attributes);
        RunConfigurationProperties runConfigProperties = new RunConfigurationProperties((List<String>)attributes.getTasks(), attributes.getGradleDistribution(), attributes.getGradleUserHome(), attributes.getJavaHome(), (List<String>)attributes.getJvmArguments(), (List<String>)attributes.getArguments(), attributes.isShowConsoleView(), attributes.isShowExecutionView(), attributes.isOverrideBuildSettings(), attributes.isBuildScansEnabled(), attributes.isOffline());
        return new DefaultRunConfiguration(projectConfiguration, runConfigProperties);
    }

    @Override
    public TestRunConfiguration loadTestRunConfiguration(ILaunchConfiguration launchConfiguration) {
        GradleTestRunConfigurationAttributes attributes = GradleTestRunConfigurationAttributes.from(launchConfiguration);
        ProjectConfiguration projectConfiguration = this.loadProjectConfiguration(attributes);
        TestRunConfigurationProperties runConfigProperties = new TestRunConfigurationProperties(attributes.getGradleDistribution(), attributes.getGradleUserHome(), attributes.getJavaHome(), (List<String>)attributes.getJvmArguments(), (List<String>)attributes.getArguments(), attributes.isShowConsoleView(), attributes.isShowExecutionView(), attributes.isOverrideBuildSettings(), attributes.isBuildScansEnabled(), attributes.isOffline(), attributes.getTests());
        return new DefaultTestRunConfiguration(projectConfiguration, runConfigProperties);
    }

    private ProjectConfiguration loadProjectConfiguration(BaseRunConfigurationAttributes attributes) {
        ProjectConfiguration projectConfiguration;
        try {
            projectConfiguration = this.loadProjectConfiguration(attributes.getWorkingDir());
        }
        catch (Exception e) {
            CorePlugin.logger().trace(CoreTraceScopes.PREFERENCES, "Can't load build config from " + attributes.getWorkingDir(), e);
            DefaultBuildConfigurationProperties buildConfigProperties = new DefaultBuildConfigurationProperties(attributes.getWorkingDir(), attributes.getGradleDistribution(), attributes.getGradleUserHome(), attributes.getJavaHome(), attributes.isOverrideBuildSettings(), attributes.isBuildScansEnabled(), attributes.isOffline(), false, (List<String>)attributes.getArguments(), (List<String>)attributes.getJvmArguments(), attributes.isShowConsoleView(), attributes.isShowExecutionView());
            DefaultBuildConfiguration buildConfiguration = new DefaultBuildConfiguration(buildConfigProperties, this.loadWorkspaceConfiguration());
            projectConfiguration = new DefaultProjectConfiguration(DefaultConfigurationManager.canonicalize(attributes.getWorkingDir()), buildConfiguration);
        }
        return projectConfiguration;
    }

    @Override
    public TestRunConfiguration loadTestRunConfiguration(BaseRunConfiguration runConfig) {
        if (runConfig instanceof TestRunConfiguration) {
            return (TestRunConfiguration)runConfig;
        }
        if (runConfig instanceof DefaultRunConfiguration) {
            DefaultRunConfiguration source = (DefaultRunConfiguration)runConfig;
            RunConfigurationProperties props = source.getProperties();
            TestRunConfigurationProperties properties = new TestRunConfigurationProperties(props.getGradleDistribution(), props.getGradleUserHome(), props.getJavaHome(), props.getJvmArguments(), props.getArguments(), props.isShowConsoleView(), props.isShowExecutionView(), props.isOverrideBuildSettings(), props.isBuildScansEnabled(), props.isOfflineMode(), Collections.emptyList());
            return new DefaultTestRunConfiguration(source.getProjectConfiguration(), properties);
        }
        throw new GradlePluginsRuntimeException("Unknown configuration type: " + runConfig.getClass().getSimpleName());
    }

    @Override
    public RunConfiguration createDefaultRunConfiguration(BuildConfiguration configuration) {
        Preconditions.checkArgument((boolean)(configuration instanceof DefaultBuildConfiguration), (String)"Unknow configuration type: ", configuration.getClass());
        DefaultProjectConfiguration projectConfiguration = new DefaultProjectConfiguration(configuration.getRootProjectDirectory(), configuration);
        RunConfigurationProperties runConfig = new RunConfigurationProperties(Collections.emptyList(), GradleDistribution.fromBuild(), null, null, Collections.emptyList(), Collections.emptyList(), false, false, false, false, false);
        return new DefaultRunConfiguration((ProjectConfiguration)projectConfiguration, runConfig);
    }

    private static File relativePathToProjectRoot(IPath projectPath, String path) {
        Path pathToRoot = new Path(path);
        Path absolutePathToRoot = pathToRoot.isAbsolute() ? pathToRoot : RelativePathUtils.getAbsolutePath(projectPath, (IPath)pathToRoot);
        return DefaultConfigurationManager.canonicalize(absolutePathToRoot.toFile());
    }

    private static File canonicalize(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String projectRootToRelativePath(File projectDir, File rootDir) {
        Path rootProjectPath = new Path(rootDir.getPath());
        Path projectPath = new Path(projectDir.getPath());
        return RelativePathUtils.getRelativePath((IPath)projectPath, (IPath)rootProjectPath).toPortableString();
    }
}

