/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.palette;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.bpel.common.ui.palette.IOrderedPaletteEntry;
import org.eclipse.bpel.common.ui.palette.IPaletteProvider;
import org.eclipse.bpel.common.ui.palette.PaletteCategory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;

public abstract class GraphicalEditorWithPalette
extends GraphicalEditorWithFlyoutPalette {
    static final String EXTPT_PALETTE_ADDITIONS = "paletteAdditions";
    static final String ELEMENT_ADDITIONS = "additions";
    static final String ATT_PROVIDER = "provider";
    static final String ATT_IMPORTANCE = "importance";
    static final String ATT_CLASS = "class";
    static final String ATT_DEFAULT = "default";
    static final String ATT_CATEGORY = "category";
    static final String ATT_CATEGORY_ID = "categoryId";
    static final String ATT_CATEGORY_ORDER = "categoryOrder";
    static final String ATT_TARGET_EDITOR = "targetEditor";
    private PaletteRoot paletteRoot;

    public void dispose() {
        super.dispose();
        this.paletteRoot = null;
    }

    protected GraphicalEditorWithFlyoutPalette.CustomPalettePage createPalettePage() {
        return new GraphicalEditorWithFlyoutPalette.CustomPalettePage(this, this.getPaletteViewerProvider()){

            public void init(IPageSite pageSite) {
                super.init(pageSite);
                IAction copy = GraphicalEditorWithPalette.this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
                pageSite.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), copy);
            }
        };
    }

    protected ActionRegistry getActionRegistry() {
        return super.getActionRegistry();
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                GraphicalEditorWithPalette.this.updateActions(GraphicalEditorWithPalette.this.getSelectionActions());
            }
        });
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = new PaletteRoot();
            this.createPalette();
        }
        return this.paletteRoot;
    }

    HashMap<String, IOrderedPaletteEntry> paletteContainers() {
        HashMap<String, IOrderedPaletteEntry> map = new HashMap<String, IOrderedPaletteEntry>();
        for (Object next : this.paletteRoot.getChildren()) {
            if (!(next instanceof IOrderedPaletteEntry)) continue;
            IOrderedPaletteEntry entry = (IOrderedPaletteEntry)next;
            map.put(entry.getCategoryId(), entry);
        }
        return map;
    }

    protected String getPaletteAdditionsContributorId() {
        return this.getEditorSite().getId();
    }

    protected void createPalette() {
        String id = this.getPaletteAdditionsContributorId();
        ArrayList<IConfigurationElement> listOfAdditions = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = this.getConfigurationElements(EXTPT_PALETTE_ADDITIONS);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement additions = iConfigurationElementArray[n2];
            if (additions.getName().equals(ELEMENT_ADDITIONS) && id.equals(additions.getAttribute(ATT_TARGET_EDITOR))) {
                listOfAdditions.add(additions);
            }
            ++n2;
        }
        Collections.sort(listOfAdditions, new Comparator<IConfigurationElement>(){

            int getInt(String n) {
                try {
                    return Integer.parseInt(n);
                }
                catch (Throwable throwable) {
                    return 10;
                }
            }

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                return this.getInt(o1.getAttribute(GraphicalEditorWithPalette.ATT_IMPORTANCE)) - this.getInt(o2.getAttribute(GraphicalEditorWithPalette.ATT_IMPORTANCE));
            }
        });
        HashMap<String, IOrderedPaletteEntry> containerMap = null;
        for (IConfigurationElement additions : listOfAdditions) {
            String provider = additions.getAttribute(ATT_PROVIDER);
            if (provider != null) {
                try {
                    IPaletteProvider entry = (IPaletteProvider)additions.createExecutableExtension(ATT_PROVIDER);
                    entry.contributeItems(this.paletteRoot);
                    containerMap = null;
                }
                catch (CoreException ce) {
                    CommonUIPlugin.getDefault().getLog().log(ce.getStatus());
                }
            }
            if (containerMap == null) {
                containerMap = this.paletteContainers();
            }
            IConfigurationElement[] iConfigurationElementArray2 = additions.getChildren();
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement addition = iConfigurationElementArray2[n4];
                String def = addition.getAttribute(ATT_DEFAULT);
                String categoryName = addition.getAttribute(ATT_CATEGORY);
                String categoryId = addition.getAttribute(ATT_CATEGORY_ID);
                int categoryOrder = 100;
                try {
                    categoryOrder = Math.abs(Integer.parseInt(addition.getAttribute(ATT_CATEGORY_ORDER)));
                }
                catch (Throwable throwable) {
                    categoryOrder = 100;
                }
                if (categoryId == null) {
                    categoryId = "bpel.user";
                }
                PaletteCategory container = null;
                PaletteCategory category = null;
                IOrderedPaletteEntry orderedContainer = containerMap.get(categoryId);
                if (orderedContainer == null) {
                    container = category = new PaletteCategory(categoryName);
                    category.setOrder(categoryOrder);
                    category.setCategoryId(categoryId);
                    containerMap.put(categoryId, category);
                    this.paletteRoot.add((PaletteEntry)container);
                } else if (orderedContainer instanceof PaletteCategory) {
                    container = category = (PaletteCategory)orderedContainer;
                } else if (orderedContainer instanceof PaletteContainer) {
                    container = (PaletteContainer)orderedContainer;
                }
                try {
                    ToolEntry entry = (ToolEntry)addition.createExecutableExtension(ATT_CLASS);
                    if (container != null) {
                        container.add((PaletteEntry)entry);
                    }
                    if (def != null && def.equals("true") && category != null) {
                        category.setDefaultTool(entry);
                    }
                }
                catch (CoreException e) {
                    CommonUIPlugin.getDefault().getLog().log(e.getStatus());
                }
                ++n4;
            }
        }
        Collections.sort(this.paletteRoot.getChildren(), new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    IOrderedPaletteEntry e1 = (IOrderedPaletteEntry)o1;
                    IOrderedPaletteEntry e2 = (IOrderedPaletteEntry)o2;
                    return e1.getOrder() - e2.getOrder();
                }
                catch (Throwable throwable) {
                    return 0;
                }
            }
        });
    }

    private IConfigurationElement[] getConfigurationElements(String extensionPointId) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.bpel.common.ui", extensionPointId);
        if (extensionPoint == null) {
            return new IConfigurationElement[0];
        }
        return extensionPoint.getConfigurationElements();
    }
}

