/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.Resources;

final class ImmutableResources
implements Resources {
    @Nullable
    private final Long nanoCpus;
    @Nullable
    private final Long memoryBytes;

    private ImmutableResources(@Nullable Long nanoCpus, @Nullable Long memoryBytes) {
        this.nanoCpus = nanoCpus;
        this.memoryBytes = memoryBytes;
    }

    @Override
    @JsonProperty(value="NanoCPUs")
    @Nullable
    public Long nanoCpus() {
        return this.nanoCpus;
    }

    @Override
    @JsonProperty(value="MemoryBytes")
    @Nullable
    public Long memoryBytes() {
        return this.memoryBytes;
    }

    public final ImmutableResources withNanoCpus(@Nullable Long value) {
        if (Objects.equals(this.nanoCpus, value)) {
            return this;
        }
        return new ImmutableResources(value, this.memoryBytes);
    }

    public final ImmutableResources withMemoryBytes(@Nullable Long value) {
        if (Objects.equals(this.memoryBytes, value)) {
            return this;
        }
        return new ImmutableResources(this.nanoCpus, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResources && this.equalTo((ImmutableResources)another);
    }

    private boolean equalTo(ImmutableResources another) {
        return Objects.equals(this.nanoCpus, another.nanoCpus) && Objects.equals(this.memoryBytes, another.memoryBytes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.nanoCpus);
        h += (h << 5) + Objects.hashCode(this.memoryBytes);
        return h;
    }

    public String toString() {
        return "Resources{nanoCpus=" + this.nanoCpus + ", memoryBytes=" + this.memoryBytes + "}";
    }

    public static ImmutableResources copyOf(Resources instance) {
        if (instance instanceof ImmutableResources) {
            return (ImmutableResources)instance;
        }
        return ImmutableResources.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements Resources.Builder {
        private Long nanoCpus;
        private Long memoryBytes;

        private Builder() {
        }

        public final Builder from(Resources instance) {
            Long memoryBytesValue;
            Objects.requireNonNull(instance, "instance");
            Long nanoCpusValue = instance.nanoCpus();
            if (nanoCpusValue != null) {
                this.nanoCpus(nanoCpusValue);
            }
            if ((memoryBytesValue = instance.memoryBytes()) != null) {
                this.memoryBytes(memoryBytesValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="NanoCPUs")
        public final Builder nanoCpus(@Nullable Long nanoCpus) {
            this.nanoCpus = nanoCpus;
            return this;
        }

        @Override
        @JsonProperty(value="MemoryBytes")
        public final Builder memoryBytes(@Nullable Long memoryBytes) {
            this.memoryBytes = memoryBytes;
            return this;
        }

        @Override
        public ImmutableResources build() {
            return new ImmutableResources(this.nanoCpus, this.memoryBytes);
        }
    }
}

