/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.EndpointSpec;
import org.mandas.docker.client.messages.swarm.PortConfig;

final class ImmutableEndpointSpec
implements EndpointSpec {
    @Nullable
    private final EndpointSpec.Mode mode;
    private final List<PortConfig> ports;
    private final transient EndpointSpec.Builder toBuilder;

    private ImmutableEndpointSpec(@Nullable EndpointSpec.Mode mode, List<PortConfig> ports) {
        this.mode = mode;
        this.ports = ports;
        this.toBuilder = Objects.requireNonNull(EndpointSpec.super.toBuilder(), "toBuilder");
    }

    @Override
    @JsonProperty(value="Mode")
    @Nullable
    public EndpointSpec.Mode mode() {
        return this.mode;
    }

    @Override
    @JsonProperty(value="Ports")
    public List<PortConfig> ports() {
        return this.ports;
    }

    @Override
    @JsonProperty(value="toBuilder")
    @JsonIgnore
    public EndpointSpec.Builder toBuilder() {
        return this.toBuilder;
    }

    public final ImmutableEndpointSpec withMode(@Nullable EndpointSpec.Mode value) {
        if (this.mode == value) {
            return this;
        }
        if (Objects.equals((Object)this.mode, (Object)value)) {
            return this;
        }
        return new ImmutableEndpointSpec(value, this.ports);
    }

    public final ImmutableEndpointSpec withPorts(PortConfig ... elements) {
        List<PortConfig> newValue = ImmutableEndpointSpec.createUnmodifiableList(false, ImmutableEndpointSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEndpointSpec(this.mode, newValue);
    }

    public final ImmutableEndpointSpec withPorts(Iterable<? extends PortConfig> elements) {
        if (this.ports == elements) {
            return this;
        }
        List<PortConfig> newValue = ImmutableEndpointSpec.createUnmodifiableList(false, ImmutableEndpointSpec.createSafeList(elements, true, false));
        return new ImmutableEndpointSpec(this.mode, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEndpointSpec && this.equalTo((ImmutableEndpointSpec)another);
    }

    private boolean equalTo(ImmutableEndpointSpec another) {
        return Objects.equals((Object)this.mode, (Object)another.mode) && this.ports.equals(another.ports);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.mode);
        h += (h << 5) + this.ports.hashCode();
        return h;
    }

    public String toString() {
        return "EndpointSpec{mode=" + (Object)((Object)this.mode) + ", ports=" + this.ports + "}";
    }

    public static ImmutableEndpointSpec copyOf(EndpointSpec instance) {
        if (instance instanceof ImmutableEndpointSpec) {
            return (ImmutableEndpointSpec)instance;
        }
        return ImmutableEndpointSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder
    implements EndpointSpec.Builder {
        private EndpointSpec.Mode mode;
        private List<PortConfig> ports = new ArrayList<PortConfig>();

        private Builder() {
        }

        public final Builder from(EndpointSpec instance) {
            Objects.requireNonNull(instance, "instance");
            EndpointSpec.Mode modeValue = instance.mode();
            if (modeValue != null) {
                this.mode(modeValue);
            }
            this.addAllPorts(instance.ports());
            return this;
        }

        @Override
        @JsonProperty(value="Mode")
        public final Builder mode(@Nullable EndpointSpec.Mode mode) {
            this.mode = mode;
            return this;
        }

        public final Builder port(PortConfig element) {
            this.ports.add(Objects.requireNonNull(element, "ports element"));
            return this;
        }

        @Override
        public final Builder ports(PortConfig ... elements) {
            for (PortConfig element : elements) {
                this.ports.add(Objects.requireNonNull(element, "ports element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Ports")
        public final Builder ports(Iterable<? extends PortConfig> elements) {
            this.ports.clear();
            return this.addAllPorts(elements);
        }

        public final Builder addAllPorts(Iterable<? extends PortConfig> elements) {
            for (PortConfig portConfig : elements) {
                this.ports.add(Objects.requireNonNull(portConfig, "ports element"));
            }
            return this;
        }

        @Override
        public ImmutableEndpointSpec build() {
            return new ImmutableEndpointSpec(this.mode, ImmutableEndpointSpec.createUnmodifiableList(true, this.ports));
        }
    }
}

