/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.ObjectMapperProvider;
import org.mandas.docker.client.messages.EndpointConfig;
import org.mandas.docker.client.messages.HostConfig;
import org.mandas.docker.client.messages.ImmutableContainerConfig;

@JsonDeserialize(builder=ImmutableContainerConfig.Builder.class)
@Value.Immutable
@Value.Enclosing
public interface ContainerConfig {
    @JsonProperty(value="Hostname")
    @Nullable
    public String hostname();

    @JsonProperty(value="Domainname")
    @Nullable
    public String domainname();

    @JsonProperty(value="User")
    @Nullable
    public String user();

    @JsonProperty(value="AttachStdin")
    @Nullable
    public Boolean attachStdin();

    @JsonProperty(value="AttachStdout")
    @Nullable
    public Boolean attachStdout();

    @JsonProperty(value="AttachStderr")
    @Nullable
    public Boolean attachStderr();

    @JsonProperty(value="PortSpecs")
    @Nullable
    public List<String> portSpecs();

    @JsonProperty(value="ExposedPorts")
    @JsonSerialize(using=ObjectMapperProvider.SetSerializer.class)
    @JsonDeserialize(using=ObjectMapperProvider.SetDeserializer.class)
    @Nullable
    public Set<String> exposedPorts();

    @JsonProperty(value="Tty")
    @Nullable
    public Boolean tty();

    @JsonProperty(value="OpenStdin")
    @Nullable
    public Boolean openStdin();

    @JsonProperty(value="StdinOnce")
    @Nullable
    public Boolean stdinOnce();

    @JsonProperty(value="Env")
    @Nullable
    public List<String> env();

    @JsonProperty(value="Cmd")
    @Nullable
    public List<String> cmd();

    @JsonProperty(value="Image")
    @Nullable
    public String image();

    @JsonProperty(value="Volumes")
    @JsonSerialize(using=ObjectMapperProvider.SetSerializer.class)
    @JsonDeserialize(using=ObjectMapperProvider.SetDeserializer.class)
    @Nullable
    public Set<String> volumes();

    @JsonProperty(value="WorkingDir")
    @Nullable
    public String workingDir();

    @JsonProperty(value="Entrypoint")
    @Nullable
    public List<String> entrypoint();

    @JsonProperty(value="NetworkDisabled")
    @Nullable
    public Boolean networkDisabled();

    @JsonProperty(value="OnBuild")
    @Nullable
    public List<String> onBuild();

    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels();

    @JsonProperty(value="MacAddress")
    @Nullable
    public String macAddress();

    @JsonProperty(value="HostConfig")
    @Nullable
    public HostConfig hostConfig();

    @JsonProperty(value="StopSignal")
    @Nullable
    public String stopSignal();

    @JsonProperty(value="Healthcheck")
    @Nullable
    public Healthcheck healthcheck();

    @JsonProperty(value="NetworkingConfig")
    @Nullable
    public NetworkingConfig networkingConfig();

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public Builder toBuilder() {
        return ImmutableContainerConfig.builder().from(this);
    }

    public static Builder builder() {
        return ImmutableContainerConfig.builder();
    }

    public static interface Builder {
        public Builder hostname(String var1);

        public Builder domainname(String var1);

        public Builder user(String var1);

        public Builder attachStdin(Boolean var1);

        public Builder attachStdout(Boolean var1);

        public Builder attachStderr(Boolean var1);

        public Builder portSpecs(Iterable<String> var1);

        public Builder portSpecs(String ... var1);

        public Builder exposedPorts(Iterable<String> var1);

        public Builder exposedPorts(String ... var1);

        public Builder tty(Boolean var1);

        public Builder openStdin(Boolean var1);

        public Builder stdinOnce(Boolean var1);

        public Builder env(Iterable<String> var1);

        public Builder env(String ... var1);

        public Builder cmd(Iterable<String> var1);

        public Builder cmd(String ... var1);

        public Builder image(String var1);

        default public Builder addVolume(String volume) {
            this.volumes(volume);
            return this;
        }

        default public Builder addVolumes(String ... volumes) {
            this.volumes(volumes);
            return this;
        }

        public Builder volumes(Iterable<String> var1);

        public Builder volumes(String ... var1);

        public Builder workingDir(String var1);

        public Builder entrypoint(Iterable<String> var1);

        public Builder entrypoint(String ... var1);

        public Builder networkDisabled(Boolean var1);

        public Builder onBuild(Iterable<String> var1);

        public Builder onBuild(String ... var1);

        public Builder labels(Map<String, ? extends String> var1);

        public Builder macAddress(String var1);

        public Builder hostConfig(HostConfig var1);

        public Builder stopSignal(String var1);

        public Builder healthcheck(Healthcheck var1);

        public Builder networkingConfig(NetworkingConfig var1);

        public ContainerConfig build();
    }

    @JsonDeserialize(builder=ImmutableContainerConfig.Healthcheck.Builder.class)
    @Value.Immutable
    public static interface Healthcheck {
        @JsonProperty(value="Test")
        @Nullable
        public List<String> test();

        @JsonProperty(value="Interval")
        @Nullable
        public Long interval();

        @JsonProperty(value="Timeout")
        @Nullable
        public Long timeout();

        @JsonProperty(value="Retries")
        @Nullable
        public Integer retries();

        @JsonProperty(value="StartPeriod")
        @Nullable
        public Long startPeriod();

        public static Healthcheck create(List<String> test, Long interval, Long timeout, Integer retries) {
            return Healthcheck.create(test, interval, timeout, retries, null);
        }

        public static Healthcheck create(List<String> test, Long interval, Long timeout, Integer retries, Long startPeriod) {
            return Healthcheck.builder().test(test).interval(interval).timeout(timeout).retries(retries).startPeriod(startPeriod).build();
        }

        public static Builder builder() {
            return ImmutableContainerConfig.Healthcheck.builder();
        }

        public static interface Builder {
            public Builder test(Iterable<String> var1);

            public Builder interval(Long var1);

            public Builder timeout(Long var1);

            public Builder retries(Integer var1);

            public Builder startPeriod(Long var1);

            public Healthcheck build();
        }
    }

    @JsonDeserialize(builder=ImmutableContainerConfig.NetworkingConfig.Builder.class)
    @Value.Immutable
    public static interface NetworkingConfig {
        @JsonProperty(value="EndpointsConfig")
        public Map<String, EndpointConfig> endpointsConfig();
    }
}

