/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.link;

import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.handler.LinkHandler;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.widgets.AbstractControl;
import org.eclipse.swt.widgets.Link;
import org.hamcrest.Matcher;

public abstract class AbstractLink
extends AbstractControl<Link>
implements org.eclipse.reddeer.swt.api.Link {
    private static final Logger logger = Logger.getLogger(AbstractLink.class);

    protected AbstractLink(ReferencedComposite refComposite, int index, Matcher<?> ... matchers) {
        super(Link.class, refComposite, index, matchers);
    }

    protected AbstractLink(Link widget) {
        super(widget);
    }

    @Override
    public String getText() {
        return LinkHandler.getInstance().getText((Link)this.swtWidget);
    }

    @Override
    public List<String> getAnchorTexts() {
        return LinkHandler.getInstance().getAnchorTexts((Link)this.swtWidget);
    }

    @Override
    public void click(String text) {
        this.click(text, 0);
    }

    public void click(String text, int index) {
        logger.info("Click link with text '" + text + "' and index " + index);
        String eventText = LinkHandler.getInstance().getEventText((Link)this.swtWidget, text, index);
        logger.info("Click link's text '" + eventText + "'");
        LinkHandler.getInstance().activate((Link)this.swtWidget, eventText);
    }

    @Override
    public void click() {
        this.click(0);
    }

    @Override
    public void click(int index) {
        logger.info("Click link with index " + index);
        String eventText = LinkHandler.getInstance().getEventText((Link)this.swtWidget, index);
        logger.info("Click link's text '" + eventText + "'");
        LinkHandler.getInstance().activate((Link)this.swtWidget, eventText);
    }
}

