/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.jsf.internal.configurators;

import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.facets.AbstractFacetDetector;
import org.eclipse.m2e.wtp.jsf.internal.MavenJSFConstants;
import org.eclipse.m2e.wtp.jsf.internal.Messages;
import org.eclipse.m2e.wtp.jsf.internal.utils.JSFUtils;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebXmlJSFFacetDetector
extends AbstractFacetDetector {
    private static final Logger LOG = LoggerFactory.getLogger(WebXmlJSFFacetDetector.class);

    public IProjectFacetVersion findFacetVersion(IMavenProjectFacade mavenProjectFacade, Map<?, ?> context, IProgressMonitor monitor) throws CoreException {
        IProject project = mavenProjectFacade.getProject();
        if (project == null) {
            return null;
        }
        MavenProject mavenProject = mavenProjectFacade.getMavenProject(monitor);
        if (mavenProject == null) {
            return null;
        }
        IProjectFacetVersion version = null;
        if (this.hasFacesServletInWebXml(mavenProject, project)) {
            try {
                IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
                if (fproj != null) {
                    IProjectFacetVersion webVersion = fproj.getInstalledVersion(IJ2EEFacetConstants.DYNAMIC_WEB_FACET);
                    version = webVersion.compareTo((Object)IJ2EEFacetConstants.DYNAMIC_WEB_30) < 0 ? MavenJSFConstants.JSF_FACET_VERSION_1_2 : MavenJSFConstants.JSF_FACET_VERSION_2_0;
                }
            }
            catch (CoreException e) {
                LOG.error(Messages.WebXmlJSFFacetDetector_Error_Cant_Detect_JSF_From_WebXml, (Throwable)e);
            }
        }
        return version;
    }

    private boolean hasFacesServletInWebXml(MavenProject mavenProject, IProject project) {
        IFile webXml = ProjectUtils.getWebResourceFile((IProject)project, (String)"WEB-INF/web.xml");
        return webXml != null && webXml.exists() && JSFUtils.hasFacesServlet(webXml);
    }
}

