/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.project;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.internal.Messages;

public class OutOfDateConfigurationDeltaVisitor
implements IResourceDeltaVisitor {
    List<IProject> outOfDateProjects = new ArrayList<IProject>();

    public boolean visit(IResourceDelta delta) throws CoreException {
        switch (delta.getKind()) {
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x20000) != 0) {
                    IResource res = delta.getResource();
                    if (res == null) {
                        return true;
                    }
                    IProject project = res.getProject();
                    if (project == null || !this.isMavenProject(project) || this.outOfDateProjects.contains(project)) {
                        return false;
                    }
                    IMarkerDelta[] markers = delta.getMarkerDeltas();
                    boolean hasOutOfDateMarker = this.containsOutOfDateMarkers(markers);
                    if (hasOutOfDateMarker) {
                        this.outOfDateProjects.add(project);
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean containsOutOfDateMarkers(IMarkerDelta[] markers) throws CoreException {
        if (markers != null && markers.length > 0) {
            IMarkerDelta[] iMarkerDeltaArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                String message;
                IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                IMarker marker = markerDelta.getMarker();
                if (marker.exists() && Messages.ProjectConfigurationUpdateRequired.equals(message = (String)marker.getAttribute("message"))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean isMavenProject(IProject project) throws CoreException {
        return project != null && project.isAccessible() && project.hasNature("org.eclipse.m2e.core.maven2Nature");
    }
}

