/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences.launch;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.eclipse.m2e.core.internal.launch.MavenRuntimeManagerImpl;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.preferences.launch.MavenInstallationWizard;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class MavenInstallationsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    final MavenRuntimeManagerImpl runtimeManager;
    final IMavenConfiguration mavenConfiguration;
    final IMaven maven;
    String defaultRuntime;
    List<AbstractMavenRuntime> runtimes;
    CheckboxTableViewer runtimesViewer;

    public MavenInstallationsPreferencePage() {
        this.setTitle(Messages.MavenInstallationsPreferencePage_title);
        this.runtimeManager = MavenPluginActivator.getDefault().getMavenRuntimeManager();
        this.mavenConfiguration = MavenPlugin.getMavenConfiguration();
        this.maven = MavenPlugin.getMaven();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.runtimeManager.reset();
        this.defaultRuntime = this.runtimeManager.getRuntime("DEFAULT").getName();
        this.runtimes = this.runtimeManager.getMavenRuntimes(false);
        this.runtimesViewer.setInput(this.runtimes);
        this.refreshRuntimesViewer();
        super.performDefaults();
    }

    public boolean performOk() {
        this.runtimeManager.setRuntimes(this.runtimes);
        this.runtimeManager.setDefaultRuntime(this.getDefaultRuntime());
        return true;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginRight = 5;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Label link = new Label(composite, 0);
        link.setLayoutData((Object)new GridData(4, 128, false, false, 3, 1));
        link.setText(Messages.MavenInstallationsPreferencePage_link);
        this.createTable(composite);
        new Label(composite, 0);
        this.defaultRuntime = this.runtimeManager.getRuntime("DEFAULT").getName();
        this.runtimes = this.runtimeManager.getMavenRuntimes(false);
        this.runtimesViewer.setInput(this.runtimes);
        this.refreshRuntimesViewer();
        return composite;
    }

    private AbstractMavenRuntime getDefaultRuntime() {
        AbstractMavenRuntime embedded = null;
        for (AbstractMavenRuntime runtime : this.runtimes) {
            if (this.defaultRuntime.equals(runtime.getName())) {
                return runtime;
            }
            if (!"EMBEDDED".equals(runtime.getName())) continue;
            embedded = runtime;
        }
        return embedded;
    }

    protected void refreshRuntimesViewer() {
        this.runtimesViewer.refresh();
        Object[] checkedElements = this.runtimesViewer.getCheckedElements();
        if (checkedElements == null || checkedElements.length == 0) {
            AbstractMavenRuntime runtime = this.getDefaultRuntime();
            this.runtimesViewer.setChecked((Object)runtime, true);
            this.defaultRuntime = runtime.getName();
        }
        TableColumn[] tableColumnArray = this.runtimesViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    protected AbstractMavenRuntime getSelectedMavenRuntime() {
        IStructuredSelection sel = (IStructuredSelection)this.runtimesViewer.getSelection();
        return (AbstractMavenRuntime)sel.getFirstElement();
    }

    private void createTable(Composite composite) {
        this.runtimesViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67584);
        this.runtimesViewer.setLabelProvider((IBaseLabelProvider)new RuntimesLabelProvider());
        this.runtimesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object input) {
                List list;
                if (input instanceof List && (list = (List)input).size() > 0) {
                    return list.toArray(new AbstractMavenRuntime[list.size()]);
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        Table table = this.runtimesViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData gd_table = new GridData(4, 4, true, true, 2, 3);
        gd_table.heightHint = 151;
        gd_table.widthHint = 333;
        table.setLayoutData((Object)gd_table);
        TableColumn tblclmnName = new TableColumn(table, 0);
        tblclmnName.setWidth(100);
        tblclmnName.setText(Messages.MavenInstallationsPreferencePage_tblclmnName_text);
        TableColumn tblclmnDetails = new TableColumn(table, 0);
        tblclmnDetails.setWidth(100);
        tblclmnDetails.setText(Messages.MavenInstallationsPreferencePage_tblclmnDetails_text);
        Button addButton = new Button(composite, 0);
        addButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addButton.setText(Messages.MavenInstallationsPreferencePage_btnAdd);
        addButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            MavenInstallationWizard wizard = new MavenInstallationWizard(this.getForbiddenNames(null));
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                this.runtimes.add(wizard.getResult());
                this.refreshRuntimesViewer();
            }
        }));
        Button editButton = new Button(composite, 0);
        editButton.setLayoutData((Object)new GridData(4, 128, false, false));
        editButton.setEnabled(false);
        editButton.setText(Messages.MavenInstallationsPreferencePage_btnEdit);
        editButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            AbstractMavenRuntime runtime = this.getSelectedMavenRuntime();
            MavenInstallationWizard wizard = new MavenInstallationWizard(runtime, this.getForbiddenNames(runtime));
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                AbstractMavenRuntime updatedRuntime = wizard.getResult();
                int i = 0;
                while (i < this.runtimes.size()) {
                    if (runtime == this.runtimes.get(i)) {
                        this.runtimes.set(i, updatedRuntime);
                        break;
                    }
                    ++i;
                }
                this.refreshRuntimesViewer();
            }
        }));
        Button removeButton = new Button(composite, 0);
        removeButton.setEnabled(false);
        removeButton.setLayoutData((Object)new GridData(4, 128, false, false));
        removeButton.setText(Messages.MavenInstallationsPreferencePage_btnRemove);
        removeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            AbstractMavenRuntime runtime = this.getSelectedMavenRuntime();
            this.runtimes.remove(runtime);
            this.refreshRuntimesViewer();
        }));
        this.runtimesViewer.addSelectionChangedListener(event -> {
            if (this.runtimesViewer.getSelection() instanceof IStructuredSelection) {
                AbstractMavenRuntime runtime = this.getSelectedMavenRuntime();
                boolean isEnabled = runtime != null && runtime.isEditable();
                removeButton.setEnabled(isEnabled);
                editButton.setEnabled(isEnabled);
            }
        });
        this.runtimesViewer.addCheckStateListener(event -> this.setCheckedRuntime((AbstractMavenRuntime)event.getElement()));
        Label noteLabel = new Label(composite, 64);
        GridData noteLabelData = new GridData(4, 128, false, false, 2, 1);
        noteLabelData.widthHint = 100;
        noteLabel.setLayoutData((Object)noteLabelData);
        noteLabel.setText(Messages.MavenInstallationsPreferencePage_lblNote);
    }

    protected Set<String> getForbiddenNames(AbstractMavenRuntime runtime) {
        HashSet<String> names = new HashSet<String>();
        for (AbstractMavenRuntime other : this.runtimes) {
            if (other == runtime) continue;
            names.add(other.getName());
        }
        return names;
    }

    protected void setCheckedRuntime(AbstractMavenRuntime runtime) {
        this.runtimesViewer.setAllChecked(false);
        if (runtime == null || !runtime.isAvailable()) {
            runtime = this.getDefaultRuntime();
        } else {
            this.defaultRuntime = runtime.getName();
        }
        this.runtimesViewer.setChecked((Object)runtime, true);
    }

    static class RuntimesLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        RuntimesLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            AbstractMavenRuntime runtime = (AbstractMavenRuntime)element;
            switch (columnIndex) {
                case 0: {
                    return !runtime.isLegacy() ? runtime.getName() : null;
                }
                case 1: {
                    StringBuilder sb = new StringBuilder();
                    if (!runtime.isAvailable()) {
                        sb.append(Messages.MavenInstallationsPreferencePage_runtimeUnavailable);
                    }
                    sb.append(runtime.toString());
                    return sb.toString();
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1 && !((AbstractMavenRuntime)element).isAvailable()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            AbstractMavenRuntime runtime = (AbstractMavenRuntime)element;
            if (!runtime.isEditable()) {
                return Display.getCurrent().getSystemColor(16);
            }
            return null;
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

