/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.ruler.commands;

import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.DiagramGuide;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Alignment;
import org.eclipse.gmf.runtime.notation.Guide;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

public class ChangeGuideCommand
extends AbstractTransactionalCommand {
    private EditPartViewer editPartViewer;
    private IAdaptable adapterPart = null;
    private View attachedPart = null;
    private Guide theNewGuide;
    private Alignment theNewAlign;
    private boolean horizontal;

    public ChangeGuideCommand(TransactionalEditingDomain editingDomain, EditPartViewer viewer, IAdaptable part, boolean horizontalGuide) {
        super(editingDomain, null, null);
        this.editPartViewer = viewer;
        this.adapterPart = part;
        this.horizontal = horizontalGuide;
    }

    public ChangeGuideCommand(TransactionalEditingDomain editingDomain, View part, boolean horizontalGuide) {
        super(editingDomain, null, null);
        this.attachedPart = part;
        this.horizontal = horizontalGuide;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Guide theOldGuide;
        Guide guide = theOldGuide = this.horizontal ? DiagramGuide.getInstance().getHorizontalGuide(this.attachedPart) : DiagramGuide.getInstance().getVerticalGuide(this.attachedPart);
        if (theOldGuide != null) {
            theOldGuide.getNodeMap().remove((Object)this.getViewNode());
        }
        if (this.theNewGuide != null) {
            this.theNewGuide.getNodeMap().put((Object)this.getViewNode(), (Object)this.theNewAlign);
        }
        this.editPartViewer = null;
        this.adapterPart = null;
        this.attachedPart = null;
        this.theNewGuide = null;
        this.theNewAlign = null;
        return CommandResult.newOKCommandResult();
    }

    public void setNewGuide(Guide guide, int alignment) {
        this.theNewGuide = guide;
        int value = 0;
        switch (alignment) {
            case -1: {
                value = this.horizontal ? 3 : 0;
                break;
            }
            case 0: {
                value = 2;
                break;
            }
            case 1: {
                value = this.horizontal ? 4 : 1;
            }
        }
        this.theNewAlign = Alignment.get((int)value);
    }

    private Node getViewNode() {
        if (this.adapterPart != null && this.attachedPart != null) {
            Map epRegistry = this.editPartViewer.getEditPartRegistry();
            IGraphicalEditPart attachedEP = (IGraphicalEditPart)epRegistry.get(this.adapterPart.getAdapter(View.class));
            this.attachedPart = (View)attachedEP.getModel();
        }
        return (Node)this.attachedPart;
    }
}

