/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions.breakpoints;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDynamicPrintf;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.ui.actions.breakpoints.Messages;
import org.eclipse.cdt.debug.ui.breakpoints.AbstractToggleBreakpointAdapter;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleDynamicPrintfAdapter
extends AbstractToggleBreakpointAdapter {
    @Override
    protected ICLineBreakpoint findLineBreakpoint(String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        return CDIDebugModel.lineBreakpointExists((String)sourceHandle, (IResource)resource, (int)lineNumber);
    }

    @Override
    protected void createLineBreakpoint(boolean interactive, IWorkbenchPart part, String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        if (interactive) {
            ICDynamicPrintf dprintf = (ICDynamicPrintf)CDIDebugModel.createBlankLineDynamicPrintf();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            CDIDebugModel.setLineBreakpointAttributes(attributes, (String)sourceHandle, (Integer)this.getBreakpointType(), (int)lineNumber, (boolean)true, (int)0, (String)"");
            attributes.put("org.eclipse.cdt.debug.core.printf_string", NLS.bind((String)Messages.Default_LineDynamicPrintf_String, (Object)ToggleDynamicPrintfAdapter.escapeBackslashes(sourceHandle), (Object)lineNumber));
            this.openBreakpointPropertiesDialog((ICBreakpoint)dprintf, part, resource, attributes);
        } else {
            String printfStr = NLS.bind((String)Messages.Default_LineDynamicPrintf_String, (Object)ToggleDynamicPrintfAdapter.escapeBackslashes(sourceHandle), (Object)lineNumber);
            CDIDebugModel.createLineDynamicPrintf((String)sourceHandle, (IResource)resource, (int)this.getBreakpointType(), (int)lineNumber, (boolean)true, (int)0, (String)"", (String)printfStr, (boolean)true);
        }
    }

    @Override
    protected ICFunctionBreakpoint findFunctionBreakpoint(String sourceHandle, IResource resource, String functionName) throws CoreException {
        return CDIDebugModel.functionBreakpointExists((String)sourceHandle, (IResource)resource, (String)functionName);
    }

    @Override
    protected void createFunctionBreakpoint(boolean interactive, IWorkbenchPart part, String sourceHandle, IResource resource, String functionName, int charStart, int charEnd, int lineNumber) throws CoreException {
        if (interactive) {
            ICDynamicPrintf dprintf = (ICDynamicPrintf)CDIDebugModel.createBlankFunctionDynamicPrintf();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            CDIDebugModel.setFunctionBreakpointAttributes(attributes, (String)sourceHandle, (int)this.getBreakpointType(), (String)functionName, (int)charStart, (int)charEnd, (int)lineNumber, (boolean)true, (int)0, (String)"");
            dprintf.setPrintfString(NLS.bind((String)Messages.Default_FunctionDynamicPrintf_String, (Object)ToggleDynamicPrintfAdapter.escapeBackslashes(sourceHandle), (Object)functionName));
            this.openBreakpointPropertiesDialog((ICBreakpoint)dprintf, part, resource, attributes);
        } else {
            String printfStr = NLS.bind((String)Messages.Default_FunctionDynamicPrintf_String, (Object)ToggleDynamicPrintfAdapter.escapeBackslashes(sourceHandle), (Object)functionName);
            CDIDebugModel.createFunctionDynamicPrintf((String)sourceHandle, (IResource)resource, (int)this.getBreakpointType(), (String)functionName, (int)charStart, (int)charEnd, (int)lineNumber, (boolean)true, (int)0, (String)"", (String)printfStr, (boolean)true);
        }
    }

    @Override
    protected ICWatchpoint findWatchpoint(String sourceHandle, IResource resource, String expression) throws CoreException {
        return null;
    }

    @Override
    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    @Override
    protected void createWatchpoint(boolean interactive, IWorkbenchPart part, String sourceHandle, IResource resource, int charStart, int charEnd, int lineNumber, String expression, String memorySpace, String range) throws CoreException {
    }

    @Override
    public boolean canCreateEventBreakpointsInteractive(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    @Override
    protected void createEventBreakpoint(boolean interactive, IWorkbenchPart part, IResource resource, String type, String arg) throws CoreException {
    }

    protected int getBreakpointType() {
        return 0;
    }

    private static String escapeBackslashes(String str) {
        return str.replaceAll(Pattern.quote("\\"), "\\\\\\\\");
    }
}

