/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.core.filetransfer;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.tcf.te.runtime.services.interfaces.filetransfer.IFileTransferItem;
import org.eclipse.tcf.te.tcf.launch.core.nls.Messages;

public class FileTransferItemValidator {
    public static final Map<String, String> validate(IFileTransferItem item) {
        int direction;
        Assert.isNotNull((Object)item);
        HashMap<String, String> invalid = new HashMap<String, String>();
        String host = item.getStringProperty("host");
        String target = item.getStringProperty("target-string");
        int n = direction = item.getProperty("direction") != null ? item.getIntProperty("direction") : 1;
        if (host == null || host.trim().length() == 0) {
            if (direction == 1) {
                invalid.put("host", Messages.FileTransferItemValidator_missingFile);
            } else {
                invalid.put("host", Messages.FileTransferItemValidator_missingFileOrDirectory);
            }
        } else {
            Path hostPath = new Path(host);
            File hostFile = hostPath.toFile();
            if (direction == 1) {
                if (!(hostFile.exists() && hostFile.isFile() && hostFile.canRead())) {
                    invalid.put("host", Messages.FileTransferItemValidator_notExistingFile);
                }
            } else if (hostFile.isFile() && !hostFile.canWrite() || hostFile.isDirectory() && (!hostFile.exists() || !hostFile.canWrite())) {
                invalid.put("host", Messages.FileTransferItemValidator_notExistingFileOrDirectory);
            }
        }
        if (target == null || target.trim().length() == 0) {
            if (direction == 1) {
                invalid.put("target-string", Messages.FileTransferItemValidator_missingFileOrDirectory);
            } else {
                invalid.put("target-string", Messages.FileTransferItemValidator_missingFile);
            }
        } else {
            Path targetPath = new Path(target);
            if (direction == 1) {
                if (!targetPath.isValidPath(target)) {
                    invalid.put("target-string", Messages.FileTransferItemValidator_invalidFileOrDirectory);
                }
            } else if (!targetPath.isValidPath(target)) {
                invalid.put("target-string", Messages.FileTransferItemValidator_invalidFile);
            }
        }
        return invalid.isEmpty() ? null : invalid;
    }
}

