/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.services;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.IServiceFactory;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.tools.util.ReferenceCounted;

public class SharedServiceFactory<S>
implements IServiceFactory {
    private final Class<? extends S> serviceInterface;
    private final Supplier<? extends S> serviceCreator;
    private final Function<? super ServicesRegistry, Scope> scopeProvider;
    private Scope scope;
    private S serviceInstance;

    protected SharedServiceFactory(Class<? extends S> serviceInterface) {
        this(serviceInterface, null, null);
    }

    protected SharedServiceFactory(Class<? extends S> serviceInterface, Supplier<? extends S> serviceCreator) {
        this(serviceInterface, serviceCreator, null);
    }

    protected SharedServiceFactory(Class<? extends S> serviceInterface, Supplier<? extends S> serviceCreator, Function<? super ServicesRegistry, Scope> scopeProvider) {
        this.serviceInterface = serviceInterface;
        this.serviceCreator = serviceCreator != null ? serviceCreator : this::createSharedInstance;
        this.scopeProvider = scopeProvider != null ? scopeProvider : __ -> Scope.GLOBAL_SCOPE;
    }

    @Override
    public final void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.scope = this.scopeProvider.apply(servicesRegistry);
    }

    @Override
    public final void startService() throws ServiceException {
    }

    @Override
    public final void disposeService() {
        if (this.serviceInstance != null) {
            this.serviceInstance = null;
            this.scope.maybeGetService(this.serviceInterface).ifPresent(ReferenceCounted::release);
            this.scope = null;
        }
    }

    @Override
    public final Object createServiceInstance() throws ServiceException {
        if (this.serviceInstance == null) {
            try {
                this.serviceInstance = this.serviceInterface.cast(this.getCountedService().retain());
            }
            catch (ClassCastException e) {
                this.getCountedService().release();
                throw new ServiceException("Incompatible service type", e);
            }
        }
        return this.serviceInstance;
    }

    private ReferenceCounted<?> getCountedService() throws ServiceException {
        return this.scope.getService(this.serviceInterface, this);
    }

    protected S createSharedInstance() {
        throw new UnsupportedOperationException("createSharedInstance");
    }

    protected void start(S sharedInstance) throws ServiceException {
        if (sharedInstance instanceof IService) {
            ((IService)sharedInstance).startService();
        }
    }

    protected void dispose(S sharedInstance) throws ServiceException {
        if (sharedInstance instanceof IService) {
            ((IService)sharedInstance).disposeService();
        }
    }

    public static class Scope {
        public static final Scope GLOBAL_SCOPE = new Scope();
        private final Map<Class<?>, ReferenceCounted<?>> serviceInstances = new ConcurrentHashMap();

        public <S> S getService(Class<S> serviceInterface) {
            return this.maybeGetService(serviceInterface).map(serviceInterface::cast).orElse(null);
        }

        Optional<ReferenceCounted<?>> maybeGetService(Class<?> serviceInterface) {
            return Optional.ofNullable(this.serviceInstances.get(serviceInterface));
        }

        <S> ReferenceCounted<?> getService(Class<? extends S> serviceInterface, SharedServiceFactory<S> factory) throws ServiceException {
            try {
                return this.serviceInstances.computeIfAbsent(serviceInterface, type -> {
                    Object sharedInstance = factory.serviceCreator.get();
                    try {
                        factory.start(sharedInstance);
                    }
                    catch (ServiceException e) {
                        throw new WrappedException((Exception)e);
                    }
                    return new ReferenceCounted(sharedInstance, () -> {
                        this.serviceInstances.remove(type);
                        try {
                            factory.dispose(sharedInstance);
                        }
                        catch (Exception e) {
                            Activator.log.error("Shared service instance not successfully disposed", (Throwable)e);
                        }
                    });
                });
            }
            catch (WrappedException e) {
                throw (ServiceException)e.exception();
            }
        }
    }
}

