/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.creation;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jwt.meta.model.core.Model;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.misc.wizards.WizardHelper;
import org.eclipse.jwt.we.misc.wizards.creation.CreationWizardPageFileName;
import org.eclipse.jwt.we.misc.wizards.creation.CreationWizardPageProject;
import org.eclipse.jwt.we.misc.wizards.template.imp.ImportTemplateWizardPage;
import org.eclipse.jwt.we.model.view.Diagram;
import org.eclipse.jwt.we.model.view.impl.ViewFactoryImpl;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class CreationWizard2
extends Wizard
implements INewWizard {
    static final Logger logger = Logger.getLogger(CreationWizard2.class);
    protected ImportTemplateWizardPage importTemplatePage;
    protected CreationWizardPageFileName selectFilenamePage;
    protected CreationWizardPageProject selectProjectPage;
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected URI newFileURI;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        if (selection == null) {
            selection = new StructuredSelection();
        }
        this.setWindowTitle(PluginProperties.menu_WE_item);
        this.setDefaultPageImageDescriptor(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createImageDescriptor(PluginProperties.editor_Wizard_icon));
    }

    public void addPages() {
        this.selectProjectPage = new CreationWizardPageProject("project_page", this.selection);
        this.selectProjectPage.setTitle(PluginProperties.menu_WE_item);
        this.selectProjectPage.setDescription(PluginProperties.editor_Wizard_description);
        this.addPage((IWizardPage)this.selectProjectPage);
        this.selectFilenamePage = new CreationWizardPageFileName("filename_page2", false);
        this.selectFilenamePage.setTitle(PluginProperties.menu_WE_item);
        this.selectFilenamePage.setDescription(PluginProperties.editor_Wizard_description);
        this.addPage((IWizardPage)this.selectFilenamePage);
        this.importTemplatePage = new ImportTemplateWizardPage("template_page2", this.workbench);
        this.importTemplatePage.setTitle(PluginProperties.wizards_ImportTemplateWizard_title);
        this.importTemplatePage.setDescription(PluginProperties.wizards_ImportSelect_label);
        this.addPage((IWizardPage)this.importTemplatePage);
        this.importTemplatePage.setCreationMode(true);
    }

    public String getPackageName() {
        return this.selectFilenamePage.getPackageName();
    }

    public String getActivityName() {
        return this.selectFilenamePage.getActivityName();
    }

    public String getAuthor() {
        return this.selectFilenamePage.getAuthor();
    }

    public String getVersion() {
        return this.selectFilenamePage.getVersion();
    }

    public boolean getStandardPackages() {
        return this.selectFilenamePage.getStandardPackages();
    }

    public ArrayList getTemplates() {
        return this.importTemplatePage.getTemplates();
    }

    public URI getNewFileURI() {
        return this.newFileURI;
    }

    public void setNewFileURI(URI newFileURI) {
        this.newFileURI = newFileURI;
    }

    public boolean performFinish() {
        try {
            String filename = this.selectProjectPage.getFileName();
            if (!filename.endsWith(WEEditor.getWorkflowExtension())) {
                filename = String.valueOf(filename) + "." + WEEditor.getWorkflowExtension();
            }
            this.selectProjectPage.setFileName(filename);
            IFile file = this.selectProjectPage.createNewFile();
            final URI fileWorkflowUri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            final URI fileDiagramUri = fileWorkflowUri.trimFileExtension().appendFileExtension(WEEditor.getDiagramExtension());
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            Resource resourceWorkflow = resourceSet.createResource(fileWorkflowUri);
                            Resource resourceDiagram = resourceSet.createResource(fileDiagramUri);
                            EObject rootObject = WizardHelper.createResources(CreationWizard2.this.getPackageName(), CreationWizard2.this.getActivityName(), CreationWizard2.this.getAuthor(), CreationWizard2.this.getVersion(), CreationWizard2.this.getStandardPackages(), CreationWizard2.this.getTemplates());
                            if (rootObject != null) {
                                resourceWorkflow.getContents().add((Object)rootObject);
                            }
                            Diagram diagramData = ViewFactoryImpl.eINSTANCE.createDiagram();
                            diagramData.setDescribesModel((Model)rootObject);
                            resourceDiagram.getContents().add((Object)diagramData);
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", "UTF-8");
                            resourceWorkflow.save(options);
                            resourceDiagram.save(options);
                        }
                        catch (Exception exception) {
                            logger.warning(exception);
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, operation);
            String relativePath = file.getFullPath().toString();
            URI platformURI = URI.createPlatformResourceURI((String)relativePath, (boolean)false);
            this.setNewFileURI(CommonPlugin.resolve((URI)platformURI));
            GeneralHelper.switchToWEPerspective();
            Plugin.openEditor(PlatformUI.getWorkbench(), this.newFileURI);
            return true;
        }
        catch (Exception exception) {
            logger.warning(exception);
            return false;
        }
    }

    public void dispose() {
        super.dispose();
        this.workbench = null;
        this.selection = null;
    }
}

