/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jwt.meta.commands.helper.CommandHelper;
import org.eclipse.jwt.meta.model.core.GraphicalElement;
import org.eclipse.jwt.meta.model.core.Model;
import org.eclipse.jwt.meta.model.core.ReferenceableElement;
import org.eclipse.jwt.meta.model.data.Data;
import org.eclipse.jwt.meta.model.processes.Action;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.meta.model.processes.ActivityEdge;
import org.eclipse.jwt.meta.model.processes.ActivityLinkNode;
import org.eclipse.jwt.meta.model.processes.ActivityNode;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.model.view.Diagram;
import org.eclipse.jwt.we.model.view.EdgeDirection;
import org.eclipse.jwt.we.model.view.LayoutData;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.jwt.we.model.view.ReferenceEdge;
import org.eclipse.jwt.we.model.view.impl.ViewFactoryImpl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFHelper
extends CommandHelper {
    private static Logger log = Logger.getLogger(EMFHelper.class);

    public static Model getRoot(WEEditor editor) {
        return (Model)editor.getModel();
    }

    public static Diagram getDiagram(WEEditor editor) {
        return editor.getDiagramData();
    }

    public static Set collectReferencedElements(WEEditor editor, Set relevantElements, boolean returnReferences) {
        HashSet<Object> result = new HashSet<Object>();
        TreeIterator iter = EMFHelper.getRoot(editor).eAllContents();
        while (iter.hasNext()) {
            Activity activity;
            EObject eobject = (EObject)iter.next();
            if (!(eobject instanceof ActivityLinkNode) || !relevantElements.contains(activity = ((ActivityLinkNode)eobject).getLinksto())) continue;
            if (returnReferences) {
                result.add(eobject);
                continue;
            }
            result.add(activity);
        }
        for (Object object : EMFHelper.getDiagram(editor).getReferences()) {
            ReferenceableElement refElem = ((Reference)object).getReference();
            if (!relevantElements.contains(refElem)) continue;
            if (returnReferences) {
                result.add(object);
                continue;
            }
            result.add(refElem);
        }
        return result;
    }

    public static void unsetUnconnectedRefElements(WEEditor editor, Collection objectList) {
        for (EObject eObject : objectList) {
            if (!(eObject instanceof Action)) continue;
            BasicEList connectedReferenceableElements = new BasicEList();
            for (ReferenceEdge refEdge : EMFHelper.getReferenceEdgesForAction(editor, (Action)eObject)) {
                connectedReferenceableElements.add((Object)refEdge.getReference().getReference());
            }
            EList actionEReferences = eObject.eClass().getEReferences();
            for (EReference reference : actionEReferences) {
                if (!reference.isMany()) {
                    EObject referenceValue = (EObject)eObject.eGet((EStructuralFeature)reference);
                    if (!(referenceValue instanceof ReferenceableElement) || connectedReferenceableElements.contains((Object)referenceValue)) continue;
                    eObject.eUnset((EStructuralFeature)reference);
                    continue;
                }
                EList referenceValues = (EList)eObject.eGet((EStructuralFeature)reference);
                BasicEList removeValues = new BasicEList();
                for (Object referenceValue : referenceValues) {
                    if (!(referenceValue instanceof ReferenceableElement) || connectedReferenceableElements.contains(referenceValue)) continue;
                    removeValues.add(referenceValue);
                }
                referenceValues.removeAll((Collection)removeValues);
            }
        }
    }

    public static Set getAffectedEdges(Collection affectedObjects) {
        HashSet<Object> affectedEdges = new HashSet<Object>();
        for (EObject object : affectedObjects) {
            if (object instanceof ActivityNode) {
                ActivityNode activityNode = (ActivityNode)object;
                for (ActivityEdge actEdge : activityNode.getIn()) {
                    if (!affectedObjects.contains(actEdge.getSource())) continue;
                    affectedEdges.add(actEdge);
                }
                for (ActivityEdge actEdge : activityNode.getOut()) {
                    if (!affectedObjects.contains(actEdge.getTarget())) continue;
                    affectedEdges.add(actEdge);
                }
            }
            if (!(object instanceof Reference)) continue;
            Reference reference = (Reference)object;
            for (ReferenceEdge refEdge : reference.getReferenceEdges()) {
                if (!affectedObjects.contains(refEdge.getAction())) continue;
                affectedEdges.add(refEdge);
            }
        }
        return affectedEdges;
    }

    public static EList<ReferenceEdge> getReferenceEdgesForAction(WEEditor editor, Action action) {
        BasicEList referenceEdges = new BasicEList();
        for (Object referenceEdge : EMFHelper.getDiagram(editor).getReferenceEdges()) {
            if (((ReferenceEdge)referenceEdge).getAction() == null || !((ReferenceEdge)referenceEdge).getAction().equals(action)) continue;
            referenceEdges.add((Object)((ReferenceEdge)referenceEdge));
        }
        return referenceEdges;
    }

    public static ReferenceEdge getReferenceEdgeForAction(WEEditor editor, Action action, ReferenceableElement refElem) {
        for (Object referenceEdge : EMFHelper.getDiagram(editor).getReferenceEdges()) {
            if (referenceEdge == null || ((ReferenceEdge)referenceEdge).getAction() == null || !((ReferenceEdge)referenceEdge).getAction().equals(action) || ((ReferenceEdge)referenceEdge).getReference().getReference() != refElem) continue;
            return (ReferenceEdge)referenceEdge;
        }
        return null;
    }

    public static EList<ReferenceEdge> getReferenceEdgesForScope(WEEditor editor, Scope scope) {
        BasicEList referenceEdges = new BasicEList();
        for (Object referenceEdge : EMFHelper.getDiagram(editor).getReferenceEdges()) {
            if (((ReferenceEdge)referenceEdge).getContainedIn() == null || !((ReferenceEdge)referenceEdge).getContainedIn().equals(scope)) continue;
            referenceEdges.add((Object)((ReferenceEdge)referenceEdge));
        }
        return referenceEdges;
    }

    public static ReferenceEdge getReferenceEdgeForScope(WEEditor editor, Scope scope, ReferenceableElement refElem) {
        for (Object referenceEdge : EMFHelper.getDiagram(editor).getReferenceEdges()) {
            if (!((ReferenceEdge)referenceEdge).getContainedIn().equals(scope) || ((ReferenceEdge)referenceEdge).getReference().getReference() != refElem) continue;
            return (ReferenceEdge)referenceEdge;
        }
        return null;
    }

    public static EList<Reference> getReferencesForScope(WEEditor editor, Scope scope) {
        BasicEList references = new BasicEList();
        for (Object reference : EMFHelper.getDiagram(editor).getReferences()) {
            if (((Reference)reference).getContainedIn() == null || !((Reference)reference).getContainedIn().equals(scope)) continue;
            references.add((Object)((Reference)reference));
        }
        return references;
    }

    public static Reference getReferenceForScope(WEEditor editor, Scope scope, ReferenceableElement refElem) {
        for (Object reference : EMFHelper.getDiagram(editor).getReferences()) {
            if (((Reference)reference).getContainedIn() == null || !((Reference)reference).getContainedIn().equals(scope) || ((Reference)reference).getReference() != refElem) continue;
            return (Reference)reference;
        }
        return null;
    }

    public static Collection getAllContainedReferenceEdges(WEEditor editor, Collection collection) {
        ArrayList<ReferenceEdge> result = new ArrayList<ReferenceEdge>();
        for (Object object : collection) {
            if (object instanceof Scope) {
                result.addAll((Collection<ReferenceEdge>)EMFHelper.getReferenceEdgesForScope(editor, (Scope)object));
            }
            if (!(object instanceof EObject) || ((EObject)object).eContents() == null) continue;
            result.addAll(EMFHelper.getAllContainedReferenceEdges(editor, (Collection)((EObject)object).eContents()));
        }
        return result;
    }

    public static Collection getAllContainedReferences(WEEditor editor, Collection collection) {
        ArrayList<Reference> result = new ArrayList<Reference>();
        for (Object object : collection) {
            if (object instanceof Scope) {
                result.addAll((Collection<Reference>)EMFHelper.getReferencesForScope(editor, (Scope)object));
            }
            if (!(object instanceof EObject) || ((EObject)object).eContents() == null) continue;
            result.addAll(EMFHelper.getAllContainedReferences(editor, (Collection)((EObject)object).eContents()));
        }
        return result;
    }

    public static void cleanViewData(WEEditor editor) {
        log.debug("running garbage collection to remove unneccesary view data");
        try {
            Object object;
            Object[] layoutDatas = editor.getDiagramData().getLayoutData().toArray();
            Object[] references = editor.getDiagramData().getReferences().toArray();
            Object[] referenceEdges = editor.getDiagramData().getReferenceEdges().toArray();
            BasicEList allModelElements = new BasicEList();
            TreeIterator iter = editor.getMainModelResource().getAllContents();
            while (iter.hasNext()) {
                allModelElements.add((Object)((EObject)iter.next()));
            }
            Object[] objectArray = referenceEdges;
            int n = referenceEdges.length;
            int n2 = 0;
            while (n2 < n) {
                object = objectArray[n2];
                ReferenceEdge refEdge = (ReferenceEdge)object;
                if (refEdge.getContainedIn() == null || !allModelElements.contains((Object)refEdge.getContainedIn()) || refEdge.getAction() == null || refEdge.getReference() == null) {
                    refEdge.setAction(null);
                    refEdge.setReference(null);
                    refEdge.setContainedIn(null);
                    editor.getDiagramData().getLayoutData().remove((Object)refEdge);
                }
                ++n2;
            }
            objectArray = references;
            n = references.length;
            n2 = 0;
            while (n2 < n) {
                object = objectArray[n2];
                Reference ref = (Reference)object;
                if (ref.getContainedIn() == null || !allModelElements.contains((Object)ref.getContainedIn()) || ref.getReference() == null) {
                    ref.setReference(null);
                    ref.setContainedIn(null);
                    editor.getDiagramData().getLayoutData().remove((Object)ref);
                }
                ++n2;
            }
            objectArray = layoutDatas;
            n = layoutDatas.length;
            n2 = 0;
            while (n2 < n) {
                object = objectArray[n2];
                LayoutData ld = (LayoutData)object;
                GraphicalElement target = ld.getDescribesElement();
                if (ld.getDescribesElement() == null || !allModelElements.contains((Object)target) && !editor.getDiagramData().getReferences().contains((Object)target)) {
                    ld.setDescribesElement(null);
                    editor.getDiagramData().getLayoutData().remove((Object)ld);
                }
                ++n2;
            }
            layoutDatas = null;
            references = null;
            referenceEdges = null;
            allModelElements.clear();
            allModelElements = null;
        }
        catch (Exception e) {
            log.severe("error running view data garbage collection");
            e.printStackTrace();
        }
    }

    public static void correctReferences(WEEditor editor, boolean currentlySaving) {
        log.debug("running consistency check for references/referenceedges");
        try {
            Boolean corrected = false;
            BasicEList allModelElements = new BasicEList();
            TreeIterator iter = editor.getMainModelResource().getAllContents();
            while (iter.hasNext()) {
                allModelElements.add((Object)((EObject)iter.next()));
            }
            BasicEList allActions = new BasicEList();
            TreeIterator iter2 = editor.getMainModelResource().getAllContents();
            while (iter2.hasNext()) {
                EObject object = (EObject)iter2.next();
                if (!(object instanceof Action)) continue;
                allActions.add((Object)((Action)object));
            }
            for (Action action : allActions) {
                BasicEList referenceableElements = new BasicEList();
                for (Object object : action.eCrossReferences()) {
                    if (!(object instanceof ReferenceableElement)) continue;
                    referenceableElements.add((Object)((ReferenceableElement)object));
                }
                for (ReferenceableElement refElem : referenceableElements) {
                    if (!allModelElements.contains((Object)refElem)) {
                        if (action.getExecutedBy() == refElem) {
                            action.setExecutedBy(null);
                        } else if (action.getPerformedBy() == refElem) {
                            action.setPerformedBy(null);
                        } else if (action.getInputs().contains((Object)refElem)) {
                            action.getInputs().remove((Object)refElem);
                        } else if (action.getOutputs().contains((Object)refElem)) {
                            action.getOutputs().remove((Object)refElem);
                        }
                        corrected = true;
                        continue;
                    }
                    ReferenceEdge refEdge = EMFHelper.getReferenceEdgeForAction(editor, action, refElem);
                    if (refEdge != null) continue;
                    corrected = true;
                    Reference newReference = ViewFactoryImpl.eINSTANCE.createReference();
                    ReferenceEdge newReferenceEdge = ViewFactoryImpl.eINSTANCE.createReferenceEdge();
                    editor.getDiagramData().getReferences().add((Object)newReference);
                    editor.getDiagramData().getReferenceEdges().add((Object)newReferenceEdge);
                    newReference.setContainedIn((Scope)action.eContainer());
                    newReference.setReference(refElem);
                    newReferenceEdge.setAction(action);
                    newReferenceEdge.setContainedIn((Scope)action.eContainer());
                    newReferenceEdge.setReference(newReference);
                    EdgeDirection edgeDirection = EdgeDirection.NONE;
                    if (refElem instanceof Data) {
                        if (action.getInputs().contains((Object)refElem) && action.getOutputs().contains((Object)refElem)) {
                            edgeDirection = EdgeDirection.INOUT;
                        } else if (action.getInputs().contains((Object)refElem)) {
                            edgeDirection = EdgeDirection.IN;
                        } else if (action.getOutputs().contains((Object)refElem)) {
                            edgeDirection = EdgeDirection.OUT;
                        }
                    }
                    newReferenceEdge.setDirection(edgeDirection);
                }
            }
            if (corrected.booleanValue()) {
                boolean save = true;
                if (!GeneralHelper.isjUnitMode()) {
                    if (currentlySaving) {
                        save = false;
                        MessageDialog.openInformation((Shell)editor.getEditorSite().getShell(), (String)PluginProperties.editor_ErrorMessage_title, (String)NLS.bind((String)PluginProperties.editor_ErrorReferences2_message, (Object)editor.getEditorInput().getName()));
                    } else {
                        save = MessageDialog.openQuestion((Shell)editor.getEditorSite().getShell(), (String)PluginProperties.editor_ErrorMessage_title, (String)NLS.bind((String)PluginProperties.editor_ErrorReferences_message, (Object)editor.getEditorInput().getName()));
                    }
                }
                if (save) {
                    editor.doSave(null);
                }
            }
            allActions.clear();
            allActions = null;
        }
        catch (Exception e) {
            log.severe("error running consistency check for references/referenceedges");
            e.printStackTrace();
        }
    }
}

